// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchPersonalizationTwirp/twirp.proto

/*
Package TwitchPersonalizationTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchPersonalizationTwirp/twirp.proto
*/
package TwitchPersonalizationTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===============================
// TwitchPersonalization Interface
// ===============================

type TwitchPersonalization interface {
	GetPersonalization(context.Context, *GetPersonalizationRequest) (*GetPersonalizationResponse, error)

	UpdateDataSourceVersion(context.Context, *UpdateDataSourceVersionRequest) (*UpdateDataSourceVersionResponse, error)

	GetCGBundleSKUs(context.Context, *GetCGBundleSKUsRequest) (*GetCGBundleSKUsResponse, error)

	GetPurchaseReputation(context.Context, *GetPurchaseReputationRequest) (*GetPurchaseReputationResponse, error)

	GetHypeTrainConfigOverrides(context.Context, *GetHypeTrainConfigOverridesRequest) (*GetHypeTrainConfigOverridesResponse, error)

	GetATOScore(context.Context, *GetATOScoreRequest) (*GetATOScoreResponse, error)
}

// =====================================
// TwitchPersonalization Protobuf Client
// =====================================

type twitchPersonalizationProtobufClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewTwitchPersonalizationProtobufClient creates a Protobuf client that implements the TwitchPersonalization interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchPersonalizationProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchPersonalization {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchPersonalizationPathPrefix
	urls := [6]string{
		prefix + "GetPersonalization",
		prefix + "UpdateDataSourceVersion",
		prefix + "GetCGBundleSKUs",
		prefix + "GetPurchaseReputation",
		prefix + "GetHypeTrainConfigOverrides",
		prefix + "GetATOScore",
	}

	return &twitchPersonalizationProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchPersonalizationProtobufClient) GetPersonalization(ctx context.Context, in *GetPersonalizationRequest) (*GetPersonalizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetPersonalization")
	out := new(GetPersonalizationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationProtobufClient) UpdateDataSourceVersion(ctx context.Context, in *UpdateDataSourceVersionRequest) (*UpdateDataSourceVersionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDataSourceVersion")
	out := new(UpdateDataSourceVersionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationProtobufClient) GetCGBundleSKUs(ctx context.Context, in *GetCGBundleSKUsRequest) (*GetCGBundleSKUsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetCGBundleSKUs")
	out := new(GetCGBundleSKUsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationProtobufClient) GetPurchaseReputation(ctx context.Context, in *GetPurchaseReputationRequest) (*GetPurchaseReputationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetPurchaseReputation")
	out := new(GetPurchaseReputationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationProtobufClient) GetHypeTrainConfigOverrides(ctx context.Context, in *GetHypeTrainConfigOverridesRequest) (*GetHypeTrainConfigOverridesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetHypeTrainConfigOverrides")
	out := new(GetHypeTrainConfigOverridesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationProtobufClient) GetATOScore(ctx context.Context, in *GetATOScoreRequest) (*GetATOScoreResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetATOScore")
	out := new(GetATOScoreResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchPersonalization JSON Client
// =================================

type twitchPersonalizationJSONClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewTwitchPersonalizationJSONClient creates a JSON client that implements the TwitchPersonalization interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchPersonalizationJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchPersonalization {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchPersonalizationPathPrefix
	urls := [6]string{
		prefix + "GetPersonalization",
		prefix + "UpdateDataSourceVersion",
		prefix + "GetCGBundleSKUs",
		prefix + "GetPurchaseReputation",
		prefix + "GetHypeTrainConfigOverrides",
		prefix + "GetATOScore",
	}

	return &twitchPersonalizationJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchPersonalizationJSONClient) GetPersonalization(ctx context.Context, in *GetPersonalizationRequest) (*GetPersonalizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetPersonalization")
	out := new(GetPersonalizationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationJSONClient) UpdateDataSourceVersion(ctx context.Context, in *UpdateDataSourceVersionRequest) (*UpdateDataSourceVersionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDataSourceVersion")
	out := new(UpdateDataSourceVersionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationJSONClient) GetCGBundleSKUs(ctx context.Context, in *GetCGBundleSKUsRequest) (*GetCGBundleSKUsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetCGBundleSKUs")
	out := new(GetCGBundleSKUsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationJSONClient) GetPurchaseReputation(ctx context.Context, in *GetPurchaseReputationRequest) (*GetPurchaseReputationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetPurchaseReputation")
	out := new(GetPurchaseReputationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationJSONClient) GetHypeTrainConfigOverrides(ctx context.Context, in *GetHypeTrainConfigOverridesRequest) (*GetHypeTrainConfigOverridesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetHypeTrainConfigOverrides")
	out := new(GetHypeTrainConfigOverridesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPersonalizationJSONClient) GetATOScore(ctx context.Context, in *GetATOScoreRequest) (*GetATOScoreResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithMethodName(ctx, "GetATOScore")
	out := new(GetATOScoreResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// TwitchPersonalization Server Handler
// ====================================

type twitchPersonalizationServer struct {
	TwitchPersonalization
	hooks *twirp.ServerHooks
}

func NewTwitchPersonalizationServer(svc TwitchPersonalization, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchPersonalizationServer{
		TwitchPersonalization: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchPersonalizationServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchPersonalizationPathPrefix is used for all URL paths on a twirp TwitchPersonalization server.
// Requests are always: POST TwitchPersonalizationPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchPersonalizationPathPrefix = "/twirp/twitch.commerce.personalization.TwitchPersonalization/"

func (s *twitchPersonalizationServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.personalization")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPersonalization")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.commerce.personalization.TwitchPersonalization/GetPersonalization":
		s.serveGetPersonalization(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.personalization.TwitchPersonalization/UpdateDataSourceVersion":
		s.serveUpdateDataSourceVersion(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.personalization.TwitchPersonalization/GetCGBundleSKUs":
		s.serveGetCGBundleSKUs(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.personalization.TwitchPersonalization/GetPurchaseReputation":
		s.serveGetPurchaseReputation(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.personalization.TwitchPersonalization/GetHypeTrainConfigOverrides":
		s.serveGetHypeTrainConfigOverrides(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.personalization.TwitchPersonalization/GetATOScore":
		s.serveGetATOScore(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchPersonalizationServer) serveGetPersonalization(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPersonalizationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPersonalizationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPersonalizationServer) serveGetPersonalizationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPersonalization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPersonalizationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPersonalizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetPersonalization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPersonalizationResponse and nil error while calling GetPersonalization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetPersonalizationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPersonalization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPersonalizationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPersonalizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetPersonalization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPersonalizationResponse and nil error while calling GetPersonalization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveUpdateDataSourceVersion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateDataSourceVersionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateDataSourceVersionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPersonalizationServer) serveUpdateDataSourceVersionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDataSourceVersion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateDataSourceVersionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateDataSourceVersionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.UpdateDataSourceVersion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateDataSourceVersionResponse and nil error while calling UpdateDataSourceVersion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveUpdateDataSourceVersionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDataSourceVersion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateDataSourceVersionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateDataSourceVersionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.UpdateDataSourceVersion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateDataSourceVersionResponse and nil error while calling UpdateDataSourceVersion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetCGBundleSKUs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCGBundleSKUsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCGBundleSKUsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPersonalizationServer) serveGetCGBundleSKUsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCGBundleSKUs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCGBundleSKUsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCGBundleSKUsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetCGBundleSKUs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCGBundleSKUsResponse and nil error while calling GetCGBundleSKUs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetCGBundleSKUsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCGBundleSKUs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCGBundleSKUsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCGBundleSKUsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetCGBundleSKUs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCGBundleSKUsResponse and nil error while calling GetCGBundleSKUs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetPurchaseReputation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPurchaseReputationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPurchaseReputationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPersonalizationServer) serveGetPurchaseReputationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPurchaseReputation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPurchaseReputationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPurchaseReputationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetPurchaseReputation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPurchaseReputationResponse and nil error while calling GetPurchaseReputation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetPurchaseReputationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPurchaseReputation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPurchaseReputationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPurchaseReputationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetPurchaseReputation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPurchaseReputationResponse and nil error while calling GetPurchaseReputation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetHypeTrainConfigOverrides(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHypeTrainConfigOverridesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHypeTrainConfigOverridesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPersonalizationServer) serveGetHypeTrainConfigOverridesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHypeTrainConfigOverrides")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetHypeTrainConfigOverridesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetHypeTrainConfigOverridesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetHypeTrainConfigOverrides(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetHypeTrainConfigOverridesResponse and nil error while calling GetHypeTrainConfigOverrides. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetHypeTrainConfigOverridesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHypeTrainConfigOverrides")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetHypeTrainConfigOverridesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetHypeTrainConfigOverridesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetHypeTrainConfigOverrides(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetHypeTrainConfigOverridesResponse and nil error while calling GetHypeTrainConfigOverrides. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetATOScore(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetATOScoreJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetATOScoreProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPersonalizationServer) serveGetATOScoreJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetATOScore")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetATOScoreRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetATOScoreResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetATOScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetATOScoreResponse and nil error while calling GetATOScore. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) serveGetATOScoreProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetATOScore")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetATOScoreRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetATOScoreResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPersonalization.GetATOScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetATOScoreResponse and nil error while calling GetATOScore. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPersonalizationServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchPersonalizationServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchPersonalizationServer) PathPrefix() string {
	return TwitchPersonalizationPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1458 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0x4f, 0x53, 0x1b, 0xc9,
	0x15, 0xdf, 0x11, 0x7f, 0xf5, 0x04, 0x62, 0xb6, 0x0d, 0x66, 0x2c, 0x63, 0x60, 0x95, 0x64, 0x8b,
	0x25, 0x89, 0xd8, 0x62, 0xb7, 0x12, 0xd6, 0x9b, 0xb5, 0x2d, 0x24, 0x05, 0xab, 0x00, 0xa1, 0x1a,
	0x49, 0xd8, 0xce, 0x65, 0xaa, 0x99, 0x6e, 0xa1, 0x0e, 0xa3, 0x99, 0x71, 0x4f, 0x8f, 0xb0, 0x7c,
	0x4c, 0x25, 0xa7, 0x54, 0xae, 0x39, 0xe5, 0x92, 0x5b, 0xbe, 0x51, 0xbe, 0x41, 0xbe, 0x46, 0xb6,
	0xa6, 0xa7, 0xf5, 0x07, 0x81, 0x24, 0x8c, 0x2f, 0x2a, 0xf5, 0xef, 0xfd, 0xde, 0xeb, 0xd7, 0x6f,
	0x5e, 0xff, 0xba, 0x1b, 0x9e, 0xdb, 0x1e, 0xa1, 0xb9, 0x3f, 0x87, 0x81, 0x60, 0x6e, 0x4e, 0x74,
	0xf6, 0x70, 0xfb, 0xa3, 0xbb, 0x57, 0xbf, 0x66, 0xc2, 0x6e, 0x55, 0x29, 0x0f, 0x3c, 0x17, 0x3b,
	0xec, 0x23, 0x16, 0xcc, 0x73, 0xeb, 0xd7, 0x8c, 0xfb, 0x7b, 0x22, 0xfa, 0xcd, 0xf9, 0xdc, 0x13,
	0x1e, 0xda, 0x12, 0x92, 0x97, 0xb3, 0xbd, 0x76, 0x9b, 0x72, 0x9b, 0xe6, 0xfc, 0x9b, 0x1e, 0x99,
	0xad, 0x4b, 0xcf, 0xbb, 0x74, 0xe8, 0x9e, 0xa4, 0x5f, 0x84, 0xcd, 0x3d, 0xc1, 0xda, 0x34, 0x10,
	0xb8, 0xad, 0x22, 0x64, 0x7f, 0x0b, 0xe8, 0x88, 0x8a, 0x7c, 0xfd, 0xac, 0x66, 0x7b, 0x9c, 0x9a,
	0xf4, 0x7d, 0x48, 0x03, 0x81, 0xd6, 0x61, 0x21, 0x0c, 0x28, 0xb7, 0x18, 0x31, 0xb4, 0x6d, 0x6d,
	0x27, 0x69, 0xce, 0x47, 0xc3, 0x32, 0xc9, 0xfe, 0x1a, 0x1e, 0xdd, 0xa0, 0x07, 0xbe, 0xe7, 0x06,
	0x14, 0xad, 0xc2, 0x5c, 0x10, 0x01, 0x92, 0x9d, 0x30, 0xe3, 0x41, 0xf6, 0x18, 0x1e, 0x1f, 0x51,
	0x51, 0x38, 0x3a, 0x0c, 0x5d, 0xe2, 0xd0, 0xda, 0x71, 0x23, 0xe8, 0xc5, 0xd7, 0x61, 0xe6, 0x8a,
	0x76, 0x55, 0xec, 0xe8, 0x2f, 0xda, 0x82, 0x94, 0xe0, 0xd8, 0xbe, 0x62, 0xee, 0x65, 0x34, 0x6b,
	0x42, 0x5a, 0xa0, 0x07, 0x95, 0x49, 0xf6, 0x07, 0x58, 0xbf, 0x15, 0x4c, 0xcd, 0xbe, 0x09, 0xf0,
	0x3e, 0xc4, 0xae, 0x60, 0x82, 0xd1, 0xc0, 0xd0, 0xb6, 0x67, 0x76, 0xe6, 0xcc, 0x21, 0x24, 0xdb,
	0x84, 0x27, 0x47, 0x54, 0x8c, 0x14, 0xb3, 0x97, 0xca, 0x63, 0x98, 0x27, 0x5e, 0x1b, 0x33, 0xb7,
	0xb7, 0xd2, 0x78, 0xd4, 0x4b, 0x31, 0x31, 0x36, 0xc5, 0x99, 0x5b, 0x29, 0xee, 0x43, 0xe6, 0xae,
	0x79, 0x06, 0x35, 0xea, 0x60, 0x27, 0xa4, 0x6a, 0x9e, 0x78, 0x90, 0xfd, 0xff, 0x22, 0x7c, 0x55,
	0x0d, 0xb9, 0xdd, 0xc2, 0x01, 0x35, 0xa9, 0x1f, 0x8a, 0xe1, 0xe4, 0xfe, 0x48, 0xb1, 0x08, 0x39,
	0x0d, 0xd0, 0x57, 0xb0, 0xe4, 0x73, 0x8f, 0x84, 0xb6, 0xb0, 0x44, 0xd7, 0xef, 0x85, 0x48, 0x29,
	0xac, 0xde, 0xf5, 0x69, 0x44, 0xb1, 0xbd, 0xd0, 0x15, 0xbc, 0x6b, 0x45, 0x0d, 0xa5, 0x12, 0x4f,
	0x29, 0xac, 0xe0, 0x11, 0x8a, 0xfe, 0x00, 0x19, 0xc2, 0x9a, 0x4d, 0xca, 0xa9, 0x2b, 0x2c, 0x5f,
	0x4d, 0x6a, 0x29, 0x86, 0x5c, 0xcf, 0xa2, 0x69, 0xf4, 0x19, 0xbd, 0xac, 0x0a, 0xb1, 0x1d, 0x7d,
	0x03, 0xba, 0x8f, 0xbb, 0x6d, 0xe9, 0xcb, 0xbd, 0x0e, 0x23, 0x94, 0x1b, 0xb3, 0x72, 0x92, 0x15,
	0x85, 0x57, 0x15, 0x8c, 0x2a, 0xf0, 0x4b, 0x3b, 0xe4, 0x37, 0xa7, 0xe9, 0x50, 0xc7, 0xb3, 0x99,
	0xe8, 0x5a, 0x61, 0x40, 0xac, 0x6b, 0x4a, 0xaf, 0x9c, 0xae, 0x31, 0xb7, 0xad, 0xed, 0xcc, 0x99,
	0xdb, 0x8a, 0xdb, 0x9b, 0xf0, 0x5c, 0x31, 0x1b, 0x01, 0x79, 0x23, 0x79, 0xe8, 0x25, 0x6c, 0x08,
	0x8e, 0xdd, 0x00, 0xdb, 0x51, 0x71, 0x2c, 0xdc, 0x8e, 0x52, 0xb2, 0x6c, 0xea, 0x8a, 0x20, 0x0a,
	0x67, 0xcc, 0xcb, 0x38, 0x4f, 0x86, 0x38, 0x79, 0x49, 0x29, 0x44, 0x8c, 0x46, 0x40, 0xd0, 0x8f,
	0x90, 0xe9, 0xe5, 0xde, 0xa6, 0xa2, 0xe5, 0x11, 0x8b, 0x05, 0x56, 0x87, 0x72, 0xd6, 0x64, 0x94,
	0x18, 0x0b, 0x72, 0xe5, 0xeb, 0x8a, 0x71, 0x2a, 0x09, 0xe5, 0xe0, 0x5c, 0x99, 0xd1, 0x6f, 0x00,
	0xd9, 0x2d, 0xec, 0xba, 0xd4, 0x89, 0xbc, 0x7c, 0xcc, 0x85, 0x4b, 0xb9, 0xb1, 0x28, 0x9d, 0x74,
	0x65, 0x29, 0x07, 0xd5, 0x18, 0x47, 0xdf, 0xc2, 0xea, 0x10, 0x1b, 0x37, 0x9b, 0xcc, 0x61, 0x58,
	0x50, 0x23, 0x29, 0xf9, 0xa8, 0xcf, 0xcf, 0xf7, 0x2c, 0x68, 0x07, 0xf4, 0x16, 0x0e, 0x2c, 0x17,
	0xb7, 0x99, 0x75, 0x81, 0x1d, 0xec, 0xda, 0xd4, 0x00, 0xc9, 0x4e, 0xb7, 0x70, 0x50, 0xc1, 0x6d,
	0x76, 0x18, 0xa3, 0x51, 0x07, 0xba, 0xf4, 0xda, 0x52, 0x31, 0x8c, 0x94, 0x24, 0x81, 0x4b, 0xaf,
	0x0b, 0x31, 0x82, 0x76, 0xe1, 0xcb, 0x78, 0xdf, 0xba, 0x16, 0x76, 0x1c, 0xef, 0xda, 0x61, 0x81,
	0x30, 0x96, 0x24, 0x6d, 0x45, 0xee, 0x60, 0x37, 0xdf, 0x83, 0xd1, 0xd7, 0xb0, 0xc2, 0x02, 0x8b,
	0x30, 0x4e, 0x6d, 0x61, 0x11, 0x7a, 0xc1, 0x84, 0xb1, 0x2c, 0x99, 0xcb, 0x2c, 0x28, 0x4a, 0xb4,
	0x18, 0x81, 0x28, 0x0d, 0x09, 0xe6, 0x1b, 0x69, 0xf9, 0xa5, 0x13, 0xcc, 0x47, 0xcf, 0x00, 0xfa,
	0x0b, 0x24, 0xc6, 0x8a, 0xc4, 0x93, 0xbd, 0x65, 0x11, 0xb4, 0x0f, 0x6b, 0x04, 0x33, 0xa7, 0x6b,
	0x11, 0x62, 0x0d, 0x7d, 0x90, 0xc0, 0xd0, 0xe5, 0x47, 0x7a, 0x24, 0x8d, 0x45, 0x52, 0x1f, 0x32,
	0xa1, 0xef, 0xe1, 0x71, 0xdc, 0x11, 0xb7, 0x9c, 0xbe, 0x94, 0x4e, 0xab, 0xb1, 0x75, 0xc4, 0xeb,
	0x77, 0xb0, 0xde, 0xf6, 0x5c, 0xd1, 0xba, 0xc3, 0x0d, 0x49, 0xb7, 0x35, 0x65, 0x1e, 0xf1, 0xfb,
	0xb7, 0x06, 0x4f, 0x31, 0x21, 0x2c, 0x1a, 0x61, 0xc7, 0xe2, 0xf1, 0x5e, 0xb3, 0x9a, 0x6a, 0xb3,
	0x19, 0x8f, 0xb6, 0x67, 0x76, 0x52, 0xfb, 0x38, 0x37, 0x45, 0x5b, 0x73, 0x53, 0xb7, 0x6d, 0x2e,
	0xdf, 0x9f, 0x65, 0xc4, 0x52, 0x8a, 0x76, 0x94, 0xf9, 0x04, 0x8f, 0xb3, 0xa3, 0xa7, 0x90, 0x24,
	0xb4, 0xc3, 0x6c, 0x1a, 0xd5, 0x78, 0x55, 0xd6, 0x78, 0x31, 0x06, 0xca, 0x24, 0x73, 0x02, 0x9b,
	0x93, 0x23, 0xdf, 0xa1, 0xaf, 0x7d, 0xf5, 0x49, 0x0c, 0xa9, 0xcf, 0xf3, 0xc4, 0x81, 0x96, 0xfd,
	0xdf, 0x0c, 0x6c, 0x44, 0xb2, 0x35, 0x6e, 0x35, 0x63, 0x0f, 0x83, 0xa9, 0x9a, 0x1d, 0x69, 0x2b,
	0xed, 0x44, 0x7b, 0x50, 0x89, 0xa5, 0x1a, 0xa1, 0x1f, 0x00, 0x02, 0x81, 0xb9, 0xb0, 0xa2, 0xd3,
	0x48, 0x8a, 0x48, 0x6a, 0x3f, 0x93, 0x8b, 0x8f, 0xaa, 0x5c, 0xef, 0xa8, 0xca, 0xd5, 0x7b, 0x47,
	0x95, 0x99, 0x94, 0xec, 0x68, 0x8c, 0x7e, 0x82, 0x25, 0x1b, 0xfb, 0xd1, 0x52, 0x63, 0xe7, 0xb9,
	0xa9, 0xce, 0x29, 0xc5, 0x97, 0xee, 0x78, 0x44, 0x48, 0x23, 0xe5, 0x48, 0xef, 0xbf, 0x78, 0xc0,
	0xb7, 0xae, 0x0e, 0xb4, 0xf7, 0xa6, 0x10, 0xb7, 0x41, 0xbf, 0xd5, 0x52, 0x0b, 0x32, 0xcb, 0xc3,
	0xcf, 0x6f, 0x29, 0x73, 0x85, 0x8f, 0x74, 0xca, 0x0e, 0xe8, 0x4d, 0x8e, 0x43, 0x62, 0xd9, 0x2d,
	0x6a, 0x5f, 0x59, 0x61, 0xc8, 0x88, 0xd4, 0xa6, 0xa4, 0x99, 0x96, 0x78, 0x21, 0x82, 0x1b, 0x21,
	0x23, 0xd9, 0xbf, 0x69, 0xf0, 0x6c, 0xcc, 0x87, 0x56, 0x47, 0x14, 0x81, 0x65, 0xae, 0xfe, 0x0f,
	0xce, 0x99, 0xf4, 0xfe, 0xcb, 0x07, 0xe5, 0x1d, 0xc7, 0x91, 0xf5, 0x59, 0xe2, 0x43, 0xa3, 0xec,
	0x2b, 0xd8, 0x6c, 0xf8, 0x04, 0x0b, 0x5a, 0xc4, 0x02, 0xd7, 0xbc, 0x90, 0xdb, 0xf4, 0x9c, 0xf2,
	0x60, 0xa8, 0xe3, 0x36, 0x01, 0x48, 0xdf, 0xa6, 0x9a, 0x6e, 0x08, 0xc9, 0xe6, 0x61, 0x6b, 0x6c,
	0x84, 0xc1, 0x9d, 0xc0, 0xa5, 0xd7, 0x0a, 0xed, 0x85, 0x18, 0x20, 0xd9, 0x02, 0x64, 0x8f, 0xa8,
	0x78, 0xdd, 0xf5, 0x69, 0x9d, 0x63, 0xe6, 0x16, 0x3c, 0xb7, 0xc9, 0x2e, 0xcf, 0x3a, 0x94, 0x73,
	0x46, 0x68, 0xff, 0x9e, 0x72, 0x53, 0xeb, 0xb4, 0x11, 0xad, 0xcb, 0xfe, 0x57, 0x83, 0x5f, 0x4c,
	0x8c, 0xa2, 0x92, 0x79, 0x0b, 0x10, 0x1d, 0xab, 0xcc, 0x0e, 0x1d, 0xd1, 0x55, 0x45, 0x3d, 0x98,
	0x5a, 0xd4, 0x7e, 0xd8, 0x62, 0xdf, 0x57, 0x56, 0x73, 0x28, 0x16, 0xda, 0x80, 0xa4, 0x68, 0x71,
	0x1a, 0xb4, 0x3c, 0x27, 0xde, 0x80, 0x73, 0xe6, 0x00, 0x40, 0x07, 0xb0, 0x1e, 0xb4, 0xbc, 0xd0,
	0x21, 0x8d, 0x80, 0x96, 0x3e, 0xb0, 0xe8, 0x86, 0x79, 0x19, 0xe7, 0xa8, 0x4e, 0xfb, 0x71, 0xe6,
	0x5d, 0x0e, 0xcf, 0x26, 0xb6, 0x3c, 0xfa, 0x06, 0x7e, 0x35, 0x91, 0x60, 0x35, 0x2a, 0xc7, 0x95,
	0xb3, 0x37, 0x15, 0xfd, 0x0b, 0xf4, 0x35, 0x64, 0x27, 0x53, 0x0f, 0xcb, 0xf5, 0x9a, 0xae, 0xed,
	0xfe, 0x45, 0x83, 0xcd, 0xc9, 0x8d, 0x84, 0x52, 0xb0, 0x30, 0x88, 0x8b, 0x20, 0x5d, 0x7a, 0x5b,
	0xae, 0xd5, 0xcb, 0x95, 0x23, 0xcb, 0x6c, 0x9c, 0x94, 0x6a, 0xba, 0x86, 0xd2, 0x00, 0xb5, 0xe3,
	0x72, 0x55, 0x8d, 0x13, 0x68, 0x19, 0x92, 0x87, 0x27, 0x67, 0x85, 0x63, 0xab, 0x56, 0x3d, 0xd5,
	0x67, 0xd0, 0x36, 0x6c, 0x0c, 0xcc, 0x56, 0xb9, 0x52, 0x30, 0x4b, 0xf9, 0x5a, 0xc9, 0x3a, 0x2f,
	0x9d, 0x9c, 0x15, 0xca, 0xf5, 0x77, 0xfa, 0xec, 0x6e, 0x03, 0xd6, 0xc7, 0xd4, 0x1d, 0x2d, 0xc2,
	0x6c, 0x29, 0x5f, 0x7b, 0xa7, 0x7f, 0x81, 0x00, 0xe6, 0x4f, 0x4b, 0xc5, 0x72, 0xe3, 0x54, 0xd7,
	0x22, 0xf4, 0x75, 0xde, 0x2c, 0xea, 0x09, 0x39, 0x77, 0xa3, 0x5a, 0x32, 0x2d, 0x39, 0x9e, 0x89,
	0x58, 0xe5, 0x4a, 0x2d, 0x5f, 0x29, 0xe9, 0xb3, 0xfb, 0x7f, 0x5f, 0x80, 0xb5, 0x3b, 0xef, 0xf4,
	0xe8, 0x1f, 0x9a, 0xbc, 0x81, 0x8f, 0xc2, 0xcf, 0xa7, 0xb6, 0xc7, 0xd8, 0x2b, 0x6d, 0xe6, 0xc7,
	0x07, 0xf9, 0xaa, 0x5e, 0xfd, 0x97, 0x06, 0xeb, 0x63, 0x36, 0x17, 0x9a, 0x2e, 0x04, 0x93, 0x37,
	0x76, 0xe6, 0xd5, 0xc3, 0x03, 0xa8, 0xf4, 0xfe, 0xaa, 0xc1, 0xca, 0xc8, 0x3b, 0x00, 0xfd, 0xfe,
	0x3e, 0xeb, 0xbd, 0xe3, 0x19, 0x92, 0x39, 0xf8, 0x74, 0x47, 0x95, 0xc6, 0x3f, 0x35, 0x58, 0xbb,
	0x53, 0x4b, 0xd1, 0x4f, 0xf7, 0x2a, 0xfe, 0x38, 0x9d, 0xcf, 0xbc, 0x78, 0xa8, 0xbb, 0x4a, 0xec,
	0x3f, 0x1a, 0x3c, 0x9d, 0x20, 0x49, 0xa8, 0x70, 0x9f, 0xf8, 0x53, 0x64, 0x31, 0x53, 0xfc, 0xbc,
	0x20, 0x2a, 0xd5, 0x0f, 0x90, 0x1a, 0x7a, 0x4b, 0xa2, 0xef, 0xee, 0x13, 0x74, 0xe4, 0xa1, 0x9a,
	0xf9, 0xfe, 0xd3, 0x9c, 0xe2, 0x99, 0x0f, 0xbf, 0xfd, 0x53, 0xee, 0xd3, 0x1e, 0xdd, 0x17, 0xf3,
	0xf2, 0x62, 0xf1, 0xdd, 0xcf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf7, 0x6a, 0xbd, 0x5f, 0xad, 0x0f,
	0x00, 0x00,
}
