// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchPredictionsTwirp/twirp.proto

/*
Package TwitchPredictionsTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchPredictionsTwirp/twirp.proto
*/
package TwitchPredictionsTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===========================
// TwitchPredictions Interface
// ===========================

// TwitchPredictions APIs.
type TwitchPredictions interface {
	// GetChannelSettings returns a channel's predictions settings.
	GetChannelSettings(context.Context, *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error)

	// UpdateChannelSettings updates a channel's predictions settings.
	UpdateChannelSettings(context.Context, *UpdateChannelSettingsRequest) (*UpdateChannelSettingsResponse, error)

	// CreateEvent creates a Prediction Event in a channel.
	CreateEvent(context.Context, *CreateEventRequest) (*CreateEventResponse, error)

	// CancelEvent cancels an ongoing Prediction Event in a channel.
	CancelEvent(context.Context, *CancelEventRequest) (*CancelEventResponse, error)

	// ResolveEvent resolves a Prediction Event and pays out the winners.
	ResolveEvent(context.Context, *ResolveEventRequest) (*ResolveEventResponse, error)

	// LockEvent closes a Prediction Event to new predictions and moves it to the "LOCKED" state.
	LockEvent(context.Context, *LockEventRequest) (*LockEventResponse, error)

	// ListResolvedEvents paginates through all "RESOLVED" events on a channel.
	ListResolvedEvents(context.Context, *ListResolvedEventsRequest) (*ListResolvedEventsResponse, error)

	// GetActiveEvents returns all active events on a channel.
	GetActiveEvents(context.Context, *GetActiveEventsRequest) (*GetActiveEventsResponse, error)

	// GetLockedEvents returns all locked events on a channel.
	GetLockedEvents(context.Context, *GetLockedEventsRequest) (*GetLockedEventsResponse, error)

	// GetRecentPredictions returns a user's recent predictions on a channel.
	GetRecentPredictions(context.Context, *GetRecentPredictionsRequest) (*GetRecentPredictionsResponse, error)

	// ListEventsByChannelID returns a list of paginated events by channel id
	ListEventsByChannelID(context.Context, *ListEventsByChannelIDRequest) (*ListEventsByChannelIDResponse, error)

	// GetUserSettings returns a user's predictions settings.
	GetUserSettings(context.Context, *GetUserSettingsRequest) (*GetUserSettingsResponse, error)

	// GetUserStatistics returns a user's predictions statistics on a channel.
	GetUserStatistics(context.Context, *GetUserStatisticsRequest) (*GetUserStatisticsResponse, error)

	// GetIsRegionRestricted returns a whether the region, presumably of the user, is restricted from making predictions.
	GetIsRegionRestricted(context.Context, *GetIsRegionRestrictedRequest) (*GetIsRegionRestrictedResponse, error)

	// GetUserEventPrediction returns a user's prediction in an event.
	GetUserEventPrediction(context.Context, *GetUserEventPredictionRequest) (*GetUserEventPredictionResponse, error)

	// GetUserEventRestriction returns a restriction on a user participating in an Event, if one exists.
	GetUserEventRestriction(context.Context, *GetUserEventRestrictionRequest) (*GetUserEventRestrictionResponse, error)

	// UpdateUserSettings updates a user's predictions settings.
	UpdateUserSettings(context.Context, *UpdateUserSettingsRequest) (*UpdateUserSettingsResponse, error)

	// MakePrediction makes a prediction.
	MakePrediction(context.Context, *MakePredictionRequest) (*MakePredictionResponse, error)

	// AcknowledgePredictionResult acknowledges the result of a prediction.
	AcknowledgePredictionResult(context.Context, *AcknowledgePredictionResultRequest) (*AcknowledgePredictionResultResponse, error)

	// GetEvents gets Events by IDs.
	GetEvents(context.Context, *GetEventsRequest) (*GetEventsResponse, error)

	// GetPredictions gets Predictions by IDs.
	GetPredictions(context.Context, *GetPredictionsRequest) (*GetPredictionsResponse, error)

	// ------------------------------------------------------------------------------
	// Internal management
	// ------------------------------------------------------------------------------
	// ConcludePendingEvent moves a RESOLVE_PENDING or CANCEL_PENDING event to status RESOLVED or CANCELED respectively.
	ConcludePendingEvent(context.Context, *ConcludePendingEventRequest) (*ConcludePendingEventResponse, error)

	// GetEventPredictionsStatus returns aggregate status information about an event's predictions.
	GetEventPredictionsStatus(context.Context, *GetEventPredictionsStatusRequest) (*GetEventPredictionsStatusResponse, error)

	// ListEventUnprocessedPredictions returns event's unprocessed predictions.
	ListEventUnprocessedPredictions(context.Context, *ListEventUnprocessedPredictionsRequest) (*ListEventUnprocessedPredictionsResponse, error)

	// ResolvePrediction pays out if the prediction outcome is the event's winning outcome.
	ResolvePrediction(context.Context, *ResolvePredictionRequest) (*ResolvePredictionResponse, error)

	// RefundPrediction refunds points.
	RefundPrediction(context.Context, *RefundPredictionRequest) (*RefundPredictionResponse, error)

	// RefreshActiveEvent updates the Event DB's view of an active Event with the most current points and top predictors per outcome.
	RefreshActiveEvent(context.Context, *RefreshActiveEventRequest) (*RefreshActiveEventResponse, error)

	// DeleteEvent is used by Twitch admins to delete Events directly without progressing them through the Event lifecycle.
	DeleteEvent(context.Context, *DeleteEventRequest) (*DeleteEventResponse, error)

	// Permanently hard deletes all data belonging to the provided user.
	// Should ONLY be used for GDPR purposes.
	HardDeleteUserData(context.Context, *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error)
}

// =================================
// TwitchPredictions Protobuf Client
// =================================

type twitchPredictionsProtobufClient struct {
	client HTTPClient
	urls   [29]string
	opts   twirp.ClientOptions
}

// NewTwitchPredictionsProtobufClient creates a Protobuf client that implements the TwitchPredictions interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchPredictionsProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchPredictions {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchPredictionsPathPrefix
	urls := [29]string{
		prefix + "GetChannelSettings",
		prefix + "UpdateChannelSettings",
		prefix + "CreateEvent",
		prefix + "CancelEvent",
		prefix + "ResolveEvent",
		prefix + "LockEvent",
		prefix + "ListResolvedEvents",
		prefix + "GetActiveEvents",
		prefix + "GetLockedEvents",
		prefix + "GetRecentPredictions",
		prefix + "ListEventsByChannelID",
		prefix + "GetUserSettings",
		prefix + "GetUserStatistics",
		prefix + "GetIsRegionRestricted",
		prefix + "GetUserEventPrediction",
		prefix + "GetUserEventRestriction",
		prefix + "UpdateUserSettings",
		prefix + "MakePrediction",
		prefix + "AcknowledgePredictionResult",
		prefix + "GetEvents",
		prefix + "GetPredictions",
		prefix + "ConcludePendingEvent",
		prefix + "GetEventPredictionsStatus",
		prefix + "ListEventUnprocessedPredictions",
		prefix + "ResolvePrediction",
		prefix + "RefundPrediction",
		prefix + "RefreshActiveEvent",
		prefix + "DeleteEvent",
		prefix + "HardDeleteUserData",
	}

	return &twitchPredictionsProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchPredictionsProtobufClient) GetChannelSettings(ctx context.Context, in *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	out := new(GetChannelSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) UpdateChannelSettings(ctx context.Context, in *UpdateChannelSettingsRequest) (*UpdateChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	out := new(UpdateChannelSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) CreateEvent(ctx context.Context, in *CreateEventRequest) (*CreateEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEvent")
	out := new(CreateEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) CancelEvent(ctx context.Context, in *CancelEventRequest) (*CancelEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "CancelEvent")
	out := new(CancelEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) ResolveEvent(ctx context.Context, in *ResolveEventRequest) (*ResolveEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveEvent")
	out := new(ResolveEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) LockEvent(ctx context.Context, in *LockEventRequest) (*LockEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "LockEvent")
	out := new(LockEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) ListResolvedEvents(ctx context.Context, in *ListResolvedEventsRequest) (*ListResolvedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ListResolvedEvents")
	out := new(ListResolvedEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetActiveEvents(ctx context.Context, in *GetActiveEventsRequest) (*GetActiveEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEvents")
	out := new(GetActiveEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetLockedEvents(ctx context.Context, in *GetLockedEventsRequest) (*GetLockedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetLockedEvents")
	out := new(GetLockedEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetRecentPredictions(ctx context.Context, in *GetRecentPredictionsRequest) (*GetRecentPredictionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentPredictions")
	out := new(GetRecentPredictionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) ListEventsByChannelID(ctx context.Context, in *ListEventsByChannelIDRequest) (*ListEventsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ListEventsByChannelID")
	out := new(ListEventsByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSettings")
	out := new(GetUserSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetUserStatistics(ctx context.Context, in *GetUserStatisticsRequest) (*GetUserStatisticsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStatistics")
	out := new(GetUserStatisticsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetIsRegionRestricted(ctx context.Context, in *GetIsRegionRestrictedRequest) (*GetIsRegionRestrictedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetIsRegionRestricted")
	out := new(GetIsRegionRestrictedResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetUserEventPrediction(ctx context.Context, in *GetUserEventPredictionRequest) (*GetUserEventPredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventPrediction")
	out := new(GetUserEventPredictionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetUserEventRestriction(ctx context.Context, in *GetUserEventRestrictionRequest) (*GetUserEventRestrictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventRestriction")
	out := new(GetUserEventRestrictionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) UpdateUserSettings(ctx context.Context, in *UpdateUserSettingsRequest) (*UpdateUserSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserSettings")
	out := new(UpdateUserSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) MakePrediction(ctx context.Context, in *MakePredictionRequest) (*MakePredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "MakePrediction")
	out := new(MakePredictionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) AcknowledgePredictionResult(ctx context.Context, in *AcknowledgePredictionResultRequest) (*AcknowledgePredictionResultResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "AcknowledgePredictionResult")
	out := new(AcknowledgePredictionResultResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetEvents(ctx context.Context, in *GetEventsRequest) (*GetEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetEvents")
	out := new(GetEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetPredictions(ctx context.Context, in *GetPredictionsRequest) (*GetPredictionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetPredictions")
	out := new(GetPredictionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) ConcludePendingEvent(ctx context.Context, in *ConcludePendingEventRequest) (*ConcludePendingEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ConcludePendingEvent")
	out := new(ConcludePendingEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) GetEventPredictionsStatus(ctx context.Context, in *GetEventPredictionsStatusRequest) (*GetEventPredictionsStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetEventPredictionsStatus")
	out := new(GetEventPredictionsStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) ListEventUnprocessedPredictions(ctx context.Context, in *ListEventUnprocessedPredictionsRequest) (*ListEventUnprocessedPredictionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ListEventUnprocessedPredictions")
	out := new(ListEventUnprocessedPredictionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) ResolvePrediction(ctx context.Context, in *ResolvePredictionRequest) (*ResolvePredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ResolvePrediction")
	out := new(ResolvePredictionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) RefundPrediction(ctx context.Context, in *RefundPredictionRequest) (*RefundPredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "RefundPrediction")
	out := new(RefundPredictionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) RefreshActiveEvent(ctx context.Context, in *RefreshActiveEventRequest) (*RefreshActiveEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshActiveEvent")
	out := new(RefreshActiveEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) DeleteEvent(ctx context.Context, in *DeleteEventRequest) (*DeleteEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEvent")
	out := new(DeleteEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[27], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsProtobufClient) HardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	out := new(HardDeleteUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[28], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =============================
// TwitchPredictions JSON Client
// =============================

type twitchPredictionsJSONClient struct {
	client HTTPClient
	urls   [29]string
	opts   twirp.ClientOptions
}

// NewTwitchPredictionsJSONClient creates a JSON client that implements the TwitchPredictions interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchPredictionsJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchPredictions {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchPredictionsPathPrefix
	urls := [29]string{
		prefix + "GetChannelSettings",
		prefix + "UpdateChannelSettings",
		prefix + "CreateEvent",
		prefix + "CancelEvent",
		prefix + "ResolveEvent",
		prefix + "LockEvent",
		prefix + "ListResolvedEvents",
		prefix + "GetActiveEvents",
		prefix + "GetLockedEvents",
		prefix + "GetRecentPredictions",
		prefix + "ListEventsByChannelID",
		prefix + "GetUserSettings",
		prefix + "GetUserStatistics",
		prefix + "GetIsRegionRestricted",
		prefix + "GetUserEventPrediction",
		prefix + "GetUserEventRestriction",
		prefix + "UpdateUserSettings",
		prefix + "MakePrediction",
		prefix + "AcknowledgePredictionResult",
		prefix + "GetEvents",
		prefix + "GetPredictions",
		prefix + "ConcludePendingEvent",
		prefix + "GetEventPredictionsStatus",
		prefix + "ListEventUnprocessedPredictions",
		prefix + "ResolvePrediction",
		prefix + "RefundPrediction",
		prefix + "RefreshActiveEvent",
		prefix + "DeleteEvent",
		prefix + "HardDeleteUserData",
	}

	return &twitchPredictionsJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchPredictionsJSONClient) GetChannelSettings(ctx context.Context, in *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	out := new(GetChannelSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) UpdateChannelSettings(ctx context.Context, in *UpdateChannelSettingsRequest) (*UpdateChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	out := new(UpdateChannelSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) CreateEvent(ctx context.Context, in *CreateEventRequest) (*CreateEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEvent")
	out := new(CreateEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) CancelEvent(ctx context.Context, in *CancelEventRequest) (*CancelEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "CancelEvent")
	out := new(CancelEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) ResolveEvent(ctx context.Context, in *ResolveEventRequest) (*ResolveEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveEvent")
	out := new(ResolveEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) LockEvent(ctx context.Context, in *LockEventRequest) (*LockEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "LockEvent")
	out := new(LockEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) ListResolvedEvents(ctx context.Context, in *ListResolvedEventsRequest) (*ListResolvedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ListResolvedEvents")
	out := new(ListResolvedEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetActiveEvents(ctx context.Context, in *GetActiveEventsRequest) (*GetActiveEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEvents")
	out := new(GetActiveEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetLockedEvents(ctx context.Context, in *GetLockedEventsRequest) (*GetLockedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetLockedEvents")
	out := new(GetLockedEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetRecentPredictions(ctx context.Context, in *GetRecentPredictionsRequest) (*GetRecentPredictionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentPredictions")
	out := new(GetRecentPredictionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) ListEventsByChannelID(ctx context.Context, in *ListEventsByChannelIDRequest) (*ListEventsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ListEventsByChannelID")
	out := new(ListEventsByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSettings")
	out := new(GetUserSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetUserStatistics(ctx context.Context, in *GetUserStatisticsRequest) (*GetUserStatisticsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStatistics")
	out := new(GetUserStatisticsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetIsRegionRestricted(ctx context.Context, in *GetIsRegionRestrictedRequest) (*GetIsRegionRestrictedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetIsRegionRestricted")
	out := new(GetIsRegionRestrictedResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetUserEventPrediction(ctx context.Context, in *GetUserEventPredictionRequest) (*GetUserEventPredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventPrediction")
	out := new(GetUserEventPredictionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetUserEventRestriction(ctx context.Context, in *GetUserEventRestrictionRequest) (*GetUserEventRestrictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventRestriction")
	out := new(GetUserEventRestrictionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) UpdateUserSettings(ctx context.Context, in *UpdateUserSettingsRequest) (*UpdateUserSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserSettings")
	out := new(UpdateUserSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) MakePrediction(ctx context.Context, in *MakePredictionRequest) (*MakePredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "MakePrediction")
	out := new(MakePredictionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) AcknowledgePredictionResult(ctx context.Context, in *AcknowledgePredictionResultRequest) (*AcknowledgePredictionResultResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "AcknowledgePredictionResult")
	out := new(AcknowledgePredictionResultResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetEvents(ctx context.Context, in *GetEventsRequest) (*GetEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetEvents")
	out := new(GetEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetPredictions(ctx context.Context, in *GetPredictionsRequest) (*GetPredictionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetPredictions")
	out := new(GetPredictionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) ConcludePendingEvent(ctx context.Context, in *ConcludePendingEventRequest) (*ConcludePendingEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ConcludePendingEvent")
	out := new(ConcludePendingEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) GetEventPredictionsStatus(ctx context.Context, in *GetEventPredictionsStatusRequest) (*GetEventPredictionsStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "GetEventPredictionsStatus")
	out := new(GetEventPredictionsStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) ListEventUnprocessedPredictions(ctx context.Context, in *ListEventUnprocessedPredictionsRequest) (*ListEventUnprocessedPredictionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ListEventUnprocessedPredictions")
	out := new(ListEventUnprocessedPredictionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) ResolvePrediction(ctx context.Context, in *ResolvePredictionRequest) (*ResolvePredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "ResolvePrediction")
	out := new(ResolvePredictionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) RefundPrediction(ctx context.Context, in *RefundPredictionRequest) (*RefundPredictionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "RefundPrediction")
	out := new(RefundPredictionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) RefreshActiveEvent(ctx context.Context, in *RefreshActiveEventRequest) (*RefreshActiveEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshActiveEvent")
	out := new(RefreshActiveEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) DeleteEvent(ctx context.Context, in *DeleteEventRequest) (*DeleteEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEvent")
	out := new(DeleteEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[27], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchPredictionsJSONClient) HardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	out := new(HardDeleteUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[28], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// TwitchPredictions Server Handler
// ================================

type twitchPredictionsServer struct {
	TwitchPredictions
	hooks *twirp.ServerHooks
}

func NewTwitchPredictionsServer(svc TwitchPredictions, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchPredictionsServer{
		TwitchPredictions: svc,
		hooks:             hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchPredictionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchPredictionsPathPrefix is used for all URL paths on a twirp TwitchPredictions server.
// Requests are always: POST TwitchPredictionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchPredictionsPathPrefix = "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/"

func (s *twitchPredictionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchpredictions")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchPredictions")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetChannelSettings":
		s.serveGetChannelSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/UpdateChannelSettings":
		s.serveUpdateChannelSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/CreateEvent":
		s.serveCreateEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/CancelEvent":
		s.serveCancelEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/ResolveEvent":
		s.serveResolveEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/LockEvent":
		s.serveLockEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/ListResolvedEvents":
		s.serveListResolvedEvents(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetActiveEvents":
		s.serveGetActiveEvents(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetLockedEvents":
		s.serveGetLockedEvents(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetRecentPredictions":
		s.serveGetRecentPredictions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/ListEventsByChannelID":
		s.serveListEventsByChannelID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetUserSettings":
		s.serveGetUserSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetUserStatistics":
		s.serveGetUserStatistics(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetIsRegionRestricted":
		s.serveGetIsRegionRestricted(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetUserEventPrediction":
		s.serveGetUserEventPrediction(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetUserEventRestriction":
		s.serveGetUserEventRestriction(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/UpdateUserSettings":
		s.serveUpdateUserSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/MakePrediction":
		s.serveMakePrediction(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/AcknowledgePredictionResult":
		s.serveAcknowledgePredictionResult(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetEvents":
		s.serveGetEvents(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetPredictions":
		s.serveGetPredictions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/ConcludePendingEvent":
		s.serveConcludePendingEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/GetEventPredictionsStatus":
		s.serveGetEventPredictionsStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/ListEventUnprocessedPredictions":
		s.serveListEventUnprocessedPredictions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/ResolvePrediction":
		s.serveResolvePrediction(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/RefundPrediction":
		s.serveRefundPrediction(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/RefreshActiveEvent":
		s.serveRefreshActiveEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/DeleteEvent":
		s.serveDeleteEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchpredictions.TwitchPredictions/HardDeleteUserData":
		s.serveHardDeleteUserData(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchPredictionsServer) serveGetChannelSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetChannelSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSettingsResponse and nil error while calling GetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetChannelSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSettingsResponse and nil error while calling GetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveUpdateChannelSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateChannelSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveUpdateChannelSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateChannelSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.UpdateChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelSettingsResponse and nil error while calling UpdateChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveUpdateChannelSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateChannelSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.UpdateChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelSettingsResponse and nil error while calling UpdateChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveCreateEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveCreateEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.CreateEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEventResponse and nil error while calling CreateEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveCreateEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.CreateEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEventResponse and nil error while calling CreateEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveCancelEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCancelEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveCancelEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CancelEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CancelEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.CancelEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelEventResponse and nil error while calling CancelEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveCancelEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CancelEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CancelEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.CancelEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelEventResponse and nil error while calling CancelEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveResolveEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResolveEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResolveEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveResolveEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResolveEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResolveEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ResolveEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveEventResponse and nil error while calling ResolveEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveResolveEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ResolveEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResolveEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ResolveEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveEventResponse and nil error while calling ResolveEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveLockEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLockEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLockEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveLockEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LockEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LockEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LockEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.LockEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LockEventResponse and nil error while calling LockEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveLockEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LockEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(LockEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LockEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.LockEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LockEventResponse and nil error while calling LockEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveListResolvedEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListResolvedEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListResolvedEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveListResolvedEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListResolvedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListResolvedEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListResolvedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ListResolvedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListResolvedEventsResponse and nil error while calling ListResolvedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveListResolvedEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListResolvedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListResolvedEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListResolvedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ListResolvedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListResolvedEventsResponse and nil error while calling ListResolvedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetActiveEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActiveEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActiveEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetActiveEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActiveEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActiveEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetActiveEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActiveEventsResponse and nil error while calling GetActiveEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetActiveEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetActiveEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActiveEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetActiveEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActiveEventsResponse and nil error while calling GetActiveEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetLockedEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLockedEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLockedEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetLockedEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLockedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLockedEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLockedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetLockedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLockedEventsResponse and nil error while calling GetLockedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetLockedEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLockedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetLockedEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLockedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetLockedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLockedEventsResponse and nil error while calling GetLockedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetRecentPredictions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecentPredictionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecentPredictionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetRecentPredictionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentPredictions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecentPredictionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecentPredictionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetRecentPredictions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecentPredictionsResponse and nil error while calling GetRecentPredictions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetRecentPredictionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentPredictions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecentPredictionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecentPredictionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetRecentPredictions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecentPredictionsResponse and nil error while calling GetRecentPredictions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveListEventsByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEventsByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEventsByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveListEventsByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEventsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEventsByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEventsByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ListEventsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventsByChannelIDResponse and nil error while calling ListEventsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveListEventsByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEventsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEventsByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEventsByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ListEventsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventsByChannelIDResponse and nil error while calling ListEventsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserStatistics(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserStatisticsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserStatisticsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetUserStatisticsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStatistics")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserStatisticsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserStatisticsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserStatistics(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserStatisticsResponse and nil error while calling GetUserStatistics. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserStatisticsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStatistics")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserStatisticsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserStatisticsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserStatistics(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserStatisticsResponse and nil error while calling GetUserStatistics. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetIsRegionRestricted(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIsRegionRestrictedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIsRegionRestrictedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetIsRegionRestrictedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIsRegionRestricted")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetIsRegionRestrictedRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetIsRegionRestrictedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetIsRegionRestricted(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIsRegionRestrictedResponse and nil error while calling GetIsRegionRestricted. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetIsRegionRestrictedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIsRegionRestricted")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetIsRegionRestrictedRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetIsRegionRestrictedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetIsRegionRestricted(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIsRegionRestrictedResponse and nil error while calling GetIsRegionRestricted. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserEventPrediction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserEventPredictionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserEventPredictionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetUserEventPredictionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventPrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserEventPredictionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserEventPredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserEventPrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserEventPredictionResponse and nil error while calling GetUserEventPrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserEventPredictionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventPrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserEventPredictionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserEventPredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserEventPrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserEventPredictionResponse and nil error while calling GetUserEventPrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserEventRestriction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserEventRestrictionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserEventRestrictionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetUserEventRestrictionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventRestriction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserEventRestrictionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserEventRestrictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserEventRestriction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserEventRestrictionResponse and nil error while calling GetUserEventRestriction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetUserEventRestrictionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserEventRestriction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserEventRestrictionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserEventRestrictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetUserEventRestriction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserEventRestrictionResponse and nil error while calling GetUserEventRestriction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveUpdateUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveUpdateUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateUserSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.UpdateUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateUserSettingsResponse and nil error while calling UpdateUserSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveUpdateUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateUserSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateUserSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.UpdateUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateUserSettingsResponse and nil error while calling UpdateUserSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveMakePrediction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMakePredictionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMakePredictionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveMakePredictionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MakePrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MakePredictionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MakePredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.MakePrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MakePredictionResponse and nil error while calling MakePrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveMakePredictionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MakePrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(MakePredictionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MakePredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.MakePrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MakePredictionResponse and nil error while calling MakePrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveAcknowledgePredictionResult(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAcknowledgePredictionResultJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAcknowledgePredictionResultProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveAcknowledgePredictionResultJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcknowledgePredictionResult")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AcknowledgePredictionResultRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AcknowledgePredictionResultResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.AcknowledgePredictionResult(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcknowledgePredictionResultResponse and nil error while calling AcknowledgePredictionResult. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveAcknowledgePredictionResultProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcknowledgePredictionResult")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AcknowledgePredictionResultRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AcknowledgePredictionResultResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.AcknowledgePredictionResult(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcknowledgePredictionResultResponse and nil error while calling AcknowledgePredictionResult. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEventsResponse and nil error while calling GetEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEventsResponse and nil error while calling GetEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetPredictions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPredictionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPredictionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetPredictionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPredictions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPredictionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPredictionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetPredictions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPredictionsResponse and nil error while calling GetPredictions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetPredictionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPredictions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPredictionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPredictionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetPredictions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPredictionsResponse and nil error while calling GetPredictions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveConcludePendingEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveConcludePendingEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveConcludePendingEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveConcludePendingEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ConcludePendingEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ConcludePendingEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ConcludePendingEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ConcludePendingEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ConcludePendingEventResponse and nil error while calling ConcludePendingEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveConcludePendingEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ConcludePendingEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ConcludePendingEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ConcludePendingEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ConcludePendingEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ConcludePendingEventResponse and nil error while calling ConcludePendingEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetEventPredictionsStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEventPredictionsStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEventPredictionsStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveGetEventPredictionsStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEventPredictionsStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEventPredictionsStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEventPredictionsStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetEventPredictionsStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEventPredictionsStatusResponse and nil error while calling GetEventPredictionsStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveGetEventPredictionsStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEventPredictionsStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEventPredictionsStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEventPredictionsStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.GetEventPredictionsStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEventPredictionsStatusResponse and nil error while calling GetEventPredictionsStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveListEventUnprocessedPredictions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEventUnprocessedPredictionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEventUnprocessedPredictionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveListEventUnprocessedPredictionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEventUnprocessedPredictions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEventUnprocessedPredictionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEventUnprocessedPredictionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ListEventUnprocessedPredictions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventUnprocessedPredictionsResponse and nil error while calling ListEventUnprocessedPredictions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveListEventUnprocessedPredictionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEventUnprocessedPredictions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEventUnprocessedPredictionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEventUnprocessedPredictionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ListEventUnprocessedPredictions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventUnprocessedPredictionsResponse and nil error while calling ListEventUnprocessedPredictions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveResolvePrediction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResolvePredictionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResolvePredictionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveResolvePredictionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolvePrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResolvePredictionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResolvePredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ResolvePrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolvePredictionResponse and nil error while calling ResolvePrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveResolvePredictionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolvePrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ResolvePredictionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResolvePredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.ResolvePrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolvePredictionResponse and nil error while calling ResolvePrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveRefundPrediction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRefundPredictionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRefundPredictionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveRefundPredictionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefundPrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RefundPredictionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefundPredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.RefundPrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefundPredictionResponse and nil error while calling RefundPrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveRefundPredictionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefundPrediction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RefundPredictionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefundPredictionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.RefundPrediction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefundPredictionResponse and nil error while calling RefundPrediction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveRefreshActiveEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRefreshActiveEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRefreshActiveEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveRefreshActiveEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshActiveEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RefreshActiveEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshActiveEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.RefreshActiveEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshActiveEventResponse and nil error while calling RefreshActiveEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveRefreshActiveEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshActiveEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RefreshActiveEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshActiveEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.RefreshActiveEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshActiveEventResponse and nil error while calling RefreshActiveEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveDeleteEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveDeleteEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.DeleteEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEventResponse and nil error while calling DeleteEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveDeleteEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.DeleteEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEventResponse and nil error while calling DeleteEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveHardDeleteUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHardDeleteUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHardDeleteUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchPredictionsServer) serveHardDeleteUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HardDeleteUserDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HardDeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.HardDeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteUserDataResponse and nil error while calling HardDeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) serveHardDeleteUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HardDeleteUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HardDeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchPredictions.HardDeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteUserDataResponse and nil error while calling HardDeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchPredictionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchPredictionsServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchPredictionsServer) PathPrefix() string {
	return TwitchPredictionsPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 4238 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5c, 0xcd, 0x6f, 0x1b, 0x49,
	0x76, 0x57, 0x53, 0xa6, 0x3e, 0x9e, 0xbe, 0x5a, 0xe5, 0x2f, 0x89, 0xb2, 0xc6, 0x72, 0xdb, 0x1e,
	0xdb, 0xda, 0x89, 0x9c, 0xf5, 0xce, 0xec, 0x78, 0xbc, 0xe3, 0xf1, 0x50, 0x64, 0x4b, 0xe6, 0x9a,
	0x22, 0xe9, 0x26, 0x69, 0xcf, 0x78, 0x81, 0x74, 0x5a, 0x64, 0x59, 0xea, 0x98, 0xea, 0xe6, 0xb2,
	0x9b, 0x96, 0x94, 0x20, 0x09, 0x76, 0x91, 0x45, 0x90, 0x60, 0x83, 0x7c, 0x2f, 0x90, 0x20, 0x40,
	0x80, 0x7c, 0x00, 0x0b, 0x64, 0xb1, 0xc8, 0x21, 0x87, 0x20, 0x87, 0x20, 0xb9, 0xe4, 0x90, 0x73,
	0x6e, 0x09, 0x72, 0x08, 0x82, 0xfc, 0x0b, 0x39, 0xe4, 0x12, 0xd4, 0x47, 0x37, 0xbb, 0xba, 0x9b,
	0x22, 0x9b, 0x94, 0x17, 0x73, 0x91, 0xd9, 0x55, 0xef, 0xbd, 0xfa, 0xd5, 0xab, 0x57, 0xaf, 0x5e,
	0xbd, 0xaa, 0x32, 0x7c, 0xb3, 0x61, 0x37, 0xf1, 0xd6, 0x2f, 0x75, 0x1d, 0xd7, 0xb4, 0xb6, 0xdc,
	0xb7, 0xf7, 0x8d, 0xa3, 0x5f, 0xb6, 0xee, 0xd7, 0x8e, 0x4d, 0xb7, 0x71, 0x58, 0xe9, 0xe0, 0xa6,
	0xd9, 0x70, 0x4d, 0xdb, 0x72, 0x6a, 0xc7, 0x66, 0xa7, 0x7d, 0xdf, 0x25, 0x7f, 0xb7, 0xda, 0x1d,
	0xdb, 0xb5, 0xd1, 0x1d, 0x97, 0xd2, 0x6c, 0xbd, 0xee, 0xb6, 0x5c, 0xdb, 0xda, 0xc2, 0x27, 0xc6,
	0x51, 0xbb, 0x85, 0xb7, 0x58, 0x69, 0xbb, 0xc7, 0x99, 0xb9, 0x7e, 0x60, 0xdb, 0x07, 0x2d, 0x7c,
	0x9f, 0xb2, 0xed, 0x77, 0x5f, 0xdf, 0x77, 0xcd, 0x23, 0xec, 0xb8, 0xc6, 0x11, 0x97, 0x94, 0x79,
	0x2f, 0x4c, 0x70, 0xdc, 0x31, 0xda, 0x6d, 0xdc, 0x71, 0x58, 0xbd, 0xf2, 0x08, 0x56, 0x77, 0xb1,
	0x9b, 0x3b, 0x34, 0x2c, 0x0b, 0xb7, 0xaa, 0xd8, 0x75, 0x4d, 0xeb, 0xc0, 0xd1, 0xf0, 0x77, 0xbb,
	0xd8, 0x71, 0xd1, 0x3a, 0x40, 0x83, 0xd5, 0xe8, 0x66, 0x73, 0x45, 0xda, 0x90, 0xee, 0xce, 0x6a,
	0xb3, 0xbc, 0xa4, 0xd0, 0x54, 0x3a, 0x90, 0x89, 0xe3, 0x75, 0xda, 0xb6, 0xe5, 0x60, 0x54, 0x83,
	0x19, 0x87, 0x97, 0x51, 0xd6, 0xb9, 0x07, 0x0f, 0xb7, 0x86, 0xec, 0xd6, 0x56, 0x58, 0xa6, 0x2f,
	0x49, 0xf9, 0x53, 0x09, 0xae, 0xd5, 0xdb, 0x4d, 0xc3, 0xc5, 0x23, 0x61, 0x46, 0xdf, 0x81, 0x6b,
	0x0d, 0xc3, 0xd2, 0x8f, 0xec, 0x26, 0xee, 0x18, 0xae, 0xdd, 0x71, 0xf4, 0x23, 0xc3, 0x32, 0x0e,
	0xb0, 0x8e, 0xdf, 0x62, 0xcb, 0x75, 0x56, 0x52, 0x14, 0x69, 0x66, 0x8b, 0xa9, 0x6d, 0xcb, 0x53,
	0xdb, 0xd6, 0xb6, 0x6d, 0xb7, 0x5e, 0x18, 0xad, 0x2e, 0xd6, 0x56, 0x1b, 0x86, 0xb5, 0xe7, 0xb3,
	0xef, 0x51, 0x6e, 0x95, 0x32, 0x2b, 0x5d, 0x58, 0xef, 0x83, 0xed, 0x9d, 0xea, 0xe4, 0x6f, 0x27,
	0x01, 0xe5, 0x3a, 0xd8, 0x70, 0x19, 0x8e, 0x21, 0x35, 0x91, 0x87, 0xb4, 0xd1, 0x70, 0xed, 0x0e,
	0xef, 0xf2, 0xd6, 0xd0, 0x40, 0xb2, 0x84, 0x4b, 0x63, 0xcc, 0xe8, 0x12, 0xa4, 0x5d, 0xd3, 0x6d,
	0xe1, 0x95, 0x49, 0x2a, 0x9f, 0x7d, 0xa0, 0xaf, 0xc1, 0x72, 0x8f, 0x43, 0x3f, 0x36, 0xad, 0xa6,
	0x7d, 0xbc, 0x72, 0x61, 0x43, 0xba, 0x3b, 0xa9, 0xc9, 0xbd, 0x8a, 0x97, 0xb4, 0x1c, 0xe9, 0x30,
	0x63, 0x77, 0xdd, 0x86, 0x7d, 0x84, 0x9d, 0x95, 0xf4, 0xc6, 0xe4, 0xdd, 0xb9, 0x07, 0xb9, 0xe1,
	0x95, 0x12, 0xe9, 0xf6, 0x56, 0x99, 0xc9, 0xd2, 0x7c, 0xa1, 0xe8, 0x26, 0x2c, 0x34, 0x0c, 0xab,
	0x81, 0x5b, 0x1e, 0x92, 0x29, 0x8a, 0x64, 0x9e, 0x15, 0x32, 0x14, 0x99, 0x16, 0x4c, 0x73, 0xce,
	0x5e, 0x9f, 0xa4, 0x60, 0x9f, 0x9e, 0x41, 0xba, 0x61, 0xb7, 0xb8, 0xbe, 0x16, 0x1f, 0x7c, 0x34,
	0x34, 0x46, 0x2e, 0x36, 0x47, 0x98, 0x35, 0x26, 0x43, 0xf9, 0x89, 0x04, 0x17, 0x05, 0xec, 0xdc,
	0x40, 0xf2, 0x90, 0xa6, 0x86, 0xc8, 0xad, 0x63, 0xf8, 0x41, 0x61, 0x62, 0x18, 0x33, 0x2a, 0x43,
	0x1a, 0x77, 0x3a, 0xfe, 0xd0, 0x7e, 0x32, 0x8a, 0x3a, 0x55, 0x22, 0x40, 0x63, 0x72, 0x94, 0x2e,
	0xa0, 0x1c, 0x55, 0x96, 0x60, 0x60, 0xbe, 0x05, 0x49, 0xe3, 0x58, 0xd0, 0x2a, 0xcc, 0x50, 0xd4,
	0xc4, 0x48, 0x53, 0x54, 0xe1, 0xd3, 0xf4, 0xbb, 0xd0, 0x64, 0x5a, 0x0a, 0xb6, 0xfb, 0x15, 0xd1,
	0x52, 0x0f, 0x92, 0xa0, 0xa5, 0x3f, 0x96, 0xe0, 0xa2, 0x86, 0x1d, 0xbb, 0xf5, 0x16, 0xff, 0x4c,
	0xf5, 0x44, 0x66, 0x3a, 0x37, 0x76, 0x52, 0xc9, 0x66, 0xe2, 0x2c, 0x2f, 0x29, 0x34, 0x95, 0x9f,
	0x4a, 0x70, 0x49, 0xc4, 0x75, 0xae, 0x7a, 0xac, 0x88, 0x7a, 0x7c, 0x34, 0xb4, 0x94, 0x20, 0x26,
	0x41, 0x91, 0x0e, 0xc8, 0x45, 0xbb, 0xf1, 0xe6, 0x67, 0x6b, 0x6c, 0x3f, 0x96, 0x60, 0x39, 0xd0,
	0xea, 0xb9, 0xaa, 0x68, 0x4f, 0x54, 0xd1, 0xc7, 0x43, 0x4b, 0xf1, 0x01, 0x09, 0xfa, 0x39, 0x84,
	0xd5, 0xa2, 0xe9, 0xb8, 0x5c, 0x7f, 0x4d, 0xb6, 0xfa, 0x0c, 0xe9, 0xf6, 0xaf, 0xc0, 0x54, 0xa3,
	0xdb, 0x71, 0x38, 0x96, 0x59, 0x8d, 0x7f, 0x11, 0xa7, 0xd7, 0x32, 0x8f, 0x4c, 0x97, 0x9a, 0xcf,
	0xa4, 0xc6, 0x3e, 0x94, 0xdf, 0x4b, 0x41, 0x26, 0xae, 0x29, 0xae, 0x9d, 0x06, 0xa4, 0x71, 0xf3,
	0x00, 0x93, 0xc5, 0x8c, 0xf8, 0xed, 0xbd, 0xe1, 0xfb, 0xd5, 0x57, 0x26, 0x53, 0x9c, 0xda, 0x3c,
	0xc0, 0x1a, 0x93, 0x8d, 0x14, 0x58, 0x38, 0x34, 0x1c, 0xdd, 0xc2, 0x27, 0xae, 0xde, 0x36, 0x0e,
	0x30, 0x05, 0x3e, 0xa3, 0xcd, 0x1d, 0x1a, 0x4e, 0x09, 0x9f, 0xb8, 0x15, 0xe3, 0x00, 0x67, 0x4c,
	0x98, 0xf5, 0xf9, 0xce, 0x69, 0xcc, 0xfa, 0x28, 0x4a, 0xf9, 0x18, 0xae, 0xec, 0x62, 0x37, 0xdb,
	0x70, 0x4d, 0x6e, 0xba, 0xc3, 0x86, 0x4b, 0x06, 0x5c, 0x8d, 0x30, 0x72, 0x3d, 0xee, 0xc0, 0x14,
	0x8f, 0x3f, 0x98, 0x22, 0x93, 0x42, 0xe6, 0xdc, 0x1c, 0x1b, 0x31, 0x9a, 0x64, 0x56, 0xc1, 0xb1,
	0x89, 0x8c, 0xe7, 0x8c, 0xad, 0x0e, 0x6b, 0xbb, 0xd8, 0xd5, 0x70, 0x03, 0x5b, 0x6e, 0x20, 0xf8,
	0x1d, 0xd2, 0x6c, 0xaf, 0xc2, 0x74, 0xd7, 0xc1, 0x9d, 0xde, 0xbc, 0x9d, 0x22, 0x9f, 0x85, 0xa6,
	0xd2, 0x85, 0x6b, 0xf1, 0x62, 0x39, 0xfc, 0x3a, 0xcc, 0x05, 0x30, 0xf1, 0x3e, 0x7c, 0x63, 0xe8,
	0x3e, 0xf4, 0x44, 0x6a, 0x41, 0x39, 0xca, 0x1b, 0xb8, 0x46, 0x6c, 0x98, 0xe9, 0x6a, 0xfb, 0x94,
	0x07, 0x67, 0x85, 0xfc, 0x3b, 0x99, 0x85, 0x3f, 0x4a, 0xc1, 0x7a, 0x9f, 0xd6, 0x78, 0x2f, 0x5f,
	0x8b, 0x13, 0xb1, 0x92, 0x68, 0x22, 0xf6, 0x15, 0xfb, 0x95, 0x9f, 0x8b, 0x5f, 0xa7, 0xf6, 0x5e,
	0x77, 0x70, 0x27, 0xbc, 0x0d, 0x08, 0xd8, 0x8b, 0x24, 0xd8, 0x4b, 0x8b, 0x5a, 0xba, 0xc8, 0xc2,
	0x95, 0xf8, 0x3c, 0x12, 0x9d, 0x0f, 0x1f, 0xe4, 0x09, 0x02, 0x7b, 0xa1, 0xb9, 0x06, 0x2b, 0x5e,
	0x6b, 0xae, 0xe1, 0x9a, 0x8e, 0x6b, 0x36, 0xc6, 0xb6, 0x78, 0x97, 0x6e, 0xd9, 0xc2, 0x32, 0x79,
	0x1f, 0x5e, 0x02, 0x38, 0x7e, 0x29, 0xef, 0xc5, 0xc7, 0xc9, 0x7a, 0xd1, 0x13, 0x1a, 0x10, 0xa5,
	0xb4, 0xe8, 0x3c, 0x2b, 0x38, 0x1a, 0x3e, 0x20, 0x93, 0x01, 0x3b, 0x6e, 0xc7, 0x6c, 0xb8, 0xb8,
	0xe9, 0xf5, 0xe6, 0x06, 0xcc, 0x37, 0xec, 0xae, 0xe5, 0x76, 0x4e, 0x75, 0xb2, 0xe9, 0xe5, 0xfd,
	0x99, 0xe3, 0x65, 0x39, 0xbb, 0x89, 0xd1, 0x3d, 0x90, 0x9d, 0xee, 0x7e, 0xd3, 0x7c, 0x6b, 0x3a,
	0x64, 0x5b, 0x40, 0xc9, 0x58, 0xd7, 0x96, 0x02, 0xe5, 0x84, 0x54, 0xc9, 0xc3, 0x7a, 0x9f, 0xd6,
	0x78, 0x3f, 0x6f, 0xc2, 0x82, 0xe9, 0xe8, 0x1d, 0xbf, 0x82, 0xb6, 0x37, 0xa3, 0xcd, 0x9b, 0x4e,
	0x8f, 0x58, 0xa9, 0x52, 0x29, 0xa4, 0x53, 0xd4, 0x9a, 0x02, 0x73, 0x79, 0x80, 0x95, 0x9c, 0x15,
	0x27, 0x74, 0xe1, 0xbd, 0x7e, 0x42, 0x39, 0xb6, 0x2a, 0x40, 0x4f, 0xa9, 0x7c, 0x0c, 0x46, 0xf2,
	0x38, 0x01, 0x31, 0xca, 0x5f, 0x48, 0x62, 0xbb, 0x5e, 0x37, 0xc7, 0xeb, 0x4d, 0x64, 0xd8, 0x26,
	0x87, 0x1b, 0xb6, 0x0b, 0xf1, 0xc3, 0xf6, 0xab, 0x70, 0xbd, 0x2f, 0x46, 0xae, 0x9c, 0x57, 0x30,
	0xd7, 0xe9, 0x15, 0x53, 0xa0, 0x8b, 0x09, 0x76, 0xc1, 0x44, 0x76, 0x50, 0x6c, 0x50, 0x98, 0xf2,
	0x1f, 0x12, 0xac, 0xb2, 0x0d, 0x78, 0x12, 0x97, 0x80, 0xf2, 0x20, 0x13, 0xa7, 0x66, 0x34, 0x1a,
	0xb8, 0xed, 0xe2, 0xa6, 0xee, 0xda, 0xc3, 0xe4, 0x01, 0x16, 0x0f, 0x0d, 0x27, 0xcb, 0x59, 0x6a,
	0xb6, 0x83, 0x7e, 0x11, 0xae, 0x9b, 0x8e, 0xee, 0xe2, 0xa3, 0xb6, 0xdd, 0x31, 0x88, 0x3a, 0x0f,
	0x0d, 0x57, 0xdf, 0x37, 0x9a, 0x07, 0x58, 0xc7, 0x96, 0xb1, 0xdf, 0xc2, 0x2c, 0x32, 0x3f, 0x5b,
	0xe8, 0x9a, 0xe9, 0xd4, 0x3c, 0x09, 0xb9, 0x43, 0xc3, 0xdd, 0x26, 0xfc, 0x2a, 0x63, 0x57, 0x6c,
	0xc8, 0xc4, 0xf5, 0xee, 0xdd, 0x79, 0xaf, 0xff, 0x95, 0xe0, 0xf2, 0x9e, 0xf1, 0x06, 0x9f, 0xcb,
	0xc4, 0x19, 0xb0, 0x4b, 0x21, 0x3e, 0xbe, 0x6d, 0x9b, 0x24, 0xce, 0x60, 0x89, 0x02, 0xfe, 0x85,
	0x6e, 0xc3, 0xa2, 0xdb, 0x31, 0x2c, 0xc7, 0x60, 0xc9, 0x04, 0xb3, 0xb9, 0x92, 0xa6, 0xac, 0x0b,
	0x81, 0xd2, 0x18, 0x43, 0x9e, 0x1a, 0xce, 0x90, 0xa7, 0xe3, 0x0d, 0xf9, 0x9f, 0x25, 0xb8, 0x12,
	0xee, 0xf9, 0x3b, 0x9c, 0xdd, 0x48, 0x13, 0x37, 0x08, 0x9f, 0x0e, 0x2d, 0x4f, 0x04, 0x29, 0xec,
	0x12, 0xf6, 0x41, 0xc9, 0x36, 0xde, 0x58, 0xf6, 0x71, 0x8b, 0xac, 0xdd, 0x42, 0x4f, 0xba, 0x2d,
	0x77, 0xe0, 0x48, 0xde, 0x84, 0x85, 0x40, 0x0e, 0xc7, 0x1f, 0xce, 0xf9, 0x5e, 0x61, 0xa1, 0xa9,
	0xfc, 0xbb, 0x04, 0x37, 0xcf, 0x6c, 0xe4, 0x5d, 0x2a, 0x4d, 0x17, 0x95, 0x56, 0x48, 0xb0, 0x25,
	0xec, 0x8b, 0x58, 0xd0, 0xe0, 0x2d, 0x90, 0x77, 0xb1, 0x2b, 0x06, 0xd2, 0x32, 0x4c, 0x9a, 0x4d,
	0x16, 0x67, 0xcd, 0x6a, 0xe4, 0xa7, 0xf2, 0x9f, 0x12, 0x2c, 0x07, 0xc8, 0x78, 0x8f, 0x7f, 0x21,
	0x14, 0x36, 0xef, 0x0c, 0x8d, 0x2e, 0x22, 0x8b, 0xc5, 0x42, 0x8e, 0x4a, 0x0c, 0xd9, 0x0b, 0xa7,
	0x33, 0x26, 0xcc, 0x05, 0x8a, 0x09, 0xac, 0x37, 0xf8, 0x94, 0x0f, 0x21, 0xf9, 0x49, 0x22, 0xaf,
	0xb7, 0xc4, 0xa7, 0x24, 0xce, 0xef, 0xf1, 0xc8, 0x8b, 0x32, 0x3f, 0x4a, 0x3d, 0x94, 0x94, 0x7b,
	0x70, 0x79, 0x17, 0xc7, 0xc5, 0xec, 0x51, 0x5d, 0x7c, 0x2f, 0x45, 0x23, 0xb2, 0xb8, 0x40, 0xbc,
	0x13, 0x17, 0x88, 0x57, 0x92, 0x68, 0x25, 0x46, 0x6a, 0xc0, 0x34, 0xb8, 0x7e, 0x82, 0x8d, 0x64,
	0x1c, 0x90, 0xc3, 0x04, 0x31, 0x9a, 0x2a, 0x88, 0x9a, 0x1a, 0xc9, 0x2e, 0x03, 0xea, 0x7a, 0x08,
	0x6b, 0x39, 0xdb, 0x6a, 0xb4, 0xba, 0x4d, 0x5c, 0xc1, 0x56, 0xd3, 0xb4, 0x0e, 0x84, 0x44, 0x46,
	0xd0, 0x43, 0x4a, 0x62, 0x68, 0xf1, 0x8f, 0x12, 0x5c, 0x8b, 0x67, 0x3d, 0xd7, 0x6c, 0xc4, 0x17,
	0xe2, 0xbc, 0xd9, 0x1e, 0x3e, 0xf1, 0x15, 0x83, 0x4d, 0x98, 0x30, 0x8f, 0x61, 0xc3, 0xb3, 0xde,
	0x80, 0xde, 0x49, 0x44, 0xd9, 0x75, 0x86, 0xe8, 0xbf, 0x0e, 0x37, 0xce, 0x60, 0xe7, 0x3a, 0x78,
	0x04, 0xab, 0x46, 0xab, 0xa5, 0x07, 0x70, 0xe9, 0xed, 0x8e, 0xdd, 0xc0, 0x8e, 0xe3, 0x47, 0x81,
	0x57, 0x8d, 0x56, 0x2b, 0x20, 0xa0, 0xe2, 0x55, 0x2b, 0xdf, 0x81, 0xf7, 0xfd, 0x0d, 0x4f, 0xdd,
	0xf2, 0xd9, 0x62, 0x4c, 0xbb, 0x3f, 0xca, 0xbe, 0x9b, 0x91, 0x43, 0xb8, 0x33, 0x50, 0x38, 0xef,
	0xc3, 0x6d, 0x58, 0x14, 0x7c, 0xab, 0x37, 0x87, 0x16, 0x82, 0xce, 0xd5, 0xe9, 0xdb, 0xd2, 0x2b,
	0x58, 0xe1, 0xc9, 0x93, 0xe8, 0xca, 0x1c, 0x71, 0xdb, 0x52, 0xd4, 0x6d, 0x9f, 0x15, 0xde, 0x76,
	0x60, 0x35, 0x46, 0xb6, 0xbf, 0x99, 0xe6, 0x96, 0xc3, 0xec, 0xef, 0x49, 0xd2, 0x54, 0x5f, 0x9f,
	0x95, 0xea, 0x4b, 0xb8, 0xaa, 0xe1, 0xd7, 0x5d, 0xab, 0x79, 0xfe, 0xdd, 0x69, 0x13, 0x55, 0x85,
	0x45, 0xfb, 0xa7, 0x31, 0x42, 0x6f, 0x3e, 0x4b, 0xd0, 0x1b, 0x51, 0x62, 0x68, 0xd9, 0x5d, 0xd5,
	0xf0, 0xeb, 0x0e, 0x76, 0x0e, 0x03, 0xa9, 0x9e, 0x21, 0xcc, 0x6a, 0x13, 0x96, 0x9d, 0x37, 0x66,
	0x5b, 0x37, 0x28, 0x97, 0xde, 0x38, 0xc4, 0x8d, 0x37, 0x7c, 0x7b, 0xbd, 0x44, 0x2a, 0x98, 0xb4,
	0x1c, 0x29, 0x56, 0x5c, 0xc8, 0xc4, 0xb5, 0xc1, 0xfb, 0xf5, 0x42, 0xec, 0xd7, 0xe7, 0x49, 0xfa,
	0x15, 0x92, 0x29, 0xf4, 0xec, 0x3e, 0xa0, 0x3c, 0x6e, 0x61, 0x77, 0xd8, 0x2e, 0x29, 0x97, 0xe1,
	0xa2, 0xc0, 0xc0, 0xf0, 0x29, 0x1f, 0xc2, 0xea, 0x53, 0xa3, 0xd3, 0x64, 0x55, 0x24, 0xf4, 0xcc,
	0x1b, 0xae, 0x31, 0x70, 0xe3, 0xfe, 0x97, 0x29, 0xc8, 0xc4, 0xb1, 0xf1, 0x4e, 0xdf, 0x80, 0xf9,
	0x8e, 0x7d, 0xec, 0xe8, 0x4d, 0x5a, 0xcd, 0x98, 0x27, 0xb5, 0x39, 0x52, 0xc6, 0x38, 0x9a, 0xc4,
	0x73, 0x04, 0x6c, 0x89, 0xad, 0xa3, 0x3e, 0x7d, 0x8a, 0xd2, 0x5f, 0xed, 0x11, 0xb0, 0xd5, 0xd5,
	0xe3, 0x7d, 0x00, 0x97, 0x29, 0x2c, 0x2f, 0x36, 0xf6, 0xf9, 0x58, 0xa2, 0xe6, 0x62, 0x37, 0x10,
	0x41, 0x7b, 0x3c, 0x0f, 0x61, 0xc5, 0xdb, 0xe0, 0x47, 0xd8, 0x58, 0x8c, 0x7b, 0xa5, 0x21, 0x1e,
	0xea, 0x05, 0x38, 0x99, 0x4e, 0x7b, 0x1b, 0x70, 0x9f, 0x33, 0xcd, 0x38, 0x69, 0x7d, 0x6f, 0xaf,
	0xce, 0x39, 0x95, 0xff, 0x4e, 0x43, 0x9a, 0x22, 0x1f, 0x94, 0x5e, 0xf8, 0x04, 0xa0, 0x41, 0x4f,
	0x7b, 0x9a, 0xba, 0xe1, 0xf6, 0xdd, 0xee, 0xd4, 0xbc, 0xe3, 0x64, 0x6d, 0x96, 0x53, 0x67, 0x5d,
	0xb4, 0xd7, 0x63, 0xdd, 0x3f, 0xe5, 0x9b, 0x9a, 0xa4, 0xf9, 0x78, 0x4f, 0xdc, 0xf6, 0x29, 0xfa,
	0x08, 0x66, 0xb0, 0xd5, 0x64, 0x38, 0x2e, 0x0c, 0xc4, 0x31, 0x4d, 0x69, 0xb3, 0x2e, 0x2a, 0x78,
	0x6c, 0xfb, 0xa7, 0x54, 0x27, 0xc9, 0x31, 0x30, 0x51, 0xdb, 0xa7, 0x68, 0x11, 0x52, 0x66, 0x93,
	0xef, 0x18, 0x52, 0x66, 0x13, 0x15, 0x03, 0x27, 0x92, 0xd3, 0x34, 0x4e, 0xf9, 0xf9, 0xa4, 0xa7,
	0x7d, 0x81, 0xe3, 0x47, 0xd1, 0xec, 0xd8, 0x11, 0xa4, 0xee, 0xe0, 0x86, 0x6d, 0x35, 0x9d, 0x95,
	0x99, 0xb0, 0xd9, 0xb1, 0xe3, 0xc8, 0x2a, 0xab, 0x46, 0x1f, 0xc3, 0x6c, 0x8b, 0x26, 0x65, 0x89,
	0x72, 0x66, 0x07, 0x2a, 0x67, 0x86, 0x11, 0x67, 0x5d, 0xf4, 0xcc, 0x67, 0xdc, 0x3f, 0x5d, 0x81,
	0x91, 0xd4, 0xc3, 0x85, 0x6d, 0x9f, 0xa2, 0x22, 0x4c, 0x39, 0x74, 0x11, 0x5e, 0x99, 0xa3, 0xdb,
	0xf5, 0x0f, 0x93, 0xc5, 0x1d, 0x7c, 0x01, 0xe7, 0x32, 0x7a, 0xc7, 0xab, 0xf3, 0xc1, 0xe3, 0xd5,
	0x0f, 0x00, 0x1d, 0x9b, 0x96, 0x65, 0x5a, 0x07, 0x7a, 0x60, 0x97, 0xb8, 0x40, 0x49, 0x64, 0x5e,
	0x53, 0xf6, 0x8f, 0xb4, 0xfe, 0x2b, 0xd5, 0x3b, 0xae, 0xf5, 0x0f, 0x66, 0xa5, 0xf1, 0x0f, 0x66,
	0xb9, 0x29, 0xa4, 0x7c, 0x53, 0x88, 0x3f, 0xdf, 0xbe, 0x01, 0xf3, 0xae, 0xed, 0x1a, 0x2d, 0x5d,
	0xd8, 0xb1, 0xce, 0xd1, 0xb2, 0x0a, 0xdb, 0xb6, 0x5e, 0x07, 0xf6, 0xa9, 0x13, 0xcf, 0xe0, 0xf0,
	0x59, 0x0b, 0xb4, 0x88, 0xf8, 0x2e, 0x07, 0xbd, 0x82, 0x45, 0xd7, 0x6e, 0x7b, 0x71, 0x8c, 0xdd,
	0x71, 0x56, 0xa6, 0x46, 0xcf, 0x4d, 0x2f, 0xb8, 0x76, 0xbb, 0xe2, 0x4b, 0x22, 0x71, 0x22, 0xcd,
	0x3c, 0xd0, 0xed, 0x6d, 0x92, 0x91, 0xa7, 0xf9, 0x06, 0x8d, 0x31, 0x2b, 0x0f, 0x21, 0x4d, 0xbf,
	0xd1, 0x0a, 0x4c, 0xbf, 0xc5, 0x1d, 0xc7, 0xdb, 0xba, 0xcd, 0x6a, 0xde, 0x27, 0xba, 0x0c, 0x53,
	0x0e, 0x0e, 0xac, 0xbb, 0x69, 0x07, 0x13, 0xc7, 0xff, 0x6f, 0x29, 0x80, 0x1e, 0x3a, 0xae, 0x54,
	0xc9, 0x57, 0xea, 0xf9, 0x27, 0x09, 0x1e, 0x83, 0x17, 0x11, 0xb0, 0xa9, 0x92, 0x1e, 0x38, 0x55,
	0xe6, 0x7c, 0xfa, 0xac, 0x4b, 0x9c, 0x61, 0x97, 0x66, 0x56, 0x28, 0xf3, 0xd4, 0x60, 0x67, 0xc8,
	0xa9, 0xb3, 0xc2, 0x7a, 0x35, 0x2d, 0xec, 0x9f, 0x9f, 0xc3, 0x54, 0x87, 0x6e, 0x29, 0xe9, 0x1c,
	0x4f, 0x72, 0xbe, 0x1c, 0xd9, 0x45, 0x73, 0x41, 0xca, 0x0f, 0x25, 0x48, 0xd3, 0xb9, 0x89, 0x3e,
	0x12, 0x57, 0xc9, 0xb9, 0x07, 0xd7, 0x22, 0x68, 0xab, 0x6e, 0xc7, 0xb4, 0x0e, 0x58, 0x5a, 0xc9,
	0xc3, 0x54, 0x84, 0x8b, 0xf8, 0xc4, 0xc5, 0x16, 0xcb, 0x7f, 0xb4, 0xcc, 0xc0, 0x18, 0x0c, 0x12,
	0xb1, 0xec, 0x33, 0xe6, 0x28, 0x5f, 0xa1, 0xa9, 0xfc, 0x1a, 0xcc, 0x07, 0x13, 0x47, 0xe8, 0x6e,
	0x4c, 0x1e, 0x8d, 0x05, 0xe4, 0xe1, 0x5c, 0x59, 0x7e, 0x70, 0xae, 0x8c, 0x45, 0x3e, 0x67, 0xe6,
	0xc3, 0x7e, 0x5f, 0x82, 0xa5, 0xd0, 0xad, 0x18, 0xf4, 0x64, 0xc0, 0xfd, 0x1e, 0x86, 0xa7, 0xff,
	0x1d, 0x1e, 0xf4, 0x18, 0xd6, 0x4c, 0x47, 0xc7, 0x2d, 0xf3, 0xc0, 0xdc, 0x6f, 0x61, 0xfd, 0xb5,
	0xdd, 0x09, 0x6e, 0x35, 0x38, 0xac, 0x15, 0xd3, 0x51, 0x39, 0xc5, 0x8e, 0xdd, 0x09, 0x44, 0xf8,
	0xca, 0xdf, 0xa7, 0x60, 0x51, 0xcc, 0xa2, 0x13, 0x67, 0xc1, 0x63, 0x0d, 0x3a, 0xfb, 0xbd, 0xc8,
	0x84, 0x95, 0xd5, 0x48, 0x11, 0xb1, 0x7a, 0x4e, 0x72, 0x6c, 0x5b, 0x3c, 0x14, 0x99, 0x65, 0x25,
	0x2f, 0x6d, 0x0b, 0x7d, 0x02, 0xab, 0x47, 0xb6, 0xe3, 0xea, 0x1d, 0x7a, 0xca, 0xa5, 0x8b, 0x01,
	0x31, 0x9b, 0x23, 0x57, 0x08, 0x41, 0xf8, 0x14, 0xac, 0xd0, 0x24, 0x6e, 0x88, 0x4d, 0x11, 0xe2,
	0x87, 0xbc, 0xb0, 0x03, 0x58, 0x51, 0xdd, 0xc1, 0x74, 0xc2, 0x71, 0x02, 0xd2, 0x34, 0x73, 0x53,
	0xb3, 0xac, 0x84, 0x34, 0x7d, 0x0b, 0x16, 0x7b, 0xd5, 0xfa, 0x91, 0x71, 0xe2, 0x5d, 0x9e, 0xf1,
	0x49, 0xf6, 0x8c, 0x13, 0x22, 0xe4, 0xd8, 0xb4, 0x74, 0xc7, 0xed, 0x60, 0xe3, 0x0d, 0x9d, 0x07,
	0x93, 0xda, 0xec, 0xb1, 0x69, 0x55, 0x69, 0x01, 0x11, 0xd2, 0xab, 0xa6, 0x42, 0xd8, 0xb2, 0x37,
	0xef, 0x93, 0xec, 0x19, 0x27, 0xca, 0xbf, 0x4a, 0xc1, 0xdd, 0x3a, 0x33, 0x7d, 0xf4, 0x1c, 0x2e,
	0xb8, 0xa7, 0x6d, 0xcc, 0x7d, 0xfb, 0xe3, 0x91, 0xe7, 0x50, 0xed, 0xb4, 0x8d, 0x35, 0x2a, 0x0a,
	0x3d, 0x12, 0x7a, 0xcc, 0x6c, 0x7f, 0x2d, 0x62, 0xfb, 0x05, 0xcb, 0xfd, 0xe6, 0x87, 0xcc, 0xf4,
	0x03, 0xea, 0xb8, 0x03, 0x4b, 0x26, 0xb1, 0x70, 0x3f, 0x7f, 0xc4, 0xf4, 0x3f, 0xa3, 0x2d, 0x9a,
	0x4e, 0x20, 0xab, 0xd4, 0x54, 0x7e, 0x1d, 0xe4, 0xf0, 0x65, 0x1a, 0xd2, 0x17, 0xff, 0x68, 0x24,
	0x49, 0x5f, 0xc2, 0x82, 0x72, 0x76, 0x13, 0x6b, 0x54, 0x14, 0xf1, 0xcc, 0x47, 0xd8, 0x71, 0xbc,
	0x93, 0xb8, 0x59, 0xcd, 0xfb, 0xa4, 0x00, 0x42, 0xf7, 0x54, 0x46, 0x07, 0x10, 0x12, 0x34, 0x14,
	0x80, 0xef, 0x49, 0xb0, 0x1c, 0xb9, 0xe1, 0x81, 0x34, 0x01, 0xc2, 0x67, 0xa3, 0xdf, 0x15, 0x19,
	0x0a, 0xc3, 0xaf, 0xc0, 0xa2, 0x78, 0x83, 0x02, 0x95, 0x85, 0xf6, 0xbf, 0x35, 0xe2, 0x45, 0x8c,
	0xa1, 0x1a, 0xff, 0x7e, 0x0a, 0x2e, 0xc6, 0xa4, 0x67, 0x51, 0x4d, 0x80, 0xf0, 0xf9, 0x38, 0xa9,
	0xde, 0x00, 0x8e, 0x22, 0x5c, 0x3a, 0x32, 0x4e, 0x78, 0x40, 0xa2, 0xb7, 0x71, 0x87, 0x79, 0xbc,
	0x61, 0xec, 0x7b, 0xf9, 0xc8, 0x38, 0x61, 0x51, 0x4b, 0x85, 0x1f, 0xdc, 0xa0, 0x5d, 0x58, 0xa6,
	0xeb, 0x0b, 0x17, 0xe7, 0xb4, 0x89, 0xa8, 0xc9, 0xc1, 0xa2, 0x96, 0x08, 0x17, 0x93, 0x55, 0x25,
	0x3c, 0xca, 0x0f, 0x24, 0xd8, 0x18, 0x94, 0x6e, 0x45, 0x86, 0xa0, 0x91, 0xbd, 0x73, 0xcb, 0xe3,
	0xf6, 0xd4, 0xa3, 0x1c, 0xc3, 0x6a, 0xdf, 0xec, 0x15, 0x7a, 0x25, 0xb4, 0xbf, 0x33, 0x7e, 0x3e,
	0x2c, 0xd0, 0xf0, 0x77, 0xe1, 0x4a, 0x7c, 0xf2, 0x03, 0xbd, 0x14, 0x5a, 0xcd, 0x8d, 0x99, 0x4b,
	0x09, 0x34, 0x69, 0xc3, 0xe5, 0xd8, 0x0c, 0x05, 0x7a, 0x21, 0xb4, 0xb8, 0x3d, 0x5e, 0xbe, 0x23,
	0xd0, 0xa0, 0x43, 0xf3, 0x37, 0x71, 0xa9, 0x03, 0xf4, 0x85, 0xd0, 0x64, 0x7e, 0xdc, 0x54, 0x44,
	0xaf, 0xd1, 0xcd, 0xff, 0x4b, 0xc1, 0xa5, 0x38, 0xcf, 0x88, 0x56, 0xe1, 0x72, 0x4e, 0x53, 0xb3,
	0x35, 0x55, 0x57, 0x5f, 0xa8, 0xa5, 0x9a, 0x5e, 0x2a, 0xeb, 0xaa, 0xa6, 0x95, 0x35, 0x79, 0x02,
	0x65, 0xe0, 0x8a, 0x50, 0xb5, 0x53, 0xd6, 0xb6, 0x0b, 0xf9, 0xbc, 0x5a, 0x92, 0x25, 0x74, 0x1d,
	0xd6, 0x84, 0xba, 0x6c, 0xbd, 0x56, 0xde, 0x2b, 0xe7, 0xf5, 0x9d, 0x6c, 0xa1, 0xa8, 0xe6, 0xe5,
	0x14, 0xba, 0x0d, 0x37, 0x04, 0x02, 0x4e, 0x56, 0xd4, 0xd4, 0x6c, 0xfe, 0x4b, 0x3d, 0x9b, 0xab,
	0x15, 0x5e, 0xa8, 0xf2, 0x24, 0xfa, 0x1a, 0xdc, 0x11, 0xc8, 0x72, 0x4f, 0xb3, 0xa5, 0x92, 0x5a,
	0xd4, 0x2b, 0xe5, 0x42, 0xa9, 0x56, 0xd5, 0x4b, 0xe5, 0x9a, 0xae, 0x96, 0xb2, 0xdb, 0x44, 0xe6,
	0x05, 0xa4, 0xc0, 0x7b, 0x22, 0x71, 0xb9, 0x58, 0xd6, 0x18, 0x51, 0xbd, 0x54, 0x78, 0x5e, 0x57,
	0xe5, 0x34, 0xba, 0x05, 0x1b, 0xa1, 0xfe, 0x10, 0x09, 0xe5, 0xfa, 0xee, 0x53, 0xbd, 0x5c, 0xaf,
	0xe5, 0xca, 0x7b, 0x6a, 0x55, 0x9e, 0x8a, 0x48, 0xaa, 0x95, 0xcb, 0xfa, 0x5e, 0xb6, 0xf4, 0x65,
	0x8f, 0x66, 0x1a, 0x6d, 0xc2, 0xfb, 0x02, 0x4d, 0xa1, 0xf4, 0x22, 0x5b, 0x2c, 0xe4, 0xf5, 0x8a,
	0xa6, 0xe6, 0x0b, 0xb9, 0x5a, 0xa1, 0x5c, 0xd2, 0x5f, 0x16, 0x4a, 0xf9, 0xf2, 0x4b, 0x79, 0x06,
	0xad, 0xc3, 0xaa, 0x40, 0xab, 0x91, 0x9f, 0xc5, 0xc2, 0x5e, 0xa1, 0xa6, 0xe6, 0xe5, 0xd9, 0xcd,
	0xdf, 0x94, 0xe0, 0x52, 0xdc, 0xb2, 0x40, 0xb5, 0x9f, 0x2d, 0xe5, 0xd4, 0x62, 0xbc, 0xf6, 0x83,
	0x55, 0x41, 0xed, 0x87, 0xeb, 0x48, 0x27, 0x77, 0xca, 0xf5, 0x12, 0x51, 0xfc, 0x35, 0x58, 0x11,
	0xea, 0xf8, 0xdf, 0x52, 0x5e, 0xcd, 0xcb, 0x93, 0x9b, 0x3f, 0x94, 0x88, 0xb9, 0xc7, 0xac, 0x0e,
	0x44, 0xa6, 0xa6, 0x56, 0xcb, 0xc5, 0x17, 0x31, 0x96, 0xb0, 0x06, 0x57, 0xc5, 0xba, 0x20, 0x98,
	0x48, 0x65, 0x10, 0xcd, 0x3a, 0xac, 0x8a, 0x95, 0x22, 0x9c, 0xef, 0x4b, 0x80, 0xa2, 0x8b, 0x05,
	0xba, 0x0a, 0x17, 0x8b, 0xe5, 0xdc, 0xb3, 0x28, 0x90, 0x15, 0xb8, 0x14, 0xa8, 0x08, 0xa2, 0x10,
	0x6b, 0x82, 0x10, 0xae, 0xc3, 0x5a, 0xa0, 0xa6, 0x57, 0xef, 0xd9, 0xe0, 0xe6, 0x4f, 0xd2, 0x70,
	0xb5, 0xcf, 0x72, 0x41, 0xb4, 0xb9, 0x97, 0x7d, 0xa6, 0x06, 0x07, 0x3d, 0x00, 0x67, 0x1d, 0x56,
	0xc3, 0xb5, 0x41, 0x4c, 0x31, 0xd5, 0x41, 0x60, 0xb7, 0x60, 0x23, 0x5c, 0x1d, 0x45, 0x87, 0xee,
	0xc1, 0xed, 0x30, 0x55, 0xbe, 0x5e, 0x29, 0x16, 0x72, 0xc4, 0xc4, 0x6a, 0x5a, 0xb6, 0x54, 0xcd,
	0xd2, 0x52, 0xf9, 0x02, 0x99, 0x4c, 0x61, 0xd2, 0x00, 0x81, 0x5e, 0x28, 0xe9, 0x15, 0xad, 0xbc,
	0xab, 0xa9, 0xd5, 0xaa, 0x9c, 0x26, 0x13, 0x34, 0x0e, 0x1c, 0x9f, 0x2b, 0x6c, 0xfe, 0xc9, 0x53,
	0xe8, 0x2e, 0xdc, 0x0a, 0x93, 0xed, 0x65, 0xbf, 0xf0, 0xe6, 0x67, 0x45, 0xd5, 0x18, 0x66, 0x79,
	0x1a, 0xdd, 0x81, 0x9b, 0x11, 0xca, 0x7a, 0xb1, 0x56, 0xa8, 0x14, 0x55, 0xbd, 0x5c, 0x61, 0x08,
	0xf2, 0x55, 0x79, 0x26, 0x8e, 0x30, 0x57, 0x2e, 0xe5, 0xea, 0x9a, 0x46, 0xa7, 0x8e, 0xfa, 0xbc,
	0xae, 0x56, 0x6b, 0x55, 0x79, 0x16, 0xdd, 0x80, 0xf5, 0x30, 0xa1, 0xa6, 0xee, 0x92, 0x7f, 0xc8,
	0x80, 0xaa, 0x79, 0x19, 0xd0, 0x4d, 0xb8, 0x1e, 0x6d, 0xb4, 0x4a, 0xd4, 0x97, 0x53, 0x2b, 0x64,
	0x5e, 0x57, 0xe5, 0x39, 0xb4, 0x01, 0xd7, 0x22, 0x72, 0x82, 0x13, 0x74, 0x9e, 0xcc, 0xf5, 0x08,
	0xa4, 0x6c, 0x4d, 0xdd, 0x2d, 0x6b, 0x5f, 0x86, 0x9a, 0x5c, 0x88, 0x43, 0xc5, 0x86, 0x6d, 0x2f,
	0x5b, 0xca, 0xee, 0xaa, 0x9a, 0xbc, 0x88, 0x7e, 0x0e, 0xee, 0x85, 0x49, 0xaa, 0x15, 0x35, 0x57,
	0xcb, 0xd6, 0xca, 0x9a, 0xbe, 0x57, 0xce, 0xab, 0x7a, 0xa1, 0xa4, 0x16, 0x0b, 0xbb, 0x85, 0xed,
	0xa2, 0x2a, 0x2f, 0xa1, 0x0f, 0xe0, 0xee, 0x00, 0x72, 0x7f, 0xc4, 0x65, 0x79, 0xf3, 0x7f, 0x24,
	0xb8, 0x35, 0xcc, 0x5a, 0x4e, 0xcc, 0x21, 0x9b, 0x7b, 0x56, 0x2a, 0xbf, 0x2c, 0xaa, 0xf9, 0xdd,
	0x90, 0x16, 0xab, 0xf5, 0x22, 0x75, 0xaf, 0xbe, 0x29, 0x7f, 0x00, 0x77, 0x07, 0x10, 0x07, 0x2d,
	0x7b, 0x30, 0x75, 0xd0, 0xd0, 0x3f, 0x82, 0xaf, 0x0f, 0xa0, 0xee, 0xd9, 0x3d, 0xf7, 0x16, 0xc4,
	0x39, 0xfc, 0x81, 0x04, 0xeb, 0x67, 0x06, 0x0d, 0x64, 0xf4, 0x89, 0xe5, 0x14, 0xeb, 0x79, 0x55,
	0xaf, 0xa8, 0xa5, 0x7c, 0xa1, 0xb4, 0x1b, 0xf5, 0x19, 0x64, 0x45, 0xe8, 0x47, 0xe4, 0x61, 0x94,
	0xd0, 0xfb, 0xa0, 0x9c, 0x41, 0xc5, 0x4b, 0xe4, 0xd4, 0xe6, 0x6f, 0x49, 0x90, 0xe9, 0x1f, 0x53,
	0x10, 0x67, 0xe3, 0xf9, 0xbb, 0x78, 0x97, 0xb1, 0x01, 0xd7, 0x62, 0x09, 0x7a, 0x48, 0xee, 0xc2,
	0xad, 0x18, 0x0a, 0x6f, 0xe5, 0xac, 0x68, 0xe5, 0x9c, 0x5a, 0xad, 0x92, 0x35, 0x76, 0xf3, 0x07,
	0x12, 0x3d, 0x3d, 0x89, 0x8f, 0x36, 0xd0, 0x7b, 0x90, 0xd1, 0xd4, 0x9d, 0x7a, 0x29, 0xdf, 0x07,
	0x09, 0x85, 0x1a, 0xad, 0xef, 0x01, 0xb9, 0x03, 0x37, 0xa3, 0x04, 0x71, 0x38, 0x7e, 0x57, 0x82,
	0xb5, 0x33, 0x42, 0x10, 0x32, 0x63, 0x34, 0x75, 0x47, 0x53, 0xab, 0x4f, 0xb9, 0x5b, 0x8b, 0x0e,
	0xd2, 0x3d, 0xb8, 0x1d, 0x4b, 0x12, 0x71, 0x88, 0x12, 0x59, 0xbb, 0xfb, 0x48, 0xf3, 0x2d, 0x6e,
	0x53, 0x81, 0xf9, 0x60, 0xbe, 0x12, 0xcd, 0xc0, 0x85, 0xed, 0x62, 0x5d, 0x95, 0x27, 0xc8, 0xaf,
	0x4a, 0xa1, 0xf4, 0x4c, 0x96, 0x36, 0xff, 0x48, 0xe2, 0x97, 0x02, 0x58, 0xc6, 0x15, 0x2d, 0xc3,
	0x42, 0xb5, 0x96, 0xad, 0xd5, 0xab, 0x5e, 0x53, 0x13, 0x81, 0x22, 0x3e, 0xfb, 0xe9, 0xd2, 0xcb,
	0x8b, 0xfc, 0x41, 0xf2, 0x6c, 0x03, 0x5d, 0x84, 0x25, 0xb1, 0x2e, 0x2f, 0x4f, 0x92, 0x25, 0x9e,
	0x17, 0xf2, 0x65, 0xd9, 0xa3, 0xbf, 0x10, 0xa0, 0x67, 0x55, 0x6a, 0x5e, 0x4e, 0x6f, 0x7e, 0x1b,
	0x2e, 0xc5, 0x6d, 0xc7, 0x09, 0x16, 0x36, 0x5b, 0x74, 0x36, 0x28, 0xf2, 0x04, 0x5a, 0x04, 0xe0,
	0x45, 0x2f, 0x0b, 0x64, 0x56, 0x2e, 0xc1, 0x1c, 0xff, 0x2e, 0x96, 0xab, 0xaa, 0x9c, 0xda, 0xfc,
	0x2b, 0x09, 0x96, 0x42, 0x77, 0xc0, 0x08, 0x9e, 0x7a, 0x55, 0xd5, 0x08, 0xc4, 0x9a, 0xe6, 0x8f,
	0x7a, 0x89, 0x74, 0xf7, 0x36, 0xdc, 0x88, 0x54, 0xe5, 0xb2, 0x25, 0xee, 0xd8, 0xb8, 0xa3, 0xa7,
	0x03, 0x10, 0x21, 0x13, 0x9d, 0x64, 0x8a, 0xf8, 0x9e, 0x18, 0x51, 0xb1, 0x1e, 0x75, 0xf2, 0xc1,
	0x3f, 0xdd, 0x82, 0xe5, 0xc8, 0x3b, 0x3f, 0xf4, 0xe7, 0x12, 0xa0, 0xe8, 0x8b, 0x39, 0xb4, 0x9d,
	0xe4, 0x12, 0x44, 0xfc, 0xb3, 0xb7, 0x4c, 0x6e, 0x2c, 0x19, 0xfc, 0x60, 0x6e, 0x02, 0xfd, 0x58,
	0x82, 0xcb, 0xb1, 0x4f, 0xd8, 0x90, 0x3a, 0xfc, 0x65, 0xb2, 0x33, 0x9e, 0xe7, 0x65, 0x76, 0xc6,
	0x15, 0xe3, 0x43, 0xfd, 0x6d, 0x09, 0xe6, 0x02, 0xf1, 0x3f, 0xfa, 0xd6, 0x18, 0x8f, 0xc6, 0x32,
	0x9f, 0x8e, 0xc6, 0x2c, 0x82, 0xe9, 0x85, 0xc3, 0x49, 0xc0, 0x44, 0xde, 0x55, 0x25, 0x01, 0x13,
	0x7d, 0x1c, 0xa5, 0x4c, 0xa0, 0xdf, 0x91, 0x60, 0x3e, 0x18, 0x11, 0xa3, 0x4f, 0x47, 0x4a, 0xb3,
	0x78, 0x70, 0x1e, 0x8f, 0xc8, 0xed, 0xe3, 0xf9, 0x0d, 0x09, 0x66, 0xfd, 0x90, 0x18, 0x7d, 0x92,
	0x3c, 0xe7, 0xe2, 0x21, 0x79, 0x34, 0x0a, 0xab, 0x0f, 0x83, 0xcc, 0xbe, 0xe8, 0xbb, 0x93, 0x04,
	0xb3, 0xaf, 0xef, 0x9b, 0x9b, 0x04, 0xb3, 0xaf, 0xff, 0xc3, 0x17, 0x65, 0x02, 0xfd, 0x48, 0x82,
	0xa5, 0xd0, 0x13, 0x11, 0xf4, 0x24, 0xc9, 0xc4, 0x8e, 0x79, 0x95, 0x92, 0xf9, 0x7c, 0x74, 0x01,
	0x61, 0x60, 0xc1, 0xf7, 0x21, 0xc9, 0x80, 0xc5, 0x3c, 0x49, 0x49, 0x06, 0x2c, 0xee, 0x69, 0x8a,
	0x32, 0x81, 0xfe, 0x5a, 0x82, 0x4b, 0x71, 0xcf, 0x3f, 0x50, 0x3e, 0x89, 0xf0, 0x7e, 0x8f, 0x52,
	0x32, 0xea, 0x98, 0x52, 0x04, 0xbf, 0x1a, 0xfb, 0xd4, 0x22, 0x81, 0x5f, 0x3d, 0xeb, 0xbd, 0x49,
	0x02, 0xbf, 0x7a, 0xe6, 0x8b, 0x8f, 0xde, 0x58, 0x0b, 0x27, 0x3b, 0x89, 0xc6, 0x3a, 0xe6, 0xee,
	0x75, 0xb2, 0xb1, 0x8e, 0xbb, 0xde, 0xac, 0x4c, 0xa0, 0x3f, 0x63, 0xf7, 0x2c, 0x43, 0xa7, 0x2b,
	0xd9, 0xc4, 0x92, 0xc3, 0x0f, 0x31, 0x32, 0xdb, 0xe3, 0x88, 0x10, 0x86, 0x38, 0xf6, 0xcd, 0x02,
	0x4a, 0x64, 0x45, 0x7d, 0x5f, 0x58, 0x64, 0x76, 0xc6, 0x15, 0xe3, 0x43, 0xfd, 0x1b, 0xc9, 0x7f,
	0x37, 0x13, 0xba, 0x6c, 0x87, 0x76, 0x92, 0xea, 0x22, 0xfe, 0x65, 0x45, 0x66, 0x77, 0x6c, 0x39,
	0x3e, 0xda, 0x9f, 0x4a, 0xfe, 0x93, 0x9d, 0xf0, 0xab, 0x02, 0x34, 0x5a, 0x33, 0xd1, 0xb7, 0x13,
	0x99, 0xa7, 0xe3, 0x0b, 0x12, 0x16, 0x9a, 0xe8, 0x45, 0xfd, 0x04, 0x0b, 0x4d, 0xdf, 0x37, 0x0c,
	0x09, 0x16, 0x9a, 0xfe, 0x2f, 0x05, 0x94, 0x09, 0xf4, 0x87, 0x12, 0x2c, 0x8a, 0xf9, 0x21, 0xf4,
	0xd9, 0x88, 0xe7, 0x10, 0x1e, 0xb2, 0x27, 0x23, 0xf3, 0xfb, 0xa8, 0xfe, 0x41, 0x82, 0xb5, 0x33,
	0xd2, 0x00, 0xe8, 0xd9, 0x79, 0x1c, 0x0c, 0x78, 0x78, 0x8b, 0xe7, 0x23, 0x4c, 0x08, 0x72, 0xfc,
	0x9b, 0xdb, 0x09, 0x82, 0x9c, 0xf0, 0x05, 0xf3, 0x04, 0x41, 0x4e, 0xe4, 0xa2, 0x38, 0x1f, 0x59,
	0xf1, 0xaa, 0x74, 0x82, 0x91, 0x8d, 0xbd, 0xe5, 0x9d, 0x79, 0x32, 0xe6, 0x1d, 0x6d, 0xbe, 0x4c,
	0xc7, 0xe5, 0x3d, 0x12, 0x2c, 0xd3, 0x67, 0x5c, 0xa9, 0x4e, 0xb0, 0x4c, 0x9f, 0x75, 0xbb, 0x5a,
	0x99, 0x40, 0x7f, 0x27, 0xd1, 0xb7, 0x75, 0xf1, 0x37, 0x90, 0x51, 0x21, 0xf1, 0xc8, 0xf4, 0xbb,
	0x04, 0x9d, 0xf9, 0xf6, 0x79, 0x88, 0xf2, 0x61, 0xff, 0x8b, 0x04, 0xd7, 0x07, 0x5c, 0x3d, 0x46,
	0xe5, 0xe4, 0x01, 0xc2, 0x99, 0x37, 0xa4, 0x33, 0x95, 0xf3, 0x13, 0x28, 0x2c, 0xf1, 0x91, 0x54,
	0x54, 0x82, 0x25, 0xbe, 0xdf, 0xad, 0xe8, 0xcc, 0xf6, 0x38, 0x22, 0x7c, 0x78, 0x7f, 0x22, 0x81,
	0x1c, 0xce, 0x4e, 0xa1, 0xcf, 0x47, 0x3e, 0x46, 0xf3, 0xc0, 0x65, 0xc7, 0x90, 0x20, 0x2c, 0x3a,
	0xd1, 0x8c, 0x15, 0xda, 0x1e, 0xe3, 0xc4, 0x2d, 0xf9, 0xa2, 0xd3, 0xff, 0x52, 0x32, 0xdf, 0x23,
	0x07, 0xae, 0x03, 0x27, 0xd8, 0x23, 0x47, 0x6f, 0x1d, 0x27, 0xd8, 0x23, 0xc7, 0xdd, 0x40, 0x66,
	0xea, 0x8a, 0xde, 0x26, 0x4e, 0xa0, 0xae, 0xbe, 0x37, 0x98, 0x13, 0xa8, 0xab, 0xff, 0x75, 0x66,
	0x65, 0x62, 0xfb, 0x83, 0x57, 0x9b, 0xc3, 0xff, 0xef, 0x51, 0xfb, 0x53, 0xf4, 0x34, 0xfe, 0x1b,
	0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x56, 0x5c, 0x02, 0x2a, 0x72, 0x4a, 0x00, 0x00,
}
