// Code generated by protoc-gen-twirp v8.1.0, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchPresenceTwirp/twirp.proto

package TwitchPresenceTwirp

import context "context"
import fmt "fmt"
import http "net/http"
import ioutil "io/ioutil"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import bytes "bytes"
import errors "errors"
import io "io"
import path "path"
import url "net/url"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// ==================
// Presence Interface
// ==================

type Presence interface {
	// SendHeartbeat sets your session's status for a short time.
	//
	// The duration the status will stick around for is returned in the response.
	// To stay "alive", you should wait this duration then heartbeat again. Do not
	// hardcode this value into your application, as it varies dynamically.
	//
	// A user's status (as seen by other users) is composed on the backend from
	// this and all other sessions' statuses mixed with their Presence settings.
	// As an individual session, you only need to report your own status.
	//
	// A session is identified by the SessionId parameter. For more information
	// about selecting a SessionId, see the docs on SessionId in SendHeartbeatReq.
	//
	// When displaying UI to the user about their current status
	// ("self-presence"), always display the user status as retrieved from the
	// API/PubSub, never your own session status. This way, users see themselves
	// as other people see them, which is important for user trust of the Presence
	// system (e.g. invisibility).
	//
	// The changing of a user's Presence settings (e.g. away, busy, invisible)
	// should never affect what you report in your heartbeats; the settings are
	// applied on the backend before the user's status becomes visible to other
	// users.
	SendHeartbeat(context.Context, *SendHeartbeatReq) (*SendHeartbeatResp, error)

	// BulkGetUserStatus returns the status for a list of users. A user has
	// exactly one status that indicates the user's availability and activity, if
	// any.
	//
	// NOTE: This status applies the user's presence settings. For example, an
	// online user that is "invisible" will return an offline availability. If
	// your use case requires bypassing settings, use BulkGetSessionStatuses() and
	// set <bypass_user_settings> to true.
	BulkGetUserStatus(context.Context, *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error)

	// BulkGetSessionStatuses returns the sessions for a list of users. A user may
	// have more than one session if they are connected to Twitch via multiple
	// clients.
	BulkGetSessionStatuses(context.Context, *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error)

	// GetStatus returns the user's presence status.
	GetStatus(context.Context, *GetStatusReq) (*GetStatusResp, error)

	// UpdateSettings updates the user's presence settings.
	UpdateSettings(context.Context, *UpdateSettingsReq) (*UpdateSettingsResp, error)

	// GetSettings returns configurable presence behavior settings of a user.
	GetSettings(context.Context, *GetSettingsReq) (*GetSettingsResp, error)

	// GetFriendsStatuses returns the status of all friends per the specified
	// user.
	GetFriendsStatuses(context.Context, *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error)

	// Permanently hard deletes all data belonging to the provided user.
	// Should ONLY be used for GDPR purposes.
	HardDeleteUserData(context.Context, *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error)

	// HandleStreamUp handles when a stream goes online
	HandleStreamUp(context.Context, *HandleStreamUpRequest) (*HandleStreamUpResponse, error)

	// HandleStreamDown handles when a stream goes offline
	HandleStreamDown(context.Context, *HandleStreamDownRequest) (*HandleStreamDownResponse, error)
}

// ========================
// Presence Protobuf Client
// ========================

type presenceProtobufClient struct {
	client      HTTPClient
	urls        [10]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewPresenceProtobufClient creates a Protobuf client that implements the Presence interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewPresenceProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Presence {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "code.justin.tv.chat.presence", "Presence")
	urls := [10]string{
		serviceURL + "SendHeartbeat",
		serviceURL + "BulkGetUserStatus",
		serviceURL + "BulkGetSessionStatuses",
		serviceURL + "GetStatus",
		serviceURL + "UpdateSettings",
		serviceURL + "GetSettings",
		serviceURL + "GetFriendsStatuses",
		serviceURL + "HardDeleteUserData",
		serviceURL + "HandleStreamUp",
		serviceURL + "HandleStreamDown",
	}

	return &presenceProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *presenceProtobufClient) SendHeartbeat(ctx context.Context, in *SendHeartbeatReq) (*SendHeartbeatResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "SendHeartbeat")
	caller := c.callSendHeartbeat
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *SendHeartbeatReq) (*SendHeartbeatResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SendHeartbeatReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SendHeartbeatReq) when calling interceptor")
					}
					return c.callSendHeartbeat(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SendHeartbeatResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SendHeartbeatResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callSendHeartbeat(ctx context.Context, in *SendHeartbeatReq) (*SendHeartbeatResp, error) {
	out := new(SendHeartbeatResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) BulkGetUserStatus(ctx context.Context, in *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetUserStatus")
	caller := c.callBulkGetUserStatus
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetUserStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetUserStatusReq) when calling interceptor")
					}
					return c.callBulkGetUserStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetUserStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetUserStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callBulkGetUserStatus(ctx context.Context, in *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
	out := new(BulkGetUserStatusResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) BulkGetSessionStatuses(ctx context.Context, in *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetSessionStatuses")
	caller := c.callBulkGetSessionStatuses
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetSessionStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetSessionStatusesReq) when calling interceptor")
					}
					return c.callBulkGetSessionStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetSessionStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetSessionStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callBulkGetSessionStatuses(ctx context.Context, in *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
	out := new(BulkGetSessionStatusesResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) GetStatus(ctx context.Context, in *GetStatusReq) (*GetStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "GetStatus")
	caller := c.callGetStatus
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetStatusReq) (*GetStatusResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStatusReq) when calling interceptor")
					}
					return c.callGetStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callGetStatus(ctx context.Context, in *GetStatusReq) (*GetStatusResp, error) {
	out := new(GetStatusResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) UpdateSettings(ctx context.Context, in *UpdateSettingsReq) (*UpdateSettingsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSettings")
	caller := c.callUpdateSettings
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateSettingsReq) (*UpdateSettingsResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSettingsReq) when calling interceptor")
					}
					return c.callUpdateSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callUpdateSettings(ctx context.Context, in *UpdateSettingsReq) (*UpdateSettingsResp, error) {
	out := new(UpdateSettingsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) GetSettings(ctx context.Context, in *GetSettingsReq) (*GetSettingsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "GetSettings")
	caller := c.callGetSettings
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSettingsReq) (*GetSettingsResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSettingsReq) when calling interceptor")
					}
					return c.callGetSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callGetSettings(ctx context.Context, in *GetSettingsReq) (*GetSettingsResp, error) {
	out := new(GetSettingsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) GetFriendsStatuses(ctx context.Context, in *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendsStatuses")
	caller := c.callGetFriendsStatuses
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetFriendsStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetFriendsStatusesReq) when calling interceptor")
					}
					return c.callGetFriendsStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetFriendsStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetFriendsStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callGetFriendsStatuses(ctx context.Context, in *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
	out := new(GetFriendsStatusesResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) HardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	caller := c.callHardDeleteUserData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HardDeleteUserDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HardDeleteUserDataRequest) when calling interceptor")
					}
					return c.callHardDeleteUserData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HardDeleteUserDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HardDeleteUserDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callHardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	out := new(HardDeleteUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) HandleStreamUp(ctx context.Context, in *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamUp")
	caller := c.callHandleStreamUp
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamUpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamUpRequest) when calling interceptor")
					}
					return c.callHandleStreamUp(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamUpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamUpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callHandleStreamUp(ctx context.Context, in *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
	out := new(HandleStreamUpResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceProtobufClient) HandleStreamDown(ctx context.Context, in *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamDown")
	caller := c.callHandleStreamDown
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamDownRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamDownRequest) when calling interceptor")
					}
					return c.callHandleStreamDown(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamDownResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamDownResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceProtobufClient) callHandleStreamDown(ctx context.Context, in *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
	out := new(HandleStreamDownResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================
// Presence JSON Client
// ====================

type presenceJSONClient struct {
	client      HTTPClient
	urls        [10]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewPresenceJSONClient creates a JSON client that implements the Presence interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewPresenceJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Presence {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "code.justin.tv.chat.presence", "Presence")
	urls := [10]string{
		serviceURL + "SendHeartbeat",
		serviceURL + "BulkGetUserStatus",
		serviceURL + "BulkGetSessionStatuses",
		serviceURL + "GetStatus",
		serviceURL + "UpdateSettings",
		serviceURL + "GetSettings",
		serviceURL + "GetFriendsStatuses",
		serviceURL + "HardDeleteUserData",
		serviceURL + "HandleStreamUp",
		serviceURL + "HandleStreamDown",
	}

	return &presenceJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *presenceJSONClient) SendHeartbeat(ctx context.Context, in *SendHeartbeatReq) (*SendHeartbeatResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "SendHeartbeat")
	caller := c.callSendHeartbeat
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *SendHeartbeatReq) (*SendHeartbeatResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SendHeartbeatReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SendHeartbeatReq) when calling interceptor")
					}
					return c.callSendHeartbeat(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SendHeartbeatResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SendHeartbeatResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callSendHeartbeat(ctx context.Context, in *SendHeartbeatReq) (*SendHeartbeatResp, error) {
	out := new(SendHeartbeatResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) BulkGetUserStatus(ctx context.Context, in *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetUserStatus")
	caller := c.callBulkGetUserStatus
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetUserStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetUserStatusReq) when calling interceptor")
					}
					return c.callBulkGetUserStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetUserStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetUserStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callBulkGetUserStatus(ctx context.Context, in *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
	out := new(BulkGetUserStatusResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) BulkGetSessionStatuses(ctx context.Context, in *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetSessionStatuses")
	caller := c.callBulkGetSessionStatuses
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetSessionStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetSessionStatusesReq) when calling interceptor")
					}
					return c.callBulkGetSessionStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetSessionStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetSessionStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callBulkGetSessionStatuses(ctx context.Context, in *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
	out := new(BulkGetSessionStatusesResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) GetStatus(ctx context.Context, in *GetStatusReq) (*GetStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "GetStatus")
	caller := c.callGetStatus
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetStatusReq) (*GetStatusResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStatusReq) when calling interceptor")
					}
					return c.callGetStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callGetStatus(ctx context.Context, in *GetStatusReq) (*GetStatusResp, error) {
	out := new(GetStatusResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) UpdateSettings(ctx context.Context, in *UpdateSettingsReq) (*UpdateSettingsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSettings")
	caller := c.callUpdateSettings
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateSettingsReq) (*UpdateSettingsResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSettingsReq) when calling interceptor")
					}
					return c.callUpdateSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callUpdateSettings(ctx context.Context, in *UpdateSettingsReq) (*UpdateSettingsResp, error) {
	out := new(UpdateSettingsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) GetSettings(ctx context.Context, in *GetSettingsReq) (*GetSettingsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "GetSettings")
	caller := c.callGetSettings
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSettingsReq) (*GetSettingsResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSettingsReq) when calling interceptor")
					}
					return c.callGetSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callGetSettings(ctx context.Context, in *GetSettingsReq) (*GetSettingsResp, error) {
	out := new(GetSettingsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) GetFriendsStatuses(ctx context.Context, in *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendsStatuses")
	caller := c.callGetFriendsStatuses
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetFriendsStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetFriendsStatusesReq) when calling interceptor")
					}
					return c.callGetFriendsStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetFriendsStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetFriendsStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callGetFriendsStatuses(ctx context.Context, in *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
	out := new(GetFriendsStatusesResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) HardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	caller := c.callHardDeleteUserData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HardDeleteUserDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HardDeleteUserDataRequest) when calling interceptor")
					}
					return c.callHardDeleteUserData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HardDeleteUserDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HardDeleteUserDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callHardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	out := new(HardDeleteUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) HandleStreamUp(ctx context.Context, in *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamUp")
	caller := c.callHandleStreamUp
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamUpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamUpRequest) when calling interceptor")
					}
					return c.callHandleStreamUp(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamUpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamUpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callHandleStreamUp(ctx context.Context, in *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
	out := new(HandleStreamUpResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *presenceJSONClient) HandleStreamDown(ctx context.Context, in *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamDown")
	caller := c.callHandleStreamDown
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamDownRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamDownRequest) when calling interceptor")
					}
					return c.callHandleStreamDown(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamDownResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamDownResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *presenceJSONClient) callHandleStreamDown(ctx context.Context, in *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
	out := new(HandleStreamDownResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// Presence Server Handler
// =======================

type presenceServer struct {
	Presence
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewPresenceServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewPresenceServer(svc Presence, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &presenceServer{
		Presence:         svc,
		hooks:            serverOpts.Hooks,
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:       pathPrefix,
		jsonSkipDefaults: jsonSkipDefaults,
		jsonCamelCase:    jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *presenceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *presenceServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// PresencePathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const PresencePathPrefix = "/twirp/code.justin.tv.chat.presence.Presence/"

func (s *presenceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.presence")
	ctx = ctxsetters.WithServiceName(ctx, "Presence")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "code.justin.tv.chat.presence.Presence" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "SendHeartbeat":
		s.serveSendHeartbeat(ctx, resp, req)
		return
	case "BulkGetUserStatus":
		s.serveBulkGetUserStatus(ctx, resp, req)
		return
	case "BulkGetSessionStatuses":
		s.serveBulkGetSessionStatuses(ctx, resp, req)
		return
	case "GetStatus":
		s.serveGetStatus(ctx, resp, req)
		return
	case "UpdateSettings":
		s.serveUpdateSettings(ctx, resp, req)
		return
	case "GetSettings":
		s.serveGetSettings(ctx, resp, req)
		return
	case "GetFriendsStatuses":
		s.serveGetFriendsStatuses(ctx, resp, req)
		return
	case "HardDeleteUserData":
		s.serveHardDeleteUserData(ctx, resp, req)
		return
	case "HandleStreamUp":
		s.serveHandleStreamUp(ctx, resp, req)
		return
	case "HandleStreamDown":
		s.serveHandleStreamDown(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *presenceServer) serveSendHeartbeat(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendHeartbeatJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendHeartbeatProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveSendHeartbeatJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendHeartbeat")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(SendHeartbeatReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.SendHeartbeat
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *SendHeartbeatReq) (*SendHeartbeatResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SendHeartbeatReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SendHeartbeatReq) when calling interceptor")
					}
					return s.Presence.SendHeartbeat(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SendHeartbeatResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SendHeartbeatResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SendHeartbeatResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendHeartbeatResp and nil error while calling SendHeartbeat. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveSendHeartbeatProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendHeartbeat")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(SendHeartbeatReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.SendHeartbeat
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *SendHeartbeatReq) (*SendHeartbeatResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*SendHeartbeatReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*SendHeartbeatReq) when calling interceptor")
					}
					return s.Presence.SendHeartbeat(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SendHeartbeatResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SendHeartbeatResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SendHeartbeatResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendHeartbeatResp and nil error while calling SendHeartbeat. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveBulkGetUserStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkGetUserStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkGetUserStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveBulkGetUserStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetUserStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(BulkGetUserStatusReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.BulkGetUserStatus
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetUserStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetUserStatusReq) when calling interceptor")
					}
					return s.Presence.BulkGetUserStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetUserStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetUserStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *BulkGetUserStatusResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetUserStatusResp and nil error while calling BulkGetUserStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveBulkGetUserStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetUserStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(BulkGetUserStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.BulkGetUserStatus
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *BulkGetUserStatusReq) (*BulkGetUserStatusResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetUserStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetUserStatusReq) when calling interceptor")
					}
					return s.Presence.BulkGetUserStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetUserStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetUserStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *BulkGetUserStatusResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetUserStatusResp and nil error while calling BulkGetUserStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveBulkGetSessionStatuses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkGetSessionStatusesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkGetSessionStatusesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveBulkGetSessionStatusesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetSessionStatuses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(BulkGetSessionStatusesReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.BulkGetSessionStatuses
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetSessionStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetSessionStatusesReq) when calling interceptor")
					}
					return s.Presence.BulkGetSessionStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetSessionStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetSessionStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *BulkGetSessionStatusesResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetSessionStatusesResp and nil error while calling BulkGetSessionStatuses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveBulkGetSessionStatusesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetSessionStatuses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(BulkGetSessionStatusesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.BulkGetSessionStatuses
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *BulkGetSessionStatusesReq) (*BulkGetSessionStatusesResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*BulkGetSessionStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*BulkGetSessionStatusesReq) when calling interceptor")
					}
					return s.Presence.BulkGetSessionStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*BulkGetSessionStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*BulkGetSessionStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *BulkGetSessionStatusesResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetSessionStatusesResp and nil error while calling BulkGetSessionStatuses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveGetStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveGetStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetStatusReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.GetStatus
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetStatusReq) (*GetStatusResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStatusReq) when calling interceptor")
					}
					return s.Presence.GetStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetStatusResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStatusResp and nil error while calling GetStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveGetStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.GetStatus
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetStatusReq) (*GetStatusResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStatusReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStatusReq) when calling interceptor")
					}
					return s.Presence.GetStatus(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStatusResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStatusResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetStatusResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStatusResp and nil error while calling GetStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveUpdateSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveUpdateSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateSettingsReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.UpdateSettings
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateSettingsReq) (*UpdateSettingsResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSettingsReq) when calling interceptor")
					}
					return s.Presence.UpdateSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpdateSettingsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSettingsResp and nil error while calling UpdateSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveUpdateSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateSettingsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.UpdateSettings
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateSettingsReq) (*UpdateSettingsResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateSettingsReq) when calling interceptor")
					}
					return s.Presence.UpdateSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpdateSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpdateSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpdateSettingsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSettingsResp and nil error while calling UpdateSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveGetSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveGetSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetSettingsReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.GetSettings
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSettingsReq) (*GetSettingsResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSettingsReq) when calling interceptor")
					}
					return s.Presence.GetSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSettingsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSettingsResp and nil error while calling GetSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveGetSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetSettingsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.GetSettings
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSettingsReq) (*GetSettingsResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSettingsReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSettingsReq) when calling interceptor")
					}
					return s.Presence.GetSettings(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSettingsResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSettingsResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSettingsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSettingsResp and nil error while calling GetSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveGetFriendsStatuses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFriendsStatusesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFriendsStatusesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveGetFriendsStatusesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendsStatuses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetFriendsStatusesReq)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.GetFriendsStatuses
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetFriendsStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetFriendsStatusesReq) when calling interceptor")
					}
					return s.Presence.GetFriendsStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetFriendsStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetFriendsStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetFriendsStatusesResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFriendsStatusesResp and nil error while calling GetFriendsStatuses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveGetFriendsStatusesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendsStatuses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetFriendsStatusesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.GetFriendsStatuses
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetFriendsStatusesReq) (*GetFriendsStatusesResp, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetFriendsStatusesReq)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetFriendsStatusesReq) when calling interceptor")
					}
					return s.Presence.GetFriendsStatuses(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetFriendsStatusesResp)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetFriendsStatusesResp) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetFriendsStatusesResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFriendsStatusesResp and nil error while calling GetFriendsStatuses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveHardDeleteUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHardDeleteUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHardDeleteUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveHardDeleteUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(HardDeleteUserDataRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.HardDeleteUserData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HardDeleteUserDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HardDeleteUserDataRequest) when calling interceptor")
					}
					return s.Presence.HardDeleteUserData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HardDeleteUserDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HardDeleteUserDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *HardDeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteUserDataResponse and nil error while calling HardDeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveHardDeleteUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(HardDeleteUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.HardDeleteUserData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HardDeleteUserDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HardDeleteUserDataRequest) when calling interceptor")
					}
					return s.Presence.HardDeleteUserData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HardDeleteUserDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HardDeleteUserDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *HardDeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteUserDataResponse and nil error while calling HardDeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveHandleStreamUp(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHandleStreamUpJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHandleStreamUpProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveHandleStreamUpJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamUp")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(HandleStreamUpRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.HandleStreamUp
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamUpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamUpRequest) when calling interceptor")
					}
					return s.Presence.HandleStreamUp(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamUpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamUpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *HandleStreamUpResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HandleStreamUpResponse and nil error while calling HandleStreamUp. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveHandleStreamUpProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamUp")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(HandleStreamUpRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.HandleStreamUp
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *HandleStreamUpRequest) (*HandleStreamUpResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamUpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamUpRequest) when calling interceptor")
					}
					return s.Presence.HandleStreamUp(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamUpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamUpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *HandleStreamUpResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HandleStreamUpResponse and nil error while calling HandleStreamUp. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveHandleStreamDown(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHandleStreamDownJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHandleStreamDownProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *presenceServer) serveHandleStreamDownJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamDown")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(HandleStreamDownRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Presence.HandleStreamDown
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamDownRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamDownRequest) when calling interceptor")
					}
					return s.Presence.HandleStreamDown(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamDownResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamDownResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *HandleStreamDownResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HandleStreamDownResponse and nil error while calling HandleStreamDown. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) serveHandleStreamDownProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleStreamDown")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(HandleStreamDownRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Presence.HandleStreamDown
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *HandleStreamDownRequest) (*HandleStreamDownResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*HandleStreamDownRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*HandleStreamDownRequest) when calling interceptor")
					}
					return s.Presence.HandleStreamDown(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*HandleStreamDownResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*HandleStreamDownResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *HandleStreamDownResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HandleStreamDownResponse and nil error while calling HandleStreamDown. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *presenceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *presenceServer) ProtocGenTwirpVersion() string {
	return "v8.1.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *presenceServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "code.justin.tv.chat.presence", "Presence")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

func newServerOpts(opts []interface{}) *twirp.ServerOptions {
	serverOpts := &twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T, please use a twirp.ServerOption", o))
		}
	}
	return serverOpts
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Convert to a twirp.Error. Non-twirp errors are converted to internal errors.
	var twerr twirp.Error
	if !errors.As(err, &twerr) {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.1.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1547 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x58, 0xdd, 0x4e, 0x1b, 0xc7,
	0x17, 0xcf, 0xe2, 0xf0, 0xe1, 0x63, 0xc0, 0xcb, 0x04, 0x08, 0xec, 0x3f, 0xc9, 0x9f, 0xac, 0x54,
	0x85, 0x90, 0xc4, 0x44, 0x26, 0x6d, 0xd2, 0x5e, 0x54, 0xb1, 0x8b, 0x13, 0x2c, 0x51, 0x88, 0xd6,
	0x40, 0x4a, 0xaa, 0xca, 0x1a, 0x7b, 0x27, 0xb0, 0x89, 0xd9, 0x5d, 0x76, 0xc6, 0x38, 0x6e, 0x2a,
	0x35, 0xbd, 0x6a, 0xa5, 0xf6, 0x05, 0x7a, 0x59, 0xa9, 0xea, 0x0b, 0xf5, 0xb2, 0xea, 0x6b, 0xe4,
	0xba, 0xda, 0x99, 0x5d, 0x33, 0x5e, 0xaf, 0xbd, 0x98, 0x26, 0x55, 0x2f, 0x7a, 0x83, 0xd8, 0xf3,
	0x39, 0xe7, 0x63, 0xce, 0x9c, 0x9f, 0x61, 0xad, 0xee, 0x98, 0x24, 0xf7, 0xa2, 0x49, 0x99, 0x65,
	0xe7, 0xd8, 0xc9, 0x2a, 0x3e, 0xfa, 0xda, 0x5e, 0xdd, 0x69, 0x59, 0xac, 0x7e, 0xf8, 0xc4, 0x23,
	0x94, 0xd8, 0x75, 0xb2, 0xd3, 0xb2, 0x3c, 0x77, 0x95, 0xf9, 0x7f, 0x73, 0xae, 0xe7, 0x30, 0x07,
	0x5d, 0xe9, 0x56, 0xca, 0xd5, 0x0f, 0x31, 0xcb, 0xb9, 0x81, 0xb8, 0x76, 0xed, 0xc0, 0x71, 0x0e,
	0x1a, 0x64, 0x95, 0xcb, 0xd6, 0x9a, 0xcf, 0x57, 0xcd, 0xa6, 0x87, 0x99, 0xe5, 0xd8, 0x42, 0x5b,
	0xfb, 0x7f, 0x94, 0xcf, 0xac, 0x23, 0x42, 0x19, 0x3e, 0x0a, 0xcc, 0xf7, 0x1a, 0x68, 0x79, 0xd8,
	0x75, 0x89, 0x47, 0x05, 0x5f, 0x7f, 0x9b, 0x02, 0xb5, 0x42, 0x6c, 0x73, 0x83, 0x60, 0x8f, 0xd5,
	0x08, 0x66, 0x06, 0x39, 0x46, 0x97, 0x61, 0xbc, 0x49, 0x89, 0x57, 0xb5, 0xcc, 0x85, 0xb1, 0x25,
	0x65, 0x39, 0x6d, 0x8c, 0xf9, 0x9f, 0x65, 0x13, 0x5d, 0x05, 0xa0, 0x84, 0x52, 0xcb, 0xb1, 0x7d,
	0x9e, 0xc2, 0x79, 0xe9, 0x80, 0x52, 0x36, 0xd1, 0xff, 0x20, 0x5d, 0x6f, 0x58, 0xc4, 0x66, 0x3e,
	0x77, 0x82, 0x73, 0x27, 0x04, 0xa1, 0x6c, 0xa2, 0x2f, 0x61, 0x12, 0x9f, 0x60, 0xab, 0x81, 0x6b,
	0x56, 0xc3, 0x62, 0xed, 0x85, 0x91, 0x25, 0x65, 0x79, 0x3a, 0x7f, 0x3f, 0x37, 0x28, 0xfe, 0x5c,
	0x45, 0xd8, 0xae, 0x30, 0xcc, 0x9a, 0xb4, 0x20, 0xa9, 0x1b, 0x5d, 0xc6, 0xd0, 0x57, 0x30, 0xd3,
	0xc2, 0xac, 0x7e, 0x68, 0xd9, 0x07, 0x55, 0x5c, 0x67, 0xd6, 0x89, 0xef, 0x21, 0xb5, 0xa4, 0x2c,
	0x67, 0xf2, 0xb9, 0xc1, 0x1e, 0x9e, 0x06, 0x6a, 0x85, 0x40, 0x6b, 0xe3, 0x82, 0xa1, 0xb6, 0x22,
	0x34, 0x64, 0xc1, 0x5c, 0xcd, 0x73, 0xb0, 0x59, 0xc7, 0xbe, 0x11, 0xc9, 0xc5, 0x45, 0xee, 0x22,
	0x3f, 0xd8, 0x45, 0x51, 0x52, 0x95, 0xdc, 0xcc, 0xd6, 0x62, 0xe8, 0xe8, 0x19, 0xa8, 0x6e, 0x03,
	0xb7, 0xbb, 0xbc, 0x8c, 0x72, 0x2f, 0x77, 0x06, 0x7b, 0x79, 0x22, 0xb4, 0x24, 0x07, 0x59, 0xb7,
	0x9b, 0x54, 0x04, 0x98, 0x08, 0x6d, 0xea, 0x0f, 0x61, 0x26, 0x52, 0x77, 0xea, 0xa2, 0x5b, 0x90,
	0xda, 0xd9, 0xd9, 0xe4, 0x85, 0xcd, 0xe4, 0x17, 0x73, 0xa2, 0x77, 0x72, 0x61, 0xef, 0xe4, 0xd6,
	0x83, 0xe6, 0x33, 0x7c, 0x29, 0xbd, 0x0a, 0xb3, 0xc5, 0x66, 0xe3, 0xe5, 0x63, 0xc2, 0x76, 0x29,
	0xf1, 0x44, 0x89, 0xfc, 0xee, 0x59, 0x84, 0x89, 0xa0, 0x7b, 0xe8, 0x82, 0xb2, 0x94, 0x5a, 0x4e,
	0x1b, 0xe3, 0xa2, 0x7d, 0x28, 0xba, 0x0d, 0xc8, 0x23, 0xc7, 0x4d, 0x22, 0xb2, 0x18, 0xf6, 0xd8,
	0x08, 0xef, 0x14, 0xf5, 0x94, 0xb3, 0xcb, 0xc5, 0xf5, 0x37, 0x23, 0x30, 0x17, 0xe3, 0x81, 0xba,
	0xe8, 0x15, 0x5c, 0xe2, 0xca, 0x94, 0x93, 0xaa, 0xb5, 0x36, 0xb7, 0xc5, 0xbd, 0x65, 0xf2, 0xe5,
	0x84, 0x6a, 0xc4, 0x59, 0xcc, 0x9d, 0x7e, 0x16, 0xdb, 0xfe, 0xff, 0x25, 0x9b, 0x79, 0x6d, 0x43,
	0x6d, 0x46, 0xc8, 0xda, 0x11, 0xcc, 0xc5, 0x8a, 0x22, 0x15, 0x52, 0x2f, 0x49, 0x3b, 0xb8, 0x13,
	0xfe, 0xbf, 0xe8, 0x53, 0x18, 0x3d, 0xc1, 0x8d, 0x26, 0xe1, 0xf1, 0x65, 0xf2, 0xcb, 0x83, 0x8f,
	0x25, 0x9d, 0x47, 0xa8, 0x7d, 0x32, 0xf2, 0x40, 0xd1, 0x0f, 0x61, 0x31, 0x38, 0x6f, 0xd7, 0x4d,
	0x20, 0x49, 0x89, 0xbe, 0x0b, 0xb3, 0xb5, 0xb6, 0x8b, 0x29, 0x15, 0x49, 0xa6, 0x84, 0xf9, 0x79,
	0xa5, 0xfc, 0x28, 0x13, 0x06, 0x12, 0x3c, 0xee, 0x32, 0xe0, 0xe8, 0xbf, 0x8d, 0x80, 0xd6, 0xcf,
	0x15, 0x75, 0xd1, 0x4f, 0x0a, 0x2c, 0x84, 0x57, 0x9f, 0x06, 0x8c, 0x48, 0xde, 0x2b, 0x67, 0xca,
	0x7b, 0x8c, 0xf1, 0x5c, 0x84, 0x26, 0x57, 0x60, 0x8e, 0xc6, 0xf1, 0xb4, 0x36, 0x68, 0xfd, 0x95,
	0x62, 0x6a, 0x51, 0xea, 0xae, 0xc5, 0xea, 0x10, 0x53, 0x67, 0xd3, 0xa2, 0x4c, 0x2e, 0xc9, 0x0d,
	0x98, 0xf4, 0xc3, 0xe8, 0xb4, 0xbb, 0x34, 0x2c, 0x15, 0x79, 0x58, 0xea, 0x6f, 0x14, 0x98, 0x92,
	0x24, 0xa9, 0xdb, 0x57, 0x14, 0xcd, 0xc2, 0xa8, 0x65, 0x9b, 0xe4, 0x15, 0x3f, 0x5e, 0xca, 0x10,
	0x1f, 0xe8, 0x21, 0x8c, 0x89, 0x54, 0x07, 0x93, 0xec, 0xec, 0x1d, 0x14, 0xe8, 0xe9, 0x7f, 0x2a,
	0x30, 0xb3, 0xeb, 0x9a, 0x98, 0x91, 0xb0, 0xce, 0x83, 0x4e, 0x8c, 0x1a, 0x30, 0x27, 0x4f, 0xd5,
	0xaa, 0x73, 0x42, 0x3c, 0xcf, 0x32, 0xc3, 0xac, 0x25, 0xcc, 0x6a, 0x79, 0x3c, 0x6f, 0x07, 0x9a,
	0x7b, 0x7e, 0xda, 0x8c, 0x59, 0x1c, 0xc3, 0x42, 0x05, 0x98, 0xa6, 0x87, 0xd8, 0x23, 0xd1, 0x81,
	0xad, 0xf5, 0xcc, 0x9d, 0xa2, 0xe3, 0x34, 0x84, 0xa5, 0x29, 0xae, 0x11, 0x0e, 0x34, 0xfd, 0x57,
	0x05, 0x50, 0x34, 0x3e, 0xea, 0xa2, 0x83, 0x7e, 0x71, 0x28, 0xfc, 0xcd, 0xc9, 0x0f, 0x1f, 0x47,
	0x9f, 0x10, 0x3e, 0xe8, 0x09, 0x41, 0x5c, 0xb0, 0xc8, 0x31, 0x6f, 0xc2, 0x34, 0xef, 0xfc, 0xe4,
	0x12, 0xe8, 0xbf, 0x28, 0x90, 0xed, 0x92, 0xfd, 0x17, 0x86, 0x73, 0x17, 0xe6, 0x1e, 0x13, 0xf6,
	0xc8, 0xb3, 0x88, 0x6d, 0x52, 0x79, 0x20, 0xf5, 0x8d, 0xea, 0x08, 0xe6, 0xe3, 0x34, 0xa8, 0x8b,
	0x2a, 0x90, 0x7d, 0xce, 0xc9, 0x9d, 0xa9, 0x12, 0x4c, 0x93, 0x95, 0xc1, 0x51, 0x09, 0x5b, 0x41,
	0xbb, 0x4f, 0x3f, 0x97, 0xbe, 0x08, 0xd5, 0x3f, 0x87, 0xc5, 0x0d, 0xec, 0x99, 0xeb, 0xa4, 0x41,
	0x18, 0xf1, 0xaf, 0xc5, 0x3a, 0x66, 0xd8, 0x10, 0xcf, 0x4b, 0xff, 0xee, 0xbf, 0x0c, 0xe3, 0x16,
	0xad, 0xda, 0x8e, 0xe3, 0x06, 0x61, 0x8f, 0x59, 0x74, 0xcb, 0x71, 0x5c, 0xbf, 0xcb, 0xb4, 0x38,
	0x7b, 0xd4, 0x75, 0x6c, 0x4a, 0xd0, 0x75, 0x98, 0xf4, 0x9c, 0x16, 0xad, 0x9a, 0x9c, 0x2d, 0xac,
	0xa6, 0x8c, 0x8c, 0x4f, 0x13, 0x1a, 0x26, 0x7a, 0x00, 0x0b, 0xd8, 0xb6, 0x9d, 0xa6, 0x5d, 0x27,
	0x61, 0xa0, 0x1d, 0x71, 0x71, 0xe5, 0xe7, 0x3b, 0x7c, 0x11, 0x45, 0xa8, 0x79, 0x13, 0xd4, 0x70,
	0x78, 0x77, 0x34, 0x52, 0x5c, 0x23, 0x1b, 0xd2, 0x03, 0x51, 0xbd, 0x01, 0x73, 0x1b, 0xd8, 0x36,
	0x1b, 0xa4, 0xc2, 0x3c, 0x82, 0x8f, 0x76, 0xdd, 0xc4, 0x88, 0xaf, 0xc3, 0x64, 0x67, 0x07, 0x39,
	0x7d, 0x88, 0x33, 0x1d, 0x9a, 0x48, 0xca, 0x01, 0x3e, 0x22, 0x3e, 0x37, 0x25, 0x74, 0xfd, 0xcf,
	0xb2, 0xa9, 0x2f, 0xc0, 0x7c, 0xd4, 0x9b, 0xc8, 0x87, 0xbe, 0x0b, 0x97, 0x65, 0xce, 0xba, 0xd3,
	0xb2, 0xdf, 0xc1, 0x49, 0x74, 0x0d, 0x16, 0x7a, 0xcd, 0x06, 0x2e, 0x7f, 0x50, 0x60, 0x52, 0xee,
	0x88, 0x61, 0x27, 0x6d, 0x19, 0x32, 0xd2, 0x3e, 0x31, 0xf4, 0xb8, 0x85, 0xd3, 0x35, 0x41, 0xff,
	0x3d, 0x05, 0x70, 0xca, 0x42, 0x5f, 0x44, 0xb6, 0x5e, 0x71, 0x65, 0xef, 0x9d, 0xd5, 0xf4, 0x80,
	0x95, 0xf7, 0x63, 0x80, 0x26, 0x1f, 0x7d, 0x66, 0x15, 0xb3, 0x60, 0x42, 0xf7, 0x8e, 0xce, 0x9d,
	0x10, 0x0f, 0x18, 0xe9, 0x40, 0xba, 0xc0, 0xe2, 0xb7, 0xe5, 0xd1, 0xf7, 0xbf, 0x2d, 0x8f, 0xfd,
	0x23, 0xdb, 0xf2, 0xf8, 0x7b, 0xd8, 0x96, 0xdf, 0xa6, 0x60, 0xaa, 0x6b, 0x2b, 0xe8, 0x81, 0x33,
	0xca, 0xbb, 0x84, 0x33, 0x7f, 0xa3, 0xb6, 0x5d, 0x18, 0x2c, 0x15, 0xc1, 0x60, 0xff, 0x15, 0x7e,
	0xd8, 0xc2, 0xbf, 0xf4, 0x61, 0x52, 0x64, 0x1b, 0x44, 0x7b, 0xfe, 0x50, 0xee, 0xde, 0x85, 0x83,
	0x57, 0xeb, 0xd6, 0x10, 0xf5, 0xf7, 0x27, 0x78, 0xd7, 0x0a, 0xab, 0x13, 0x58, 0xec, 0xbb, 0x44,
	0xa1, 0x8d, 0x70, 0x85, 0x3d, 0xff, 0xab, 0x2f, 0x0c, 0xe8, 0xaf, 0x41, 0x8d, 0x96, 0xd3, 0x47,
	0xf6, 0xf5, 0x43, 0x6c, 0xdb, 0xa4, 0x21, 0x21, 0xfb, 0x80, 0x52, 0x36, 0xd1, 0x06, 0xcc, 0x1c,
	0x3a, 0xd4, 0xef, 0x47, 0x49, 0x4a, 0xf4, 0xe5, 0x95, 0x9e, 0xbe, 0xac, 0x30, 0xcf, 0xb2, 0x0f,
	0xc4, 0xc2, 0x96, 0x15, 0x6a, 0x9f, 0x85, 0x96, 0xf4, 0x79, 0x98, 0x8d, 0x2b, 0xb4, 0xbe, 0x02,
	0xd9, 0x48, 0x69, 0xe4, 0xb7, 0x47, 0x91, 0xdf, 0x9e, 0x95, 0x7d, 0x98, 0x8f, 0x1f, 0x91, 0x48,
	0x85, 0xc9, 0xdd, 0x4a, 0xc9, 0xa8, 0x6e, 0x3f, 0x7a, 0xb4, 0x59, 0xde, 0x2a, 0xa9, 0x17, 0x50,
	0x16, 0x32, 0x82, 0xb2, 0xc5, 0x09, 0x0a, 0x9a, 0x82, 0x34, 0x27, 0x14, 0x77, 0x2b, 0xfb, 0x6a,
	0xaa, 0xf3, 0x59, 0x78, 0x5a, 0xd8, 0x57, 0x2f, 0xae, 0xec, 0xc1, 0x62, 0xdf, 0x4b, 0x8a, 0x2e,
	0x41, 0xb6, 0x52, 0xaa, 0x54, 0xca, 0xdb, 0x5b, 0x92, 0x03, 0x04, 0xd3, 0x1d, 0x62, 0xe8, 0x43,
	0x85, 0xc9, 0x90, 0x56, 0x5e, 0xdf, 0x2c, 0xa9, 0x23, 0x2b, 0x3f, 0x2b, 0x30, 0x1b, 0x57, 0x13,
	0x74, 0x0d, 0xb4, 0xc2, 0x5e, 0xa1, 0xbc, 0x59, 0x28, 0x96, 0x37, 0xcb, 0x3b, 0xfb, 0xd5, 0xed,
	0xbd, 0x92, 0x61, 0x94, 0xd7, 0x4b, 0xd5, 0xad, 0x6d, 0x6e, 0xbe, 0x2f, 0x9f, 0x1f, 0x58, 0xe9,
	0xcf, 0xe7, 0xf1, 0x8d, 0xa0, 0xeb, 0x70, 0x35, 0x9e, 0x1f, 0x46, 0x90, 0xca, 0xff, 0x91, 0x86,
	0x89, 0xf0, 0x07, 0x2a, 0xe4, 0xfa, 0x83, 0x4e, 0xfa, 0x5d, 0x00, 0xe5, 0x92, 0x5a, 0xba, 0xfb,
	0xc7, 0x23, 0x6d, 0x75, 0x28, 0x79, 0xea, 0xa2, 0x6f, 0x60, 0xa6, 0x07, 0x93, 0xa3, 0xfc, 0xd0,
	0x20, 0xfe, 0x58, 0x5b, 0x3b, 0x07, 0xf0, 0x47, 0x3f, 0x2a, 0x30, 0x1f, 0x0f, 0x4d, 0xd1, 0xfd,
	0xf3, 0x01, 0xda, 0x63, 0xed, 0xc1, 0x79, 0x91, 0x30, 0x32, 0x21, 0xdd, 0x81, 0x8c, 0x28, 0x61,
	0x05, 0x96, 0x51, 0xa8, 0x76, 0xeb, 0xcc, 0xb2, 0xd4, 0x45, 0x14, 0xa6, 0xbb, 0x51, 0x13, 0x4a,
	0x28, 0x5a, 0x0f, 0x86, 0xd4, 0xee, 0x0e, 0xa7, 0x40, 0x5d, 0xf4, 0x02, 0x32, 0x12, 0xb0, 0x41,
	0xb7, 0x93, 0x0f, 0x2c, 0xb9, 0xbb, 0x33, 0x84, 0x34, 0x75, 0xd1, 0xb7, 0x80, 0x7a, 0xf1, 0x06,
	0x5a, 0x4b, 0x34, 0xd2, 0x8b, 0x69, 0xb4, 0x7b, 0xc3, 0x2b, 0x51, 0x17, 0x7d, 0xaf, 0x00, 0xea,
	0x85, 0x0c, 0x49, 0x1d, 0xd5, 0x17, 0xb4, 0x24, 0x75, 0xd4, 0x00, 0x74, 0xf2, 0x1a, 0xa6, 0xbb,
	0xf7, 0xf4, 0xa4, 0x34, 0xc4, 0x62, 0x88, 0xa4, 0x34, 0xc4, 0x43, 0x01, 0xf4, 0x9d, 0x02, 0x6a,
	0x74, 0x69, 0x47, 0x1f, 0x9e, 0xdd, 0x94, 0x84, 0x1d, 0xb4, 0x8f, 0x86, 0x55, 0x13, 0x67, 0x28,
	0xde, 0x7c, 0x76, 0xe3, 0x8c, 0xbf, 0xcb, 0xd7, 0xc6, 0xf8, 0x13, 0xb6, 0xf6, 0x57, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x29, 0xc6, 0xcc, 0x5b, 0xc9, 0x17, 0x00, 0x00,
}
