// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchProductCatalogTwirp/twirp.proto

/*
Package TwitchProductCatalogTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchProductCatalogTwirp/twirp.proto
*/
package TwitchProductCatalogTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ==============================
// TwitchProductCatalog Interface
// ==============================

type TwitchProductCatalog interface {
	// Basic Product Catalog CRUD APIs
	GetProductsByIDs(context.Context, *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error)

	GetProductsByOwnerID(context.Context, *GetProductsByOwnerIDRequest) (*GetProductsByOwnerIDResponse, error)

	CreateProducts(context.Context, *CreateProductsRequest) (*CreateProductsResponse, error)

	UpsertBenefits(context.Context, *UpsertBenefitsRequest) (*UpsertBenefitsResponse, error)

	GetProductsByBenefits(context.Context, *GetProductsByBenefitsRequest) (*GetProductsByBenefitsResponse, error)

	UpdateProductByID(context.Context, *UpdateProductByIDRequest) (*UpdateProductByIDResponse, error)

	DeleteProductsByOwnerID(context.Context, *DeleteProductsByOwnerIDRequest) (*DeleteProductsByOwnerIDResponse, error)

	DeleteProductByID(context.Context, *DeleteProductByIDRequest) (*DeleteProductByIDResponse, error)

	// Subscription Facet APIs
	GetProductsByShortNames(context.Context, *GetProductsByShortNamesRequest) (*GetProductsByShortNamesResponse, error)
}

// ====================================
// TwitchProductCatalog Protobuf Client
// ====================================

type twitchProductCatalogProtobufClient struct {
	client HTTPClient
	urls   [9]string
	opts   twirp.ClientOptions
}

// NewTwitchProductCatalogProtobufClient creates a Protobuf client that implements the TwitchProductCatalog interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchProductCatalogProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchProductCatalog {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchProductCatalogPathPrefix
	urls := [9]string{
		prefix + "GetProductsByIDs",
		prefix + "GetProductsByOwnerID",
		prefix + "CreateProducts",
		prefix + "UpsertBenefits",
		prefix + "GetProductsByBenefits",
		prefix + "UpdateProductByID",
		prefix + "DeleteProductsByOwnerID",
		prefix + "DeleteProductByID",
		prefix + "GetProductsByShortNames",
	}

	return &twitchProductCatalogProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchProductCatalogProtobufClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByIDs")
	out := new(GetProductsByIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) GetProductsByOwnerID(ctx context.Context, in *GetProductsByOwnerIDRequest) (*GetProductsByOwnerIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByOwnerID")
	out := new(GetProductsByOwnerIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) CreateProducts(ctx context.Context, in *CreateProductsRequest) (*CreateProductsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducts")
	out := new(CreateProductsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) UpsertBenefits(ctx context.Context, in *UpsertBenefitsRequest) (*UpsertBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "UpsertBenefits")
	out := new(UpsertBenefitsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) GetProductsByBenefits(ctx context.Context, in *GetProductsByBenefitsRequest) (*GetProductsByBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByBenefits")
	out := new(GetProductsByBenefitsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) UpdateProductByID(ctx context.Context, in *UpdateProductByIDRequest) (*UpdateProductByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProductByID")
	out := new(UpdateProductByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) DeleteProductsByOwnerID(ctx context.Context, in *DeleteProductsByOwnerIDRequest) (*DeleteProductsByOwnerIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductsByOwnerID")
	out := new(DeleteProductsByOwnerIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) DeleteProductByID(ctx context.Context, in *DeleteProductByIDRequest) (*DeleteProductByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductByID")
	out := new(DeleteProductByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogProtobufClient) GetProductsByShortNames(ctx context.Context, in *GetProductsByShortNamesRequest) (*GetProductsByShortNamesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByShortNames")
	out := new(GetProductsByShortNamesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// TwitchProductCatalog JSON Client
// ================================

type twitchProductCatalogJSONClient struct {
	client HTTPClient
	urls   [9]string
	opts   twirp.ClientOptions
}

// NewTwitchProductCatalogJSONClient creates a JSON client that implements the TwitchProductCatalog interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchProductCatalogJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchProductCatalog {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchProductCatalogPathPrefix
	urls := [9]string{
		prefix + "GetProductsByIDs",
		prefix + "GetProductsByOwnerID",
		prefix + "CreateProducts",
		prefix + "UpsertBenefits",
		prefix + "GetProductsByBenefits",
		prefix + "UpdateProductByID",
		prefix + "DeleteProductsByOwnerID",
		prefix + "DeleteProductByID",
		prefix + "GetProductsByShortNames",
	}

	return &twitchProductCatalogJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchProductCatalogJSONClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByIDs")
	out := new(GetProductsByIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) GetProductsByOwnerID(ctx context.Context, in *GetProductsByOwnerIDRequest) (*GetProductsByOwnerIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByOwnerID")
	out := new(GetProductsByOwnerIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) CreateProducts(ctx context.Context, in *CreateProductsRequest) (*CreateProductsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducts")
	out := new(CreateProductsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) UpsertBenefits(ctx context.Context, in *UpsertBenefitsRequest) (*UpsertBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "UpsertBenefits")
	out := new(UpsertBenefitsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) GetProductsByBenefits(ctx context.Context, in *GetProductsByBenefitsRequest) (*GetProductsByBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByBenefits")
	out := new(GetProductsByBenefitsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) UpdateProductByID(ctx context.Context, in *UpdateProductByIDRequest) (*UpdateProductByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProductByID")
	out := new(UpdateProductByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) DeleteProductsByOwnerID(ctx context.Context, in *DeleteProductsByOwnerIDRequest) (*DeleteProductsByOwnerIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductsByOwnerID")
	out := new(DeleteProductsByOwnerIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) DeleteProductByID(ctx context.Context, in *DeleteProductByIDRequest) (*DeleteProductByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductByID")
	out := new(DeleteProductByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchProductCatalogJSONClient) GetProductsByShortNames(ctx context.Context, in *GetProductsByShortNamesRequest) (*GetProductsByShortNamesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByShortNames")
	out := new(GetProductsByShortNamesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================================
// TwitchProductCatalog Server Handler
// ===================================

type twitchProductCatalogServer struct {
	TwitchProductCatalog
	hooks *twirp.ServerHooks
}

func NewTwitchProductCatalogServer(svc TwitchProductCatalog, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchProductCatalogServer{
		TwitchProductCatalog: svc,
		hooks:                hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchProductCatalogServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchProductCatalogPathPrefix is used for all URL paths on a twirp TwitchProductCatalog server.
// Requests are always: POST TwitchProductCatalogPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchProductCatalogPathPrefix = "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/"

func (s *twitchProductCatalogServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchproductcatalog")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchProductCatalog")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/GetProductsByIDs":
		s.serveGetProductsByIDs(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/GetProductsByOwnerID":
		s.serveGetProductsByOwnerID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/CreateProducts":
		s.serveCreateProducts(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/UpsertBenefits":
		s.serveUpsertBenefits(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/GetProductsByBenefits":
		s.serveGetProductsByBenefits(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/UpdateProductByID":
		s.serveUpdateProductByID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/DeleteProductsByOwnerID":
		s.serveDeleteProductsByOwnerID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/DeleteProductByID":
		s.serveDeleteProductByID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchproductcatalog.TwitchProductCatalog/GetProductsByShortNames":
		s.serveGetProductsByShortNames(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchProductCatalogServer) serveGetProductsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProductsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveGetProductsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProductsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetProductsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByOwnerID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProductsByOwnerIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByOwnerIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveGetProductsByOwnerIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByOwnerID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProductsByOwnerIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByOwnerIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByOwnerID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByOwnerIDResponse and nil error while calling GetProductsByOwnerID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByOwnerIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByOwnerID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetProductsByOwnerIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByOwnerIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByOwnerID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByOwnerIDResponse and nil error while calling GetProductsByOwnerID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveCreateProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveCreateProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateProductsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.CreateProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateProductsResponse and nil error while calling CreateProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveCreateProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateProductsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateProductsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.CreateProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateProductsResponse and nil error while calling CreateProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveUpsertBenefits(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpsertBenefitsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpsertBenefitsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveUpsertBenefitsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpsertBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpsertBenefitsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpsertBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.UpsertBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpsertBenefitsResponse and nil error while calling UpsertBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveUpsertBenefitsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpsertBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpsertBenefitsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpsertBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.UpsertBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpsertBenefitsResponse and nil error while calling UpsertBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByBenefits(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProductsByBenefitsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByBenefitsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveGetProductsByBenefitsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProductsByBenefitsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByBenefitsResponse and nil error while calling GetProductsByBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByBenefitsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetProductsByBenefitsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByBenefitsResponse and nil error while calling GetProductsByBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveUpdateProductByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateProductByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProductByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveUpdateProductByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProductByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateProductByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateProductByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.UpdateProductByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductByIDResponse and nil error while calling UpdateProductByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveUpdateProductByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProductByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateProductByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateProductByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.UpdateProductByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductByIDResponse and nil error while calling UpdateProductByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveDeleteProductsByOwnerID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteProductsByOwnerIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteProductsByOwnerIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveDeleteProductsByOwnerIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductsByOwnerID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteProductsByOwnerIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteProductsByOwnerIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.DeleteProductsByOwnerID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteProductsByOwnerIDResponse and nil error while calling DeleteProductsByOwnerID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveDeleteProductsByOwnerIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductsByOwnerID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteProductsByOwnerIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteProductsByOwnerIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.DeleteProductsByOwnerID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteProductsByOwnerIDResponse and nil error while calling DeleteProductsByOwnerID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveDeleteProductByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteProductByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteProductByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveDeleteProductByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteProductByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteProductByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.DeleteProductByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteProductByIDResponse and nil error while calling DeleteProductByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveDeleteProductByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteProductByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteProductByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteProductByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.DeleteProductByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteProductByIDResponse and nil error while calling DeleteProductByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByShortNames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProductsByShortNamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByShortNamesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchProductCatalogServer) serveGetProductsByShortNamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByShortNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProductsByShortNamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByShortNamesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByShortNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByShortNamesResponse and nil error while calling GetProductsByShortNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) serveGetProductsByShortNamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProductsByShortNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetProductsByShortNamesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProductsByShortNamesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchProductCatalog.GetProductsByShortNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByShortNamesResponse and nil error while calling GetProductsByShortNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchProductCatalogServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchProductCatalogServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchProductCatalogServer) PathPrefix() string {
	return TwitchProductCatalogPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1522 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0x36, 0xf5, 0x63, 0x49, 0x43, 0xff, 0xd0, 0x9b, 0x3f, 0x45, 0x69, 0x62, 0x97, 0xbd, 0xb8,
	0x2e, 0x22, 0xa1, 0x0e, 0x90, 0x26, 0x6d, 0x82, 0x84, 0x92, 0x18, 0x9b, 0xa9, 0x4c, 0x05, 0x14,
	0x15, 0xd4, 0x39, 0x94, 0xa5, 0xc4, 0xb5, 0xcd, 0x40, 0xa6, 0x54, 0x71, 0xd5, 0xd4, 0x45, 0xce,
	0xed, 0x29, 0x40, 0xaf, 0x05, 0x72, 0xea, 0x0b, 0xf4, 0x05, 0x7a, 0xed, 0xb5, 0x7d, 0x87, 0xa2,
	0x7d, 0x8f, 0x82, 0xdc, 0xa5, 0x48, 0xc9, 0x92, 0x43, 0x4b, 0x46, 0x91, 0x8b, 0xbd, 0xbb, 0xdc,
	0xf9, 0xbe, 0xd9, 0x99, 0xd9, 0xd9, 0x19, 0xc1, 0xfd, 0x76, 0xd7, 0xc2, 0xc5, 0x97, 0x03, 0x97,
	0xd8, 0x4e, 0x91, 0x7c, 0x57, 0x32, 0x8f, 0x7f, 0x70, 0x4a, 0xfa, 0x2b, 0x9b, 0xb4, 0x8f, 0x9e,
	0xf5, 0xbb, 0xd6, 0xa0, 0x4d, 0x2a, 0x26, 0x31, 0x3b, 0xdd, 0x43, 0xfd, 0x95, 0xdd, 0xef, 0x95,
	0x88, 0xf7, 0xb7, 0xd8, 0xeb, 0x77, 0x49, 0x17, 0x89, 0xc4, 0xdf, 0x56, 0x3c, 0x18, 0x74, 0x48,
	0xd7, 0x29, 0xd2, 0x59, 0x8f, 0x0a, 0xb5, 0xa9, 0x50, 0x61, 0xfd, 0xb0, 0xdb, 0x3d, 0xec, 0xe0,
	0x92, 0x2f, 0xd1, 0x1a, 0x1c, 0x94, 0x88, 0x7d, 0x8c, 0x5d, 0x62, 0x1e, 0x33, 0x10, 0xf1, 0x9f,
	0x14, 0x64, 0x18, 0x11, 0x5a, 0x81, 0x84, 0x6d, 0xe5, 0xb9, 0x0d, 0x6e, 0x33, 0xa7, 0x25, 0x6c,
	0x0b, 0x5d, 0x86, 0x34, 0xb1, 0x49, 0x07, 0xe7, 0x13, 0xfe, 0x12, 0x9d, 0xa0, 0x0d, 0xe0, 0x2d,
	0xec, 0xb6, 0xfb, 0x76, 0x8f, 0xd8, 0x5d, 0x27, 0x9f, 0xf4, 0xbf, 0x45, 0x97, 0xd0, 0x0e, 0x64,
	0x5b, 0xd8, 0xc1, 0x07, 0x36, 0x71, 0xf3, 0xa9, 0x8d, 0xe4, 0x26, 0xbf, 0xfd, 0x49, 0xf1, 0xdd,
	0xba, 0x16, 0xcb, 0x54, 0x46, 0x1b, 0x0a, 0xa3, 0x47, 0x90, 0x76, 0x89, 0x49, 0x70, 0x7e, 0x71,
	0x83, 0xdb, 0x5c, 0xd9, 0xfe, 0x38, 0x0e, 0x4a, 0xc3, 0x13, 0xd0, 0xa8, 0x1c, 0xba, 0x0e, 0xd9,
	0xee, 0x2b, 0x07, 0xf7, 0x0d, 0xdb, 0xca, 0x67, 0x7d, 0x45, 0x33, 0xfe, 0x5c, 0xb1, 0xd0, 0x7d,
	0x80, 0x76, 0x1f, 0x9b, 0x04, 0x5b, 0x46, 0xd7, 0xc9, 0xc3, 0x06, 0xb7, 0xc9, 0x6f, 0x17, 0x8a,
	0xd4, 0x5c, 0xc5, 0xc0, 0x5c, 0x45, 0x3d, 0x30, 0x97, 0x96, 0x63, 0xbb, 0xeb, 0x0e, 0x7a, 0x08,
	0x4b, 0x1d, 0xd3, 0x25, 0xc6, 0xa0, 0x67, 0x79, 0x2b, 0x79, 0xfe, 0x9d, 0xc2, 0xbc, 0xb7, 0xbf,
	0x49, 0xb7, 0xa3, 0x23, 0x40, 0xee, 0xa0, 0x35, 0x34, 0x97, 0x71, 0x60, 0xb6, 0x31, 0xc9, 0x2f,
	0xf9, 0x20, 0x9f, 0xc5, 0x3a, 0x62, 0x44, 0x9a, 0xf9, 0x6e, 0x77, 0x41, 0x5b, 0x8b, 0x82, 0x3e,
	0xf1, 0x30, 0x11, 0x86, 0xb5, 0x36, 0xee, 0xe0, 0x56, 0xdf, 0x8c, 0x10, 0x2d, 0xfb, 0x44, 0x77,
	0xe3, 0x10, 0x55, 0x42, 0xe1, 0x90, 0x47, 0x88, 0x40, 0xfa, 0x34, 0xe5, 0x55, 0x58, 0x66, 0x82,
	0x94, 0xe2, 0x69, 0x2a, 0x9b, 0x16, 0x16, 0x9f, 0xa6, 0xb2, 0x19, 0x21, 0xfb, 0x34, 0x95, 0xcd,
	0x09, 0x20, 0xbe, 0x49, 0x42, 0x86, 0xf9, 0xf7, 0x54, 0x98, 0x7d, 0x09, 0x29, 0x72, 0xd2, 0xa3,
	0x51, 0xb6, 0x12, 0xcf, 0x02, 0x0c, 0x2a, 0xf8, 0xaf, 0x9f, 0xf4, 0xb0, 0xe6, 0x83, 0x20, 0x35,
	0x08, 0x99, 0xa4, 0x8f, 0x76, 0x6f, 0x06, 0xb4, 0x91, 0x08, 0x5a, 0x07, 0x1e, 0x7f, 0x4f, 0x70,
	0xdf, 0x31, 0x3b, 0x5e, 0x10, 0xa5, 0x7c, 0xad, 0x21, 0x58, 0x52, 0x2c, 0xf1, 0x35, 0xf0, 0x11,
	0x2d, 0x10, 0x0f, 0x19, 0xb5, 0x6e, 0xe8, 0xfb, 0xcf, 0x64, 0x61, 0x01, 0x2d, 0x43, 0x4e, 0xde,
	0xab, 0xeb, 0xb2, 0xd1, 0x90, 0x75, 0x81, 0x43, 0x97, 0x60, 0xb5, 0xb2, 0x2b, 0xa9, 0xaa, 0x5c,
	0x33, 0xa4, 0xaa, 0xf1, 0x44, 0x93, 0x65, 0x21, 0x81, 0x10, 0xac, 0xec, 0xd4, 0xea, 0x65, 0x29,
	0x5c, 0x4b, 0x22, 0x01, 0x96, 0x1a, 0xcd, 0xb2, 0x51, 0x57, 0x6b, 0xfb, 0xc6, 0xf3, 0x7a, 0x55,
	0x48, 0xa1, 0xab, 0x80, 0x24, 0x55, 0xd9, 0x93, 0x74, 0xb9, 0x6a, 0x84, 0x90, 0x69, 0xf1, 0x2e,
	0x2c, 0x45, 0xb5, 0x46, 0x4b, 0x90, 0x55, 0xeb, 0x46, 0x43, 0x97, 0x74, 0x8f, 0x1f, 0x60, 0x51,
	0xaa, 0xe8, 0xca, 0x73, 0x59, 0xe0, 0xbc, 0x2f, 0x8a, 0xca, 0x66, 0x09, 0xf1, 0x6d, 0x12, 0x2e,
	0x4d, 0x08, 0x23, 0xb4, 0x05, 0x6b, 0x1d, 0x7c, 0x68, 0xb6, 0x4f, 0x8c, 0xc0, 0xa3, 0x43, 0x57,
	0xad, 0xd2, 0x0f, 0x6c, 0xa7, 0x62, 0xa1, 0x17, 0x90, 0x75, 0x07, 0x2d, 0x23, 0xe2, 0xbb, 0x47,
	0x33, 0x46, 0xaf, 0xb7, 0xe6, 0xfb, 0x30, 0xe3, 0xd2, 0x01, 0x6a, 0x40, 0x8a, 0xd8, 0xb8, 0xcf,
	0xbc, 0x38, 0x17, 0xae, 0x8d, 0xfb, 0x9a, 0x0f, 0x86, 0x6e, 0x02, 0xb8, 0x47, 0xdd, 0x3e, 0x31,
	0x1c, 0xf3, 0x18, 0x33, 0x57, 0xe6, 0xfc, 0x15, 0xd5, 0x3c, 0xc6, 0xe2, 0x3d, 0xc8, 0x30, 0x3d,
	0x50, 0x16, 0x52, 0x6a, 0x5d, 0xf5, 0x4c, 0xc8, 0x43, 0xc6, 0xf3, 0x59, 0xa3, 0x59, 0x16, 0x38,
	0x6f, 0xa2, 0xcb, 0xd2, 0x9e, 0x37, 0x49, 0xa0, 0x1c, 0xa4, 0xf5, 0xa6, 0x56, 0xae, 0x0b, 0x49,
	0xb1, 0x4e, 0x25, 0x3d, 0x0e, 0xe6, 0x7f, 0x45, 0xd6, 0xa8, 0xfd, 0xbd, 0x91, 0xf1, 0xa9, 0xc0,
	0x0d, 0xc7, 0xdb, 0x42, 0x62, 0x38, 0xbe, 0x23, 0x24, 0xbd, 0x71, 0xa5, 0xd9, 0xd0, 0xeb, 0x7b,
	0x42, 0x0a, 0x65, 0x20, 0x29, 0xa9, 0xfb, 0x42, 0x5a, 0xfc, 0x8b, 0x03, 0x74, 0xfa, 0xf2, 0xa1,
	0xaf, 0x21, 0x67, 0x3b, 0x04, 0x3b, 0xae, 0x4d, 0x4e, 0x7c, 0xaf, 0xac, 0x6c, 0x3f, 0x9e, 0xed,
	0x1e, 0x17, 0x95, 0x00, 0x47, 0x0b, 0x21, 0xc5, 0x7d, 0xc8, 0x0d, 0xd7, 0x23, 0x36, 0x58, 0x05,
	0x5e, 0xfe, 0x4a, 0xd7, 0x24, 0xa3, 0xb1, 0x27, 0xd5, 0x6a, 0x02, 0xe7, 0x1d, 0x9d, 0x0e, 0xfd,
	0xa3, 0xec, 0xc9, 0x55, 0xa5, 0xb9, 0x27, 0x24, 0xbd, 0xe5, 0x9a, 0xa4, 0xed, 0xc8, 0x42, 0x2a,
	0x14, 0xa1, 0x0b, 0x69, 0xf1, 0x37, 0x0e, 0xae, 0xed, 0x60, 0xc2, 0xe8, 0xdd, 0xf2, 0x89, 0x52,
	0x75, 0x35, 0xfc, 0xed, 0x00, 0xbb, 0x04, 0x09, 0x90, 0xb4, 0x2d, 0x37, 0xcf, 0x6d, 0x24, 0x37,
	0x73, 0x9a, 0x37, 0xf4, 0x12, 0x3f, 0x4d, 0x56, 0x89, 0xf8, 0x89, 0xdf, 0xcf, 0x45, 0x1a, 0x95,
	0x43, 0x12, 0x2c, 0x1e, 0xd8, 0x1d, 0xe2, 0x47, 0x50, 0xf2, 0x7c, 0x4f, 0x07, 0x13, 0x14, 0x7f,
	0xe7, 0xe0, 0xc6, 0x88, 0xc6, 0x75, 0xff, 0xe5, 0xa8, 0x06, 0x5a, 0x47, 0xdf, 0x16, 0x6e, 0xf4,
	0x6d, 0x79, 0x1f, 0xd4, 0xff, 0x06, 0xae, 0x54, 0xfc, 0x17, 0x2b, 0x38, 0x40, 0xa0, 0xf7, 0x0e,
	0x64, 0x99, 0x20, 0x35, 0x79, 0xcc, 0xd7, 0x99, 0xc1, 0x68, 0x43, 0x61, 0xf1, 0x0f, 0x0e, 0x6e,
	0x8d, 0x18, 0xa8, 0x11, 0x5c, 0xa5, 0x21, 0xd7, 0x3a, 0xf0, 0xe1, 0x8d, 0x0b, 0x3c, 0x0c, 0xc3,
	0x2b, 0xe7, 0xbe, 0x2f, 0x96, 0x6a, 0xf6, 0x5c, 0xdc, 0x27, 0x2c, 0x93, 0x46, 0x2d, 0x35, 0xac,
	0x63, 0xb8, 0x39, 0xea, 0x18, 0xd1, 0x84, 0xab, 0xe3, 0x0c, 0x6e, 0xaf, 0xeb, 0xb8, 0x78, 0x84,
	0x22, 0x31, 0x0f, 0xc5, 0x9f, 0x09, 0xf8, 0x60, 0xc4, 0x19, 0xe3, 0x87, 0xb1, 0x4e, 0x1d, 0x66,
	0x37, 0x0e, 0xd3, 0x59, 0x98, 0x93, 0x2b, 0xb6, 0xb9, 0xfc, 0x59, 0xf8, 0x91, 0x0b, 0x0b, 0x85,
	0xb1, 0xb7, 0x97, 0x1b, 0x7f, 0x7b, 0xd1, 0x0b, 0x58, 0x62, 0xcc, 0xc6, 0x45, 0x54, 0x10, 0x7c,
	0x2b, 0x9c, 0x88, 0x47, 0x70, 0x73, 0xca, 0xd9, 0x43, 0xd7, 0x5d, 0xcc, 0x3d, 0x6a, 0x43, 0xfe,
	0x74, 0x66, 0xbc, 0x68, 0x92, 0xc3, 0xb1, 0xf0, 0x18, 0x26, 0xb3, 0x8b, 0x26, 0x32, 0xe1, 0xea,
	0x78, 0xde, 0xb9, 0x68, 0x8a, 0x97, 0xb0, 0x3e, 0x35, 0xef, 0x5c, 0x34, 0xd7, 0xdf, 0x09, 0xe0,
	0x69, 0xe1, 0xae, 0x38, 0xbd, 0x01, 0x41, 0x1f, 0xc1, 0x12, 0x2d, 0xfb, 0x0d, 0xda, 0x1a, 0xf9,
	0x41, 0xb9, 0xbb, 0xa0, 0xf1, 0x74, 0x55, 0xf7, 0x5b, 0xa4, 0x12, 0x20, 0xb6, 0x29, 0xda, 0x29,
	0x25, 0xd8, 0xd6, 0x35, 0xfa, 0xad, 0x1a, 0xe9, 0x98, 0x74, 0x58, 0x61, 0x02, 0x2c, 0x04, 0xfd,
	0xc2, 0xe7, 0x7c, 0xc9, 0x60, 0x77, 0x41, 0x5b, 0xa6, 0x20, 0xc1, 0xfd, 0x51, 0x87, 0xba, 0xd2,
	0x92, 0x38, 0x75, 0xce, 0x2e, 0x2a, 0x3c, 0x16, 0x2d, 0x2e, 0x55, 0xe0, 0x4d, 0xcb, 0x1a, 0xaa,
	0x98, 0x9e, 0x45, 0x45, 0x30, 0x2d, 0x8b, 0xcd, 0xca, 0x19, 0x48, 0x1f, 0xd8, 0xb8, 0x63, 0x89,
	0x2e, 0xe4, 0xa9, 0x8d, 0x99, 0xfd, 0xbd, 0x3b, 0x10, 0xe4, 0xad, 0xf1, 0x6e, 0x61, 0x07, 0x16,
	0x6d, 0xcf, 0x13, 0x41, 0xbe, 0x2c, 0xc5, 0xe1, 0x8f, 0x78, 0x50, 0x63, 0xe2, 0x62, 0x0b, 0xae,
	0x4f, 0x20, 0x65, 0xf1, 0x23, 0x43, 0x86, 0x41, 0xf8, 0xd4, 0xe7, 0x0c, 0x9f, 0x40, 0x56, 0x7c,
	0x0d, 0xb7, 0xaa, 0xb8, 0x83, 0xc3, 0xcb, 0xf0, 0x7f, 0x56, 0x11, 0xe2, 0x87, 0xb0, 0x3e, 0x95,
	0x9d, 0x9e, 0x53, 0xdc, 0x82, 0xfc, 0xc8, 0x96, 0x33, 0x2c, 0x2f, 0xde, 0x80, 0xeb, 0x13, 0xf6,
	0x52, 0xa0, 0xad, 0x12, 0xa4, 0x69, 0x90, 0xe4, 0x20, 0x5d, 0xd5, 0xa4, 0x27, 0x3a, 0x6d, 0x7f,
	0x9e, 0x35, 0xcb, 0x35, 0xa5, 0xb1, 0x2b, 0x57, 0x69, 0x07, 0x22, 0x69, 0x95, 0x5d, 0xe5, 0xb9,
	0x5c, 0x15, 0x12, 0x5b, 0xb7, 0x21, 0x4d, 0x9b, 0xd4, 0xb0, 0xce, 0xcc, 0x42, 0xaa, 0xd1, 0x2c,
	0x37, 0x04, 0xce, 0x6b, 0x80, 0x2a, 0x72, 0x4d, 0x2e, 0x6b, 0x92, 0xae, 0xd4, 0xd5, 0x86, 0x90,
	0xd8, 0xfe, 0x17, 0xe0, 0xf2, 0xa4, 0x9f, 0x45, 0xd0, 0x1b, 0x0e, 0x84, 0xf1, 0xf4, 0x89, 0xbe,
	0x38, 0xf7, 0xd3, 0x16, 0x96, 0xa3, 0x85, 0x07, 0xb3, 0x09, 0xb3, 0xc8, 0xf9, 0x85, 0x83, 0xcb,
	0x93, 0x32, 0x2d, 0x7a, 0x74, 0x6e, 0xd8, 0xd1, 0x50, 0x29, 0x3c, 0x9e, 0x1d, 0x80, 0xe9, 0xf6,
	0x13, 0x07, 0x2b, 0xa3, 0xc9, 0x19, 0xdd, 0x8f, 0xd5, 0x3f, 0x4c, 0x2a, 0x24, 0x0b, 0x9f, 0xcf,
	0x22, 0x1a, 0xd1, 0x64, 0xb4, 0x24, 0x8a, 0xa7, 0xc9, 0xc4, 0x42, 0x2d, 0x9e, 0x26, 0x53, 0x2a,
	0xb0, 0xb7, 0x1c, 0x5c, 0x99, 0xf8, 0xd0, 0xa3, 0xc7, 0xf3, 0xd6, 0x47, 0x05, 0x69, 0x0e, 0x04,
	0xa6, 0xde, 0xcf, 0x1c, 0xac, 0x9d, 0x4a, 0x53, 0xe8, 0x41, 0xfc, 0xa4, 0x77, 0xfa, 0x62, 0x17,
	0x1e, 0xce, 0x28, 0xcd, 0x54, 0xfa, 0x95, 0x83, 0x6b, 0x53, 0xf2, 0x0a, 0x2a, 0xc7, 0x81, 0x3e,
	0x3b, 0x25, 0x16, 0x2a, 0x73, 0x61, 0x44, 0xec, 0x76, 0x2a, 0x5b, 0xc5, 0xb3, 0xdb, 0xb4, 0x84,
	0x18, 0xcf, 0x6e, 0x53, 0x53, 0xa4, 0x6f, 0xb7, 0x29, 0x75, 0x4b, 0x3c, 0xbb, 0x9d, 0xdd, 0x6c,
	0xc5, 0xb3, 0xdb, 0x3b, 0x0a, 0xa7, 0x72, 0xe9, 0xc5, 0xed, 0x73, 0xfd, 0x22, 0xdd, 0x5a, 0xf4,
	0x7f, 0xee, 0xbc, 0xf3, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x78, 0x2c, 0x44, 0x17, 0xc9, 0x16,
	0x00, 0x00,
}
