// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchRadioJetSetTwirp/twirp.proto

/*
Package TwitchRadioJetSetTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchRadioJetSetTwirp/twirp.proto
*/
package TwitchRadioJetSetTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===========================
// TwitchRadioJetSet Interface
// ===========================

type TwitchRadioJetSet interface {
	GetPlaylist(context.Context, *GetWithASINRequest) (*Playlist, error)

	// GetPlaylists is deprecated due to extra arguments on the frontend,
	// remove once usage is extracted from graphql
	GetPlaylists(context.Context, *GetRequest) (*Playlists, error)

	GetBulkPlaylists(context.Context, *GetPlaylistsRequest) (*Playlists, error)

	GetUserInfo(context.Context, *GetRequest) (*UserInfo, error)

	AddRecentlyPlayed(context.Context, *AddRecentRequest) (*Recent, error)

	GetRecentlyPlayed(context.Context, *GetRecentRequest) (*Recents, error)

	GetCurrentlyPlaying(context.Context, *GetCurrentRequest) (*CurrentlyPlaying, error)

	SetCurrentlyPlaying(context.Context, *SetCurrentRequest) (*CurrentTrack, error)

	AddTrack(context.Context, *AddTrackRequest) (*Track, error)

	GetTrack(context.Context, *GetTrackRequest) (*TrackV2, error)

	GetTrackByTitleset(context.Context, *GetTrackRequest) (*TrackV2, error)

	GetStations(context.Context, *GetRequest) (*Stations, error)

	GetStationCreateQueue(context.Context, *GetWithASINRequest) (*Station, error)

	GetNextStationTracks(context.Context, *GetNextStationTrackRequest) (*Station, error)

	GetLinkFireData(context.Context, *LinkFireRequest) (*LinkFireResponse, error)

	GetRumbaConfig(context.Context, *RumbaRequest) (*RumbaResponse, error)
}

// =================================
// TwitchRadioJetSet Protobuf Client
// =================================

type twitchRadioJetSetProtobufClient struct {
	client HTTPClient
	urls   [16]string
	opts   twirp.ClientOptions
}

// NewTwitchRadioJetSetProtobufClient creates a Protobuf client that implements the TwitchRadioJetSet interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchRadioJetSetProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchRadioJetSet {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchRadioJetSetPathPrefix
	urls := [16]string{
		prefix + "GetPlaylist",
		prefix + "GetPlaylists",
		prefix + "GetBulkPlaylists",
		prefix + "GetUserInfo",
		prefix + "AddRecentlyPlayed",
		prefix + "GetRecentlyPlayed",
		prefix + "GetCurrentlyPlaying",
		prefix + "SetCurrentlyPlaying",
		prefix + "AddTrack",
		prefix + "GetTrack",
		prefix + "GetTrackByTitleset",
		prefix + "GetStations",
		prefix + "GetStationCreateQueue",
		prefix + "GetNextStationTracks",
		prefix + "GetLinkFireData",
		prefix + "GetRumbaConfig",
	}

	return &twitchRadioJetSetProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchRadioJetSetProtobufClient) GetPlaylist(ctx context.Context, in *GetWithASINRequest) (*Playlist, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	out := new(Playlist)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetPlaylists(ctx context.Context, in *GetRequest) (*Playlists, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	out := new(Playlists)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetBulkPlaylists(ctx context.Context, in *GetPlaylistsRequest) (*Playlists, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkPlaylists")
	out := new(Playlists)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetUserInfo(ctx context.Context, in *GetRequest) (*UserInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserInfo")
	out := new(UserInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) AddRecentlyPlayed(ctx context.Context, in *AddRecentRequest) (*Recent, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "AddRecentlyPlayed")
	out := new(Recent)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetRecentlyPlayed(ctx context.Context, in *GetRecentRequest) (*Recents, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyPlayed")
	out := new(Recents)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetCurrentlyPlaying(ctx context.Context, in *GetCurrentRequest) (*CurrentlyPlaying, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetCurrentlyPlaying")
	out := new(CurrentlyPlaying)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) SetCurrentlyPlaying(ctx context.Context, in *SetCurrentRequest) (*CurrentTrack, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "SetCurrentlyPlaying")
	out := new(CurrentTrack)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) AddTrack(ctx context.Context, in *AddTrackRequest) (*Track, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "AddTrack")
	out := new(Track)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetTrack(ctx context.Context, in *GetTrackRequest) (*TrackV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetTrack")
	out := new(TrackV2)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetTrackByTitleset(ctx context.Context, in *GetTrackRequest) (*TrackV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetTrackByTitleset")
	out := new(TrackV2)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetStations(ctx context.Context, in *GetRequest) (*Stations, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetStations")
	out := new(Stations)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetStationCreateQueue(ctx context.Context, in *GetWithASINRequest) (*Station, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetStationCreateQueue")
	out := new(Station)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetNextStationTracks(ctx context.Context, in *GetNextStationTrackRequest) (*Station, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetNextStationTracks")
	out := new(Station)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetLinkFireData(ctx context.Context, in *LinkFireRequest) (*LinkFireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkFireData")
	out := new(LinkFireResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetProtobufClient) GetRumbaConfig(ctx context.Context, in *RumbaRequest) (*RumbaResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetRumbaConfig")
	out := new(RumbaResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =============================
// TwitchRadioJetSet JSON Client
// =============================

type twitchRadioJetSetJSONClient struct {
	client HTTPClient
	urls   [16]string
	opts   twirp.ClientOptions
}

// NewTwitchRadioJetSetJSONClient creates a JSON client that implements the TwitchRadioJetSet interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchRadioJetSetJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchRadioJetSet {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchRadioJetSetPathPrefix
	urls := [16]string{
		prefix + "GetPlaylist",
		prefix + "GetPlaylists",
		prefix + "GetBulkPlaylists",
		prefix + "GetUserInfo",
		prefix + "AddRecentlyPlayed",
		prefix + "GetRecentlyPlayed",
		prefix + "GetCurrentlyPlaying",
		prefix + "SetCurrentlyPlaying",
		prefix + "AddTrack",
		prefix + "GetTrack",
		prefix + "GetTrackByTitleset",
		prefix + "GetStations",
		prefix + "GetStationCreateQueue",
		prefix + "GetNextStationTracks",
		prefix + "GetLinkFireData",
		prefix + "GetRumbaConfig",
	}

	return &twitchRadioJetSetJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchRadioJetSetJSONClient) GetPlaylist(ctx context.Context, in *GetWithASINRequest) (*Playlist, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	out := new(Playlist)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetPlaylists(ctx context.Context, in *GetRequest) (*Playlists, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	out := new(Playlists)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetBulkPlaylists(ctx context.Context, in *GetPlaylistsRequest) (*Playlists, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkPlaylists")
	out := new(Playlists)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetUserInfo(ctx context.Context, in *GetRequest) (*UserInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserInfo")
	out := new(UserInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) AddRecentlyPlayed(ctx context.Context, in *AddRecentRequest) (*Recent, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "AddRecentlyPlayed")
	out := new(Recent)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetRecentlyPlayed(ctx context.Context, in *GetRecentRequest) (*Recents, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyPlayed")
	out := new(Recents)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetCurrentlyPlaying(ctx context.Context, in *GetCurrentRequest) (*CurrentlyPlaying, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetCurrentlyPlaying")
	out := new(CurrentlyPlaying)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) SetCurrentlyPlaying(ctx context.Context, in *SetCurrentRequest) (*CurrentTrack, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "SetCurrentlyPlaying")
	out := new(CurrentTrack)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) AddTrack(ctx context.Context, in *AddTrackRequest) (*Track, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "AddTrack")
	out := new(Track)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetTrack(ctx context.Context, in *GetTrackRequest) (*TrackV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetTrack")
	out := new(TrackV2)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetTrackByTitleset(ctx context.Context, in *GetTrackRequest) (*TrackV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetTrackByTitleset")
	out := new(TrackV2)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetStations(ctx context.Context, in *GetRequest) (*Stations, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetStations")
	out := new(Stations)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetStationCreateQueue(ctx context.Context, in *GetWithASINRequest) (*Station, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetStationCreateQueue")
	out := new(Station)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetNextStationTracks(ctx context.Context, in *GetNextStationTrackRequest) (*Station, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetNextStationTracks")
	out := new(Station)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetLinkFireData(ctx context.Context, in *LinkFireRequest) (*LinkFireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkFireData")
	out := new(LinkFireResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRadioJetSetJSONClient) GetRumbaConfig(ctx context.Context, in *RumbaRequest) (*RumbaResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithMethodName(ctx, "GetRumbaConfig")
	out := new(RumbaResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// TwitchRadioJetSet Server Handler
// ================================

type twitchRadioJetSetServer struct {
	TwitchRadioJetSet
	hooks *twirp.ServerHooks
}

func NewTwitchRadioJetSetServer(svc TwitchRadioJetSet, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchRadioJetSetServer{
		TwitchRadioJetSet: svc,
		hooks:             hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchRadioJetSetServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchRadioJetSetPathPrefix is used for all URL paths on a twirp TwitchRadioJetSet server.
// Requests are always: POST TwitchRadioJetSetPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchRadioJetSetPathPrefix = "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/"

func (s *twitchRadioJetSetServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchradiojetset")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRadioJetSet")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetPlaylist":
		s.serveGetPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetPlaylists":
		s.serveGetPlaylists(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetBulkPlaylists":
		s.serveGetBulkPlaylists(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetUserInfo":
		s.serveGetUserInfo(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/AddRecentlyPlayed":
		s.serveAddRecentlyPlayed(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetRecentlyPlayed":
		s.serveGetRecentlyPlayed(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetCurrentlyPlaying":
		s.serveGetCurrentlyPlaying(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/SetCurrentlyPlaying":
		s.serveSetCurrentlyPlaying(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/AddTrack":
		s.serveAddTrack(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetTrack":
		s.serveGetTrack(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetTrackByTitleset":
		s.serveGetTrackByTitleset(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetStations":
		s.serveGetStations(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetStationCreateQueue":
		s.serveGetStationCreateQueue(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetNextStationTracks":
		s.serveGetNextStationTracks(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetLinkFireData":
		s.serveGetLinkFireData(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchradiojetset.TwitchRadioJetSet/GetRumbaConfig":
		s.serveGetRumbaConfig(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchRadioJetSetServer) serveGetPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetWithASINRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Playlist
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Playlist and nil error while calling GetPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetWithASINRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Playlist
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Playlist and nil error while calling GetPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetPlaylists(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPlaylistsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPlaylistsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetPlaylistsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Playlists
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetPlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Playlists and nil error while calling GetPlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetPlaylistsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Playlists
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetPlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Playlists and nil error while calling GetPlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetBulkPlaylists(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBulkPlaylistsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBulkPlaylistsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetBulkPlaylistsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkPlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPlaylistsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Playlists
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetBulkPlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Playlists and nil error while calling GetBulkPlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetBulkPlaylistsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkPlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPlaylistsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Playlists
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetBulkPlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Playlists and nil error while calling GetBulkPlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetUserInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetUserInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UserInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetUserInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserInfo and nil error while calling GetUserInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetUserInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UserInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetUserInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserInfo and nil error while calling GetUserInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveAddRecentlyPlayed(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddRecentlyPlayedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddRecentlyPlayedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveAddRecentlyPlayedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRecentlyPlayed")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddRecentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Recent
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.AddRecentlyPlayed(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Recent and nil error while calling AddRecentlyPlayed. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveAddRecentlyPlayedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRecentlyPlayed")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddRecentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Recent
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.AddRecentlyPlayed(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Recent and nil error while calling AddRecentlyPlayed. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetRecentlyPlayed(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecentlyPlayedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecentlyPlayedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetRecentlyPlayedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyPlayed")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Recents
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetRecentlyPlayed(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Recents and nil error while calling GetRecentlyPlayed. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetRecentlyPlayedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyPlayed")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Recents
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetRecentlyPlayed(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Recents and nil error while calling GetRecentlyPlayed. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetCurrentlyPlaying(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCurrentlyPlayingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCurrentlyPlayingProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetCurrentlyPlayingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCurrentlyPlaying")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCurrentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CurrentlyPlaying
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetCurrentlyPlaying(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CurrentlyPlaying and nil error while calling GetCurrentlyPlaying. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetCurrentlyPlayingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCurrentlyPlaying")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCurrentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CurrentlyPlaying
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetCurrentlyPlaying(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CurrentlyPlaying and nil error while calling GetCurrentlyPlaying. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveSetCurrentlyPlaying(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetCurrentlyPlayingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetCurrentlyPlayingProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveSetCurrentlyPlayingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCurrentlyPlaying")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetCurrentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CurrentTrack
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.SetCurrentlyPlaying(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CurrentTrack and nil error while calling SetCurrentlyPlaying. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveSetCurrentlyPlayingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCurrentlyPlaying")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetCurrentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CurrentTrack
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.SetCurrentlyPlaying(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CurrentTrack and nil error while calling SetCurrentlyPlaying. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveAddTrack(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddTrackJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddTrackProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveAddTrackJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddTrack")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddTrackRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Track
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.AddTrack(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Track and nil error while calling AddTrack. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveAddTrackProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddTrack")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddTrackRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Track
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.AddTrack(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Track and nil error while calling AddTrack. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetTrack(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTrackJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTrackProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetTrackJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTrack")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTrackRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TrackV2
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetTrack(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TrackV2 and nil error while calling GetTrack. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetTrackProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTrack")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTrackRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TrackV2
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetTrack(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TrackV2 and nil error while calling GetTrack. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetTrackByTitleset(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTrackByTitlesetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTrackByTitlesetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetTrackByTitlesetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTrackByTitleset")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTrackRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TrackV2
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetTrackByTitleset(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TrackV2 and nil error while calling GetTrackByTitleset. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetTrackByTitlesetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTrackByTitleset")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTrackRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TrackV2
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetTrackByTitleset(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TrackV2 and nil error while calling GetTrackByTitleset. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetStations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetStationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stations
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetStations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stations and nil error while calling GetStations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetStationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stations
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetStations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stations and nil error while calling GetStations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetStationCreateQueue(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStationCreateQueueJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStationCreateQueueProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetStationCreateQueueJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStationCreateQueue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetWithASINRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Station
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetStationCreateQueue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Station and nil error while calling GetStationCreateQueue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetStationCreateQueueProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStationCreateQueue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetWithASINRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Station
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetStationCreateQueue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Station and nil error while calling GetStationCreateQueue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetNextStationTracks(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetNextStationTracksJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetNextStationTracksProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetNextStationTracksJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetNextStationTracks")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetNextStationTrackRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Station
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetNextStationTracks(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Station and nil error while calling GetNextStationTracks. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetNextStationTracksProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetNextStationTracks")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetNextStationTrackRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Station
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetNextStationTracks(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Station and nil error while calling GetNextStationTracks. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetLinkFireData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLinkFireDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLinkFireDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetLinkFireDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkFireData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LinkFireRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LinkFireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetLinkFireData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LinkFireResponse and nil error while calling GetLinkFireData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetLinkFireDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkFireData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(LinkFireRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LinkFireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetLinkFireData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LinkFireResponse and nil error while calling GetLinkFireData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetRumbaConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRumbaConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRumbaConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRadioJetSetServer) serveGetRumbaConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRumbaConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RumbaRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RumbaResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetRumbaConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RumbaResponse and nil error while calling GetRumbaConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) serveGetRumbaConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRumbaConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RumbaRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RumbaResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRadioJetSet.GetRumbaConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RumbaResponse and nil error while calling GetRumbaConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRadioJetSetServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchRadioJetSetServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchRadioJetSetServer) PathPrefix() string {
	return TwitchRadioJetSetPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2251 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x59, 0x4d, 0x73, 0x1b, 0x49,
	0xf9, 0xcf, 0xe8, 0x5d, 0x8f, 0x1c, 0x7b, 0xd2, 0x9b, 0xff, 0xfe, 0xa7, 0x5c, 0xa9, 0xc5, 0x35,
	0x45, 0x2d, 0xc6, 0x49, 0x1c, 0xd6, 0x0b, 0x5c, 0x58, 0x6a, 0xa3, 0x58, 0xb2, 0xa3, 0x8d, 0x90,
	0xbc, 0x23, 0x25, 0x29, 0xa8, 0xad, 0xda, 0x1a, 0xcd, 0xb4, 0x95, 0xde, 0x8c, 0x66, 0x44, 0x77,
	0x8f, 0x13, 0x53, 0x70, 0xe0, 0xc8, 0x05, 0x0e, 0x70, 0xa1, 0x8a, 0x4f, 0xb0, 0x55, 0xdc, 0x39,
	0x02, 0x1f, 0x81, 0x1b, 0x37, 0x38, 0xf3, 0x21, 0xa0, 0xfa, 0x65, 0x5e, 0x24, 0x79, 0xa3, 0xb1,
	0x9d, 0xe5, 0xc0, 0xc5, 0x9e, 0xfe, 0xcd, 0x3c, 0xfd, 0xbc, 0x3f, 0xfd, 0x3c, 0x2d, 0xf8, 0xbe,
	0x17, 0xf9, 0x78, 0xff, 0x8b, 0x98, 0x71, 0x12, 0xee, 0xf3, 0xb3, 0x07, 0xee, 0xec, 0x67, 0xe1,
	0x83, 0xf1, 0x2b, 0xc2, 0xbd, 0x17, 0x8e, 0xeb, 0x93, 0xe8, 0x13, 0xcc, 0x47, 0x98, 0x8f, 0x5f,
	0x11, 0x3a, 0x7f, 0xc0, 0xc5, 0xdf, 0xfd, 0x39, 0x8d, 0x78, 0x84, 0xbe, 0xc1, 0xe5, 0x37, 0xfb,
	0xa7, 0x71, 0xc0, 0xa3, 0x70, 0x5f, 0xad, 0xa8, 0xa0, 0xf8, 0x02, 0x73, 0x86, 0xb9, 0xfd, 0x19,
	0xd4, 0xda, 0x94, 0x13, 0xc6, 0x11, 0x82, 0x8a, 0xcb, 0x48, 0x68, 0x19, 0x3b, 0xc6, 0x6e, 0xd3,
	0x91, 0xcf, 0x02, 0x0b, 0xdd, 0x19, 0xb6, 0x4a, 0x0a, 0x13, 0xcf, 0x68, 0x0f, 0x4c, 0x8f, 0x62,
	0x97, 0x47, 0xf4, 0xf0, 0x85, 0x1b, 0x86, 0x38, 0xe8, 0x75, 0xac, 0xb2, 0x7c, 0xbf, 0x82, 0xdb,
	0x4f, 0xa0, 0xda, 0x0e, 0x26, 0xf1, 0xac, 0xf0, 0xe6, 0xdb, 0xd0, 0x20, 0x33, 0x77, 0x8a, 0x9f,
	0x3a, 0x7d, 0xbd, 0x69, 0xba, 0xb6, 0xff, 0x5c, 0x82, 0xea, 0x98, 0xba, 0xde, 0x4b, 0xd4, 0x86,
	0xba, 0x2b, 0x85, 0x66, 0x96, 0xb1, 0x53, 0xde, 0x6d, 0x1d, 0x7c, 0x6b, 0x7f, 0x8d, 0x9e, 0xfb,
	0x4a, 0x49, 0x27, 0xa1, 0x4b, 0x05, 0x2a, 0xe5, 0x04, 0xda, 0x86, 0x86, 0x1f, 0x53, 0x97, 0x93,
	0x28, 0x94, 0xcc, 0xab, 0x4e, 0xba, 0x46, 0xdf, 0x84, 0x9b, 0x2c, 0x9e, 0x30, 0x8f, 0x92, 0xb9,
	0x58, 0x33, 0xab, 0xb2, 0x53, 0xde, 0x6d, 0x3a, 0x8b, 0x20, 0xba, 0x0d, 0x55, 0x4e, 0x78, 0x80,
	0xad, 0xaa, 0xdc, 0x56, 0x2d, 0xd0, 0x0e, 0xb4, 0xb8, 0x90, 0x7b, 0x10, 0xcf, 0x26, 0x98, 0x5a,
	0x35, 0xb9, 0x75, 0x1e, 0x42, 0x1f, 0x41, 0xd5, 0x15, 0x76, 0xb2, 0xea, 0x3b, 0xc6, 0x6e, 0xeb,
	0xe0, 0xfd, 0xf5, 0xea, 0x88, 0xaf, 0x1d, 0x45, 0x24, 0x74, 0x21, 0x8c, 0x7a, 0x56, 0x43, 0xe9,
	0x22, 0x9e, 0x85, 0x24, 0x53, 0x1c, 0x52, 0x6c, 0x35, 0x95, 0x24, 0x72, 0x61, 0xff, 0xbd, 0x0c,
	0x75, 0x69, 0xc2, 0x67, 0x07, 0xc8, 0x86, 0x0d, 0x29, 0x1e, 0xc3, 0xbc, 0x9d, 0xb9, 0x66, 0x01,
	0xbb, 0xd0, 0x4a, 0x1f, 0x41, 0x55, 0x8a, 0x2e, 0x4d, 0x54, 0x44, 0x56, 0xc9, 0xd0, 0x51, 0x44,
	0x42, 0x2e, 0xc2, 0x06, 0xf8, 0x95, 0x55, 0xd9, 0x31, 0x76, 0x1b, 0x8e, 0x5a, 0xa0, 0xf7, 0x00,
	0x08, 0x3b, 0xc2, 0x2e, 0x8f, 0x29, 0xf6, 0xa5, 0xf1, 0x1a, 0x4e, 0x0e, 0x11, 0x72, 0x70, 0x77,
	0xca, 0xac, 0x9a, 0x34, 0xba, 0x7c, 0x46, 0x77, 0xa0, 0x49, 0x58, 0x37, 0x74, 0x27, 0x01, 0xf6,
	0xa5, 0xdd, 0x1a, 0x4e, 0x06, 0x88, 0x1d, 0xcf, 0x08, 0x23, 0x13, 0x12, 0x10, 0x7e, 0xae, 0x2d,
	0x93, 0x43, 0x04, 0xf5, 0x3c, 0x9e, 0x8c, 0xb8, 0xcb, 0x63, 0xa6, 0x6d, 0x94, 0x01, 0x4a, 0x9e,
	0x6e, 0x40, 0xa6, 0x64, 0x12, 0x60, 0x0b, 0x12, 0x79, 0x12, 0x44, 0x68, 0x11, 0xb8, 0x13, 0x1c,
	0x58, 0x2d, 0x65, 0x5d, 0xb9, 0x90, 0x3c, 0x71, 0xe8, 0x47, 0xf4, 0x30, 0xf2, 0xb1, 0xb5, 0xa1,
	0x79, 0xa6, 0x48, 0xf6, 0x7e, 0x20, 0xc2, 0xfe, 0x66, 0xfe, 0xbd, 0x40, 0xc4, 0x7b, 0xc6, 0x29,
	0xc6, 0xbc, 0xe3, 0x72, 0x6c, 0x6d, 0xee, 0x18, 0xbb, 0x65, 0x27, 0x87, 0x08, 0x99, 0x39, 0xa6,
	0x94, 0xf0, 0x88, 0x9e, 0x5b, 0x5b, 0x4a, 0xe6, 0x14, 0xb0, 0xff, 0x50, 0x86, 0xc6, 0x49, 0xe0,
	0x9e, 0x07, 0x22, 0x99, 0xd3, 0x40, 0x34, 0xf2, 0x81, 0x78, 0x91, 0x3b, 0x37, 0xa1, 0x44, 0x7c,
	0x9d, 0x6b, 0x25, 0xe2, 0x2f, 0x64, 0x60, 0x65, 0x31, 0x03, 0x51, 0x1f, 0x6e, 0x7a, 0x2e, 0x77,
	0x83, 0x68, 0x2a, 0x7d, 0xca, 0xac, 0xaa, 0xcc, 0xbe, 0xa2, 0x21, 0xb0, 0x48, 0xbc, 0xe4, 0xf4,
	0xda, 0x8a, 0xd3, 0x77, 0xa0, 0xe5, 0xe3, 0x34, 0xb9, 0xa4, 0x8b, 0x9b, 0x4e, 0x1e, 0x42, 0x16,
	0xd4, 0x3d, 0x91, 0xa0, 0x11, 0xd5, 0x1e, 0x4e, 0x96, 0xda, 0x81, 0xaf, 0xe7, 0x01, 0xf1, 0x08,
	0x97, 0xfe, 0x55, 0x0e, 0xd4, 0x88, 0xd4, 0x92, 0x9d, 0xc4, 0x93, 0x80, 0x78, 0xda, 0xbd, 0xe9,
	0x5a, 0x05, 0xd6, 0x33, 0x11, 0x2a, 0x01, 0x96, 0x0e, 0x96, 0x81, 0xa5, 0x01, 0xf1, 0x96, 0x45,
	0x94, 0x0f, 0xa9, 0x8f, 0xa9, 0xf4, 0x71, 0xd5, 0xc9, 0x00, 0x29, 0x91, 0x1b, 0x76, 0x7d, 0xc2,
	0xa5, 0x7f, 0x1b, 0x4e, 0xb2, 0xb4, 0xc7, 0xd0, 0x4c, 0xbc, 0xc3, 0xd0, 0x31, 0x34, 0xe7, 0xc9,
	0x42, 0x97, 0xb0, 0x6f, 0xaf, 0x35, 0x62, 0x42, 0xee, 0x64, 0xb4, 0xf6, 0xdf, 0x0c, 0x68, 0x3c,
	0x65, 0x98, 0xf6, 0xc2, 0xd3, 0x48, 0x28, 0xed, 0xc5, 0x8c, 0x47, 0x33, 0x4c, 0x7b, 0x1d, 0xed,
	0xf9, 0x1c, 0x22, 0xde, 0xfb, 0xf8, 0x8c, 0x78, 0x78, 0x7c, 0x3e, 0x4f, 0xca, 0x6e, 0x0e, 0x91,
	0xf5, 0x4f, 0xae, 0xd2, 0x8a, 0x9e, 0xae, 0xd1, 0xfb, 0xb0, 0x39, 0x8b, 0x19, 0xf1, 0xc6, 0x69,
	0x00, 0xaa, 0xe0, 0x58, 0x42, 0x85, 0xd3, 0x5c, 0xcf, 0xc3, 0x8c, 0x8d, 0xa3, 0x97, 0x38, 0xd4,
	0x75, 0x30, 0x0f, 0xc9, 0x6a, 0x28, 0x1e, 0xba, 0xaf, 0xe7, 0x84, 0x9e, 0x4b, 0xbf, 0x97, 0x9d,
	0x3c, 0x64, 0xff, 0xb1, 0x04, 0x35, 0x07, 0x7b, 0x38, 0xe4, 0xe8, 0x5d, 0xa8, 0xc5, 0x2c, 0xa7,
	0x8e, 0x5e, 0x5d, 0x18, 0xc9, 0x03, 0x68, 0x79, 0x51, 0xc8, 0x71, 0xc8, 0xa5, 0x7e, 0x42, 0x83,
	0xcd, 0x83, 0x7b, 0x6b, 0xcd, 0x7a, 0x98, 0xd1, 0x38, 0xf9, 0x0d, 0x84, 0xa7, 0xe3, 0xb9, 0xef,
	0x72, 0xec, 0xb7, 0xb9, 0xd4, 0xb6, 0xec, 0x64, 0x00, 0xea, 0x42, 0x23, 0x71, 0x83, 0xd4, 0xf2,
	0x52, 0x1e, 0x4c, 0x49, 0xd1, 0x23, 0xa8, 0x33, 0xae, 0x8e, 0x9c, 0x9a, 0xdc, 0x65, 0x77, 0xed,
	0x2e, 0x23, 0xf5, 0xbd, 0x93, 0x10, 0xda, 0x7d, 0xa8, 0x2b, 0x73, 0x31, 0x71, 0x32, 0x52, 0xf5,
	0x58, 0xf8, 0x64, 0x54, 0xa4, 0x4e, 0x42, 0x67, 0xff, 0xc3, 0x80, 0xda, 0x28, 0x8a, 0xa9, 0x87,
	0x75, 0x6d, 0x30, 0xd2, 0xda, 0xb0, 0x64, 0xe1, 0xd2, 0x75, 0x2d, 0x9c, 0x56, 0xa9, 0x72, 0xbe,
	0x4a, 0xbd, 0xa9, 0x02, 0x89, 0x63, 0x38, 0x8a, 0x43, 0x5f, 0x1e, 0x26, 0xe2, 0x03, 0x15, 0x60,
	0x8b, 0xa0, 0x2c, 0xa4, 0xf3, 0x88, 0x93, 0xd3, 0x73, 0xf1, 0x49, 0x4d, 0x05, 0x7a, 0x86, 0xd8,
	0x7f, 0x31, 0xc0, 0x3c, 0x8c, 0x29, 0xc5, 0x21, 0x0f, 0xce, 0x85, 0x53, 0x48, 0x38, 0xcd, 0xce,
	0x35, 0xe3, 0x2a, 0xe7, 0xda, 0x3e, 0xa0, 0x1e, 0x5b, 0xde, 0x53, 0x5a, 0xa8, 0xe1, 0x5c, 0xf0,
	0x06, 0x7d, 0x0c, 0x35, 0x26, 0x8d, 0xac, 0x8f, 0xd1, 0xf5, 0x7e, 0x52, 0x3e, 0x71, 0x34, 0x99,
	0x7d, 0x0f, 0x36, 0xf4, 0xa6, 0xaa, 0x27, 0xba, 0x03, 0xcd, 0x1e, 0x1b, 0xc5, 0x32, 0xd1, 0xa4,
	0x0a, 0x0d, 0x27, 0x03, 0xec, 0xcf, 0x00, 0x1d, 0x63, 0xfe, 0x9c, 0xf0, 0x17, 0xed, 0x51, 0x6f,
	0xe0, 0xe0, 0x9f, 0xc6, 0x98, 0x7d, 0x75, 0x76, 0x6d, 0x43, 0x23, 0x88, 0x3c, 0x15, 0x95, 0x2a,
	0xc3, 0xd2, 0x75, 0x9a, 0x79, 0xe5, 0x2c, 0xf3, 0xec, 0x87, 0x00, 0xc7, 0x98, 0x5f, 0x63, 0x57,
	0xfb, 0x4f, 0x06, 0xbc, 0x73, 0x8c, 0x79, 0x5a, 0x21, 0x73, 0x7b, 0x79, 0x31, 0x65, 0x11, 0x4d,
	0xf6, 0x52, 0x2b, 0x61, 0xbe, 0x53, 0x12, 0x70, 0x4c, 0x75, 0x10, 0xae, 0x37, 0xdf, 0x91, 0xfc,
	0xdc, 0xd1, 0x64, 0xf2, 0x04, 0x27, 0x33, 0xc2, 0xa5, 0x1e, 0x65, 0x47, 0x2d, 0x16, 0x44, 0xac,
	0x2c, 0x29, 0x9e, 0xa9, 0x55, 0xcd, 0xab, 0x65, 0x7f, 0x69, 0xc0, 0xf6, 0x31, 0xe6, 0x03, 0xfc,
	0x9a, 0xeb, 0xcc, 0x54, 0x81, 0xf1, 0x76, 0x6d, 0x2c, 0x1b, 0x16, 0x77, 0x8a, 0x55, 0x59, 0xad,
	0xe8, 0x86, 0x25, 0x01, 0x44, 0x79, 0x0e, 0x65, 0x2b, 0x39, 0x3c, 0x4d, 0x8f, 0x66, 0x71, 0x34,
	0x2d, 0xa1, 0xf6, 0xaf, 0x0d, 0x30, 0xdb, 0xbe, 0xaf, 0x73, 0x7e, 0x8d, 0x88, 0xff, 0x85, 0x22,
	0x6b, 0x9f, 0x83, 0x29, 0x43, 0xa7, 0x88, 0x3c, 0x3f, 0x5a, 0x72, 0xfa, 0xf7, 0x0a, 0xd6, 0x36,
	0x95, 0x75, 0xd8, 0x5f, 0x0c, 0x01, 0xfb, 0x9f, 0x06, 0xdc, 0x1a, 0x61, 0xae, 0xb3, 0x68, 0x1d,
	0x73, 0x0b, 0xea, 0x32, 0xd3, 0x7b, 0x1d, 0x6d, 0x8f, 0x64, 0x29, 0x3c, 0xa9, 0x72, 0x32, 0x3b,
	0x36, 0x93, 0xb5, 0x28, 0x0b, 0x64, 0xb5, 0x2c, 0xa8, 0xde, 0xf7, 0x82, 0x37, 0xcb, 0xe6, 0xad,
	0x5e, 0xd7, 0xbc, 0x77, 0xe1, 0xd6, 0x71, 0x51, 0x15, 0xed, 0x5f, 0x19, 0xb0, 0xd5, 0xf6, 0xfd,
	0x85, 0xf0, 0xcd, 0xa9, 0x6d, 0x2c, 0xaa, 0xfd, 0x1e, 0x40, 0x72, 0x8a, 0xa5, 0x36, 0xc9, 0x21,
	0xd7, 0x9b, 0x13, 0xec, 0xdf, 0x18, 0x70, 0x2b, 0x91, 0xe5, 0xd9, 0xc1, 0x7a, 0x69, 0x96, 0xa7,
	0x99, 0xd2, 0x05, 0xd3, 0xcc, 0xf5, 0x24, 0x1a, 0xc2, 0xd6, 0x31, 0xe6, 0x05, 0x8d, 0x53, 0x40,
	0x1c, 0xfb, 0x5f, 0x06, 0xd4, 0x75, 0xc5, 0xf8, 0x9a, 0xfa, 0xf5, 0x85, 0x9a, 0x51, 0x5b, 0xae,
	0x19, 0x2b, 0xdd, 0x7c, 0xfd, 0xed, 0x75, 0xf3, 0x8d, 0xe5, 0x6e, 0xde, 0x3e, 0x81, 0x86, 0x56,
	0x96, 0xa1, 0x0e, 0x34, 0x74, 0xef, 0x92, 0xb4, 0x29, 0xc5, 0xbb, 0x9e, 0x94, 0xd2, 0xfe, 0xad,
	0x01, 0x5b, 0x7d, 0x12, 0xbe, 0x3c, 0x22, 0x14, 0x5f, 0xa5, 0x94, 0x89, 0x0a, 0xec, 0x86, 0xd3,
	0xd8, 0x9d, 0x26, 0x0d, 0x48, 0xba, 0x7e, 0xe3, 0x41, 0x70, 0x07, 0x9a, 0x5e, 0x7a, 0xf3, 0xa1,
	0xce, 0x82, 0x0c, 0xb0, 0x3f, 0x80, 0x56, 0xcf, 0x8b, 0xc2, 0xa3, 0x88, 0xce, 0x5c, 0xce, 0x90,
	0x09, 0x65, 0x76, 0x36, 0xd5, 0xd2, 0x88, 0x47, 0x81, 0xcc, 0x75, 0x6b, 0xd0, 0x74, 0xc4, 0xa3,
	0xfd, 0x7b, 0x03, 0x9a, 0x82, 0x66, 0xfc, 0x02, 0xcf, 0x30, 0xea, 0x40, 0x2d, 0x0a, 0x3b, 0x2e,
	0x4d, 0x1a, 0x91, 0xf5, 0xd9, 0x9f, 0xe3, 0xe7, 0x68, 0x5a, 0x74, 0x04, 0xf5, 0x28, 0xec, 0x93,
	0xe9, 0x0b, 0x2e, 0x39, 0x5d, 0x76, 0x9b, 0x84, 0xd8, 0xfe, 0x65, 0x19, 0x36, 0x12, 0x23, 0x7f,
	0x32, 0x1a, 0x0e, 0xd0, 0x43, 0xa8, 0x10, 0x2f, 0x0a, 0xaf, 0x24, 0x9c, 0xa4, 0x14, 0x91, 0x32,
	0x89, 0x39, 0x8f, 0xc2, 0x31, 0x7e, 0xcd, 0x93, 0xc2, 0x91, 0x21, 0xc2, 0x57, 0xd4, 0x0d, 0x5f,
	0xea, 0x2b, 0x18, 0xf9, 0x9c, 0xe5, 0x47, 0x25, 0x9f, 0x1f, 0x26, 0x94, 0x63, 0x1a, 0x68, 0x1f,
	0x88, 0x47, 0xd4, 0x81, 0xba, 0xe0, 0x91, 0xb4, 0x7d, 0xad, 0x83, 0xbd, 0x42, 0x02, 0x4a, 0xcb,
	0x3b, 0x09, 0x29, 0x7a, 0x02, 0xe0, 0x7a, 0xf2, 0x24, 0x17, 0x45, 0xb8, 0x2e, 0x8b, 0xf0, 0xdd,
	0xf5, 0x77, 0x32, 0x29, 0x89, 0x93, 0x23, 0x17, 0xea, 0xca, 0xaa, 0x40, 0xc2, 0x69, 0xaf, 0x93,
	0xdc, 0x44, 0x64, 0x88, 0x98, 0x87, 0x18, 0xa6, 0x62, 0xcc, 0x92, 0xd7, 0x02, 0xea, 0x2e, 0x22,
	0x0f, 0xd9, 0x18, 0xcc, 0x2c, 0xce, 0xd9, 0x3c, 0x0a, 0x19, 0x46, 0x9f, 0xc2, 0x46, 0xa0, 0xb1,
	0x8e, 0xcb, 0x5d, 0x9d, 0x46, 0xf7, 0xd7, 0x0a, 0x99, 0xf7, 0xa5, 0xb3, 0xb0, 0x85, 0xfd, 0xd7,
	0x12, 0xbc, 0x2b, 0xce, 0x43, 0x75, 0x7c, 0x74, 0x29, 0x8d, 0xe8, 0x55, 0xd2, 0xea, 0x31, 0x34,
	0xc4, 0xff, 0x2b, 0xb7, 0x07, 0x29, 0xf5, 0xc2, 0xc1, 0x5a, 0x59, 0x3a, 0x58, 0xfb, 0x00, 0xea,
	0xf9, 0xca, 0xe7, 0x64, 0x8e, 0x1e, 0xed, 0x81, 0x89, 0x85, 0xbe, 0x9d, 0xdc, 0x7d, 0x83, 0xaa,
	0x97, 0x2b, 0xb8, 0x48, 0x7f, 0x89, 0xa5, 0xb1, 0xd1, 0x74, 0x32, 0xc0, 0xfe, 0xb7, 0x01, 0xff,
	0xbf, 0x62, 0x44, 0xed, 0xb3, 0x37, 0xb6, 0xe8, 0xff, 0x2b, 0xb6, 0xb4, 0x27, 0x70, 0xdb, 0x89,
	0x67, 0x13, 0x57, 0xc4, 0x14, 0xe3, 0x11, 0xc5, 0x87, 0x51, 0x78, 0x4a, 0xa6, 0x22, 0xce, 0x29,
	0x56, 0xdf, 0xb5, 0x9d, 0x81, 0x0e, 0xa4, 0x3c, 0x84, 0x76, 0x61, 0x4b, 0xc5, 0xd5, 0x11, 0xc1,
	0x81, 0x3f, 0xc8, 0xee, 0x86, 0x97, 0x61, 0x7b, 0x13, 0x36, 0x24, 0x0f, 0x1d, 0x9f, 0xf6, 0xef,
	0x0c, 0xb8, 0xa9, 0x01, 0x6d, 0xeb, 0xa5, 0xac, 0x32, 0x56, 0xb2, 0x0a, 0xb9, 0x60, 0xfa, 0x8b,
	0x22, 0x32, 0xab, 0x2c, 0xb3, 0xa8, 0x40, 0x5f, 0x79, 0x81, 0x82, 0xce, 0xca, 0x76, 0x7b, 0x0f,
	0xa1, 0x95, 0xb3, 0x12, 0x6a, 0x41, 0xfd, 0xe9, 0xe0, 0xc9, 0x60, 0xf8, 0x7c, 0x60, 0xde, 0x40,
	0x1b, 0xd0, 0x38, 0xe9, 0xb7, 0x7f, 0xdc, 0xef, 0x8d, 0xc6, 0xa6, 0x21, 0x5e, 0x8d, 0xc6, 0xed,
	0x71, 0x6f, 0x38, 0x30, 0x4b, 0xa8, 0x09, 0xd5, 0xb1, 0xd3, 0x3e, 0x7c, 0x62, 0x96, 0xf7, 0x3e,
	0x86, 0x9a, 0xea, 0x5a, 0x51, 0x1d, 0xca, 0xed, 0x7e, 0x5f, 0x11, 0x1e, 0x75, 0xdb, 0xe3, 0xa7,
	0x4e, 0xb7, 0x63, 0x1a, 0x02, 0x1e, 0x0f, 0x4f, 0x14, 0xd1, 0xf0, 0xf9, 0xa0, 0xdb, 0x31, 0xcb,
	0x08, 0xa0, 0x76, 0xf2, 0xf4, 0x51, 0xbf, 0x77, 0x68, 0x56, 0xf6, 0x7e, 0x08, 0xb7, 0x2f, 0x6a,
	0x82, 0xd1, 0x16, 0xb4, 0xda, 0xfd, 0xfe, 0xe7, 0x4e, 0xf7, 0xb0, 0x3b, 0x18, 0x8f, 0xcc, 0x1b,
	0xe8, 0x36, 0x98, 0x6a, 0xf1, 0x79, 0x22, 0xd6, 0xc8, 0x34, 0xf6, 0x3a, 0x00, 0x59, 0x59, 0x13,
	0xac, 0x3b, 0xc3, 0xe7, 0x83, 0xfe, 0xb0, 0xdd, 0x31, 0x6f, 0xa0, 0x06, 0x54, 0x8e, 0x87, 0xe3,
	0xa1, 0x69, 0x48, 0xde, 0xe3, 0xc7, 0x5d, 0xc7, 0x2c, 0x09, 0x50, 0xd0, 0x9b, 0x65, 0x01, 0x3e,
	0x6f, 0x8f, 0x0f, 0x1f, 0x9b, 0x95, 0x83, 0x2f, 0x37, 0xe1, 0xd6, 0xca, 0x8f, 0x15, 0x68, 0x06,
	0xad, 0xdc, 0xc8, 0x87, 0x3e, 0x5c, 0x6b, 0xf5, 0xd5, 0x09, 0x76, 0xbb, 0xf8, 0x9d, 0x0b, 0x9a,
	0xc2, 0x46, 0x7e, 0xc2, 0x44, 0x77, 0x8b, 0xf0, 0x4b, 0xf8, 0xec, 0x15, 0xe6, 0xc3, 0x10, 0x97,
	0x23, 0xcd, 0xa3, 0x38, 0x78, 0x99, 0x61, 0xdf, 0x2d, 0xc2, 0x6c, 0x79, 0xfa, 0xbd, 0x14, 0x57,
	0x2c, 0xad, 0x99, 0xde, 0x05, 0x5e, 0x4a, 0xbb, 0xf5, 0x56, 0x4c, 0xf7, 0x8d, 0x64, 0x5b, 0xbe,
	0x18, 0x52, 0xe8, 0x83, 0xf5, 0x67, 0xe3, 0xd2, 0xcc, 0xb9, 0x5d, 0xf4, 0x5e, 0x0a, 0xcd, 0xe5,
	0x04, 0x73, 0x69, 0x86, 0xcb, 0x43, 0xe5, 0xf6, 0x6e, 0x41, 0x86, 0x0c, 0xfd, 0x5c, 0x5e, 0x45,
	0xac, 0x8c, 0x66, 0x07, 0x45, 0x78, 0x2e, 0x4e, 0x5a, 0xdb, 0xeb, 0xe5, 0x5c, 0x61, 0xf3, 0x1a,
	0xde, 0x19, 0x5d, 0x89, 0xfb, 0xca, 0x28, 0xbb, 0x7d, 0xbf, 0x28, 0x77, 0x75, 0x83, 0xe4, 0x43,
	0x23, 0x99, 0xb8, 0xd0, 0x77, 0x8a, 0x78, 0x34, 0x3f, 0x0b, 0x6d, 0x17, 0x1c, 0x1b, 0xd0, 0x29,
	0x34, 0x92, 0x31, 0xaa, 0x00, 0x97, 0xa5, 0x89, 0xab, 0x80, 0x17, 0x93, 0x9f, 0xb7, 0xe6, 0xf2,
	0xc6, 0x4b, 0xae, 0x1e, 0x9d, 0x8f, 0xf5, 0xdc, 0xf5, 0xb5, 0x72, 0x54, 0x19, 0x98, 0x0e, 0x39,
	0x6f, 0x39, 0x03, 0xd3, 0x7d, 0xcf, 0xe0, 0xff, 0x32, 0x36, 0x87, 0x14, 0xbb, 0x1c, 0x7f, 0x1a,
	0xe3, 0x18, 0x5f, 0xad, 0x80, 0x16, 0x1e, 0xbc, 0xd0, 0x2f, 0xe0, 0xf6, 0x05, 0xd7, 0x5c, 0x0c,
	0xfd, 0xa0, 0x08, 0xdb, 0xaf, 0xb8, 0x1d, 0xbb, 0x04, 0xfb, 0x33, 0x39, 0x7e, 0xf7, 0x73, 0x0d,
	0x6b, 0x01, 0x67, 0x2e, 0x8d, 0x87, 0x05, 0xf2, 0x71, 0xa5, 0xd1, 0x8e, 0x60, 0x53, 0xf8, 0x49,
	0x1c, 0xf8, 0xba, 0x91, 0xb9, 0x5f, 0xac, 0x3d, 0x48, 0x78, 0xee, 0x17, 0xfd, 0x5c, 0x31, 0x7c,
	0x74, 0xef, 0x27, 0x7b, 0xc5, 0x7f, 0xec, 0x9f, 0xd4, 0xe4, 0xef, 0xfc, 0x1f, 0xfe, 0x27, 0x00,
	0x00, 0xff, 0xff, 0x8d, 0x42, 0xef, 0x2f, 0x21, 0x20, 0x00, 0x00,
}
