// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchRaidsTwirp/twirp.proto

/*
Package TwitchRaidsTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchRaidsTwirp/twirp.proto
*/
package TwitchRaidsTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================
// TwitchRaids Interface
// =====================

type TwitchRaids interface {
	// Ends a raid.
	CancelRaidBySourceID(context.Context, *CancelRaidBySourceIDRequest) (*CancelRaidBySourceIDResponse, error)

	// Creates a PENDING raid that starts on the given channel, and will end on
	// the given target channel.
	CreateRaid(context.Context, *CreateRaidRequest) (*CreateRaidResponse, error)

	// Returns whether a user recently participated in a raid.
	DidUserRecentlyRaidChannel(context.Context, *DidUserRecentlyRaidChannelRequest) (*DidUserRecentlyRaidChannelResponse, error)

	// Gets the viewers and creators that participated in a given raid.
	GetRaidParticipants(context.Context, *GetRaidParticipantsRequest) (*GetRaidParticipantsResponse, error)

	// Gets a user's raid settings.
	GetRaidSettings(context.Context, *GetRaidSettingsRequest) (*GetRaidSettingsResponse, error)

	// Gets channels that we recommend a given user should raid.
	GetRaidTargetRecommendations(context.Context, *GetRaidTargetRecommendationsRequest) (*GetRaidTargetRecommendationsResponse, error)

	// Gets the raids that have recently targeted the given channel.
	GetRecentRaids(context.Context, *GetRecentRaidsRequest) (*GetRecentRaidsResponse, error)

	// Returns whether a specified raid is currently active. A raid is active once it has been initiated
	// and considered not active when deleted (by TTL)
	IsRaidValid(context.Context, *IsRaidValidRequest) (*IsRaidValidResponse, error)

	// Starts a READY raid (redirecting participants to the target's channel page.)
	StartRaidBySourceID(context.Context, *StartRaidBySourceIDRequest) (*StartRaidBySourceIDResponse, error)

	// Records that the given user is participating in the given raid.
	// (Raid participants should get channel points, and should not get ads when they load the target's channel page.)
	JoinRaid(context.Context, *JoinRaidRequest) (*JoinRaidResponse, error)

	// Removes the given user from the given raid's participants.
	LeaveRaid(context.Context, *LeaveRaidRequest) (*LeaveRaidResponse, error)

	// Updates a user's raid settings.
	UpdateRaidSettings(context.Context, *UpdateRaidSettingsRequest) (*UpdateRaidSettingsResponse, error)
}

// ===========================
// TwitchRaids Protobuf Client
// ===========================

type twitchRaidsProtobufClient struct {
	client HTTPClient
	urls   [12]string
	opts   twirp.ClientOptions
}

// NewTwitchRaidsProtobufClient creates a Protobuf client that implements the TwitchRaids interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchRaidsProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchRaids {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchRaidsPathPrefix
	urls := [12]string{
		prefix + "CancelRaidBySourceID",
		prefix + "CreateRaid",
		prefix + "DidUserRecentlyRaidChannel",
		prefix + "GetRaidParticipants",
		prefix + "GetRaidSettings",
		prefix + "GetRaidTargetRecommendations",
		prefix + "GetRecentRaids",
		prefix + "IsRaidValid",
		prefix + "StartRaidBySourceID",
		prefix + "JoinRaid",
		prefix + "LeaveRaid",
		prefix + "UpdateRaidSettings",
	}

	return &twitchRaidsProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchRaidsProtobufClient) CancelRaidBySourceID(ctx context.Context, in *CancelRaidBySourceIDRequest) (*CancelRaidBySourceIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "CancelRaidBySourceID")
	out := new(CancelRaidBySourceIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) CreateRaid(ctx context.Context, in *CreateRaidRequest) (*CreateRaidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRaid")
	out := new(CreateRaidResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) DidUserRecentlyRaidChannel(ctx context.Context, in *DidUserRecentlyRaidChannelRequest) (*DidUserRecentlyRaidChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "DidUserRecentlyRaidChannel")
	out := new(DidUserRecentlyRaidChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) GetRaidParticipants(ctx context.Context, in *GetRaidParticipantsRequest) (*GetRaidParticipantsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidParticipants")
	out := new(GetRaidParticipantsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) GetRaidSettings(ctx context.Context, in *GetRaidSettingsRequest) (*GetRaidSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidSettings")
	out := new(GetRaidSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) GetRaidTargetRecommendations(ctx context.Context, in *GetRaidTargetRecommendationsRequest) (*GetRaidTargetRecommendationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidTargetRecommendations")
	out := new(GetRaidTargetRecommendationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) GetRecentRaids(ctx context.Context, in *GetRecentRaidsRequest) (*GetRecentRaidsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentRaids")
	out := new(GetRecentRaidsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) IsRaidValid(ctx context.Context, in *IsRaidValidRequest) (*IsRaidValidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "IsRaidValid")
	out := new(IsRaidValidResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) StartRaidBySourceID(ctx context.Context, in *StartRaidBySourceIDRequest) (*StartRaidBySourceIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "StartRaidBySourceID")
	out := new(StartRaidBySourceIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) JoinRaid(ctx context.Context, in *JoinRaidRequest) (*JoinRaidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "JoinRaid")
	out := new(JoinRaidResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) LeaveRaid(ctx context.Context, in *LeaveRaidRequest) (*LeaveRaidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveRaid")
	out := new(LeaveRaidResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsProtobufClient) UpdateRaidSettings(ctx context.Context, in *UpdateRaidSettingsRequest) (*UpdateRaidSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRaidSettings")
	out := new(UpdateRaidSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// TwitchRaids JSON Client
// =======================

type twitchRaidsJSONClient struct {
	client HTTPClient
	urls   [12]string
	opts   twirp.ClientOptions
}

// NewTwitchRaidsJSONClient creates a JSON client that implements the TwitchRaids interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchRaidsJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchRaids {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchRaidsPathPrefix
	urls := [12]string{
		prefix + "CancelRaidBySourceID",
		prefix + "CreateRaid",
		prefix + "DidUserRecentlyRaidChannel",
		prefix + "GetRaidParticipants",
		prefix + "GetRaidSettings",
		prefix + "GetRaidTargetRecommendations",
		prefix + "GetRecentRaids",
		prefix + "IsRaidValid",
		prefix + "StartRaidBySourceID",
		prefix + "JoinRaid",
		prefix + "LeaveRaid",
		prefix + "UpdateRaidSettings",
	}

	return &twitchRaidsJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchRaidsJSONClient) CancelRaidBySourceID(ctx context.Context, in *CancelRaidBySourceIDRequest) (*CancelRaidBySourceIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "CancelRaidBySourceID")
	out := new(CancelRaidBySourceIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) CreateRaid(ctx context.Context, in *CreateRaidRequest) (*CreateRaidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRaid")
	out := new(CreateRaidResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) DidUserRecentlyRaidChannel(ctx context.Context, in *DidUserRecentlyRaidChannelRequest) (*DidUserRecentlyRaidChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "DidUserRecentlyRaidChannel")
	out := new(DidUserRecentlyRaidChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) GetRaidParticipants(ctx context.Context, in *GetRaidParticipantsRequest) (*GetRaidParticipantsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidParticipants")
	out := new(GetRaidParticipantsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) GetRaidSettings(ctx context.Context, in *GetRaidSettingsRequest) (*GetRaidSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidSettings")
	out := new(GetRaidSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) GetRaidTargetRecommendations(ctx context.Context, in *GetRaidTargetRecommendationsRequest) (*GetRaidTargetRecommendationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidTargetRecommendations")
	out := new(GetRaidTargetRecommendationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) GetRecentRaids(ctx context.Context, in *GetRecentRaidsRequest) (*GetRecentRaidsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentRaids")
	out := new(GetRecentRaidsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) IsRaidValid(ctx context.Context, in *IsRaidValidRequest) (*IsRaidValidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "IsRaidValid")
	out := new(IsRaidValidResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) StartRaidBySourceID(ctx context.Context, in *StartRaidBySourceIDRequest) (*StartRaidBySourceIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "StartRaidBySourceID")
	out := new(StartRaidBySourceIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) JoinRaid(ctx context.Context, in *JoinRaidRequest) (*JoinRaidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "JoinRaid")
	out := new(JoinRaidResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) LeaveRaid(ctx context.Context, in *LeaveRaidRequest) (*LeaveRaidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveRaid")
	out := new(LeaveRaidResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRaidsJSONClient) UpdateRaidSettings(ctx context.Context, in *UpdateRaidSettingsRequest) (*UpdateRaidSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRaidSettings")
	out := new(UpdateRaidSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// TwitchRaids Server Handler
// ==========================

type twitchRaidsServer struct {
	TwitchRaids
	hooks *twirp.ServerHooks
}

func NewTwitchRaidsServer(svc TwitchRaids, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchRaidsServer{
		TwitchRaids: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchRaidsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchRaidsPathPrefix is used for all URL paths on a twirp TwitchRaids server.
// Requests are always: POST TwitchRaidsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchRaidsPathPrefix = "/twirp/twitch.fulton.twitchraids.TwitchRaids/"

func (s *twitchRaidsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchraids")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRaids")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/CancelRaidBySourceID":
		s.serveCancelRaidBySourceID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/CreateRaid":
		s.serveCreateRaid(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/DidUserRecentlyRaidChannel":
		s.serveDidUserRecentlyRaidChannel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/GetRaidParticipants":
		s.serveGetRaidParticipants(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/GetRaidSettings":
		s.serveGetRaidSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/GetRaidTargetRecommendations":
		s.serveGetRaidTargetRecommendations(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/GetRecentRaids":
		s.serveGetRecentRaids(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/IsRaidValid":
		s.serveIsRaidValid(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/StartRaidBySourceID":
		s.serveStartRaidBySourceID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/JoinRaid":
		s.serveJoinRaid(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/LeaveRaid":
		s.serveLeaveRaid(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchraids.TwitchRaids/UpdateRaidSettings":
		s.serveUpdateRaidSettings(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchRaidsServer) serveCancelRaidBySourceID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCancelRaidBySourceIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelRaidBySourceIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveCancelRaidBySourceIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelRaidBySourceID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CancelRaidBySourceIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CancelRaidBySourceIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.CancelRaidBySourceID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelRaidBySourceIDResponse and nil error while calling CancelRaidBySourceID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveCancelRaidBySourceIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelRaidBySourceID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CancelRaidBySourceIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CancelRaidBySourceIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.CancelRaidBySourceID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelRaidBySourceIDResponse and nil error while calling CancelRaidBySourceID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveCreateRaid(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRaidJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRaidProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveCreateRaidJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRaid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRaidRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateRaidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.CreateRaid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRaidResponse and nil error while calling CreateRaid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveCreateRaidProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRaid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateRaidRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateRaidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.CreateRaid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRaidResponse and nil error while calling CreateRaid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveDidUserRecentlyRaidChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDidUserRecentlyRaidChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDidUserRecentlyRaidChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveDidUserRecentlyRaidChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DidUserRecentlyRaidChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DidUserRecentlyRaidChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DidUserRecentlyRaidChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.DidUserRecentlyRaidChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DidUserRecentlyRaidChannelResponse and nil error while calling DidUserRecentlyRaidChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveDidUserRecentlyRaidChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DidUserRecentlyRaidChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DidUserRecentlyRaidChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DidUserRecentlyRaidChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.DidUserRecentlyRaidChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DidUserRecentlyRaidChannelResponse and nil error while calling DidUserRecentlyRaidChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRaidParticipants(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRaidParticipantsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRaidParticipantsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveGetRaidParticipantsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidParticipants")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRaidParticipantsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRaidParticipantsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRaidParticipants(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRaidParticipantsResponse and nil error while calling GetRaidParticipants. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRaidParticipantsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidParticipants")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRaidParticipantsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRaidParticipantsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRaidParticipants(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRaidParticipantsResponse and nil error while calling GetRaidParticipants. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRaidSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRaidSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRaidSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveGetRaidSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRaidSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRaidSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRaidSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRaidSettingsResponse and nil error while calling GetRaidSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRaidSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRaidSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRaidSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRaidSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRaidSettingsResponse and nil error while calling GetRaidSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRaidTargetRecommendations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRaidTargetRecommendationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRaidTargetRecommendationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveGetRaidTargetRecommendationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidTargetRecommendations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRaidTargetRecommendationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRaidTargetRecommendationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRaidTargetRecommendations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRaidTargetRecommendationsResponse and nil error while calling GetRaidTargetRecommendations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRaidTargetRecommendationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRaidTargetRecommendations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRaidTargetRecommendationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRaidTargetRecommendationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRaidTargetRecommendations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRaidTargetRecommendationsResponse and nil error while calling GetRaidTargetRecommendations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRecentRaids(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecentRaidsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecentRaidsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveGetRecentRaidsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentRaids")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecentRaidsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecentRaidsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRecentRaids(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecentRaidsResponse and nil error while calling GetRecentRaids. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveGetRecentRaidsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentRaids")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecentRaidsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecentRaidsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.GetRecentRaids(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecentRaidsResponse and nil error while calling GetRecentRaids. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveIsRaidValid(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsRaidValidJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsRaidValidProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveIsRaidValidJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsRaidValid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsRaidValidRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsRaidValidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.IsRaidValid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsRaidValidResponse and nil error while calling IsRaidValid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveIsRaidValidProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsRaidValid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IsRaidValidRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsRaidValidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.IsRaidValid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsRaidValidResponse and nil error while calling IsRaidValid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveStartRaidBySourceID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartRaidBySourceIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartRaidBySourceIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveStartRaidBySourceIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartRaidBySourceID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StartRaidBySourceIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StartRaidBySourceIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.StartRaidBySourceID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StartRaidBySourceIDResponse and nil error while calling StartRaidBySourceID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveStartRaidBySourceIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartRaidBySourceID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StartRaidBySourceIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StartRaidBySourceIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.StartRaidBySourceID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StartRaidBySourceIDResponse and nil error while calling StartRaidBySourceID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveJoinRaid(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveJoinRaidJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveJoinRaidProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveJoinRaidJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "JoinRaid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(JoinRaidRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *JoinRaidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.JoinRaid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JoinRaidResponse and nil error while calling JoinRaid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveJoinRaidProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "JoinRaid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(JoinRaidRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *JoinRaidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.JoinRaid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JoinRaidResponse and nil error while calling JoinRaid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveLeaveRaid(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLeaveRaidJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLeaveRaidProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveLeaveRaidJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveRaid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LeaveRaidRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LeaveRaidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.LeaveRaid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveRaidResponse and nil error while calling LeaveRaid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveLeaveRaidProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveRaid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(LeaveRaidRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LeaveRaidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.LeaveRaid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveRaidResponse and nil error while calling LeaveRaid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveUpdateRaidSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRaidSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRaidSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRaidsServer) serveUpdateRaidSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRaidSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRaidSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRaidSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.UpdateRaidSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRaidSettingsResponse and nil error while calling UpdateRaidSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) serveUpdateRaidSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRaidSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateRaidSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRaidSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRaids.UpdateRaidSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRaidSettingsResponse and nil error while calling UpdateRaidSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRaidsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchRaidsServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchRaidsServer) PathPrefix() string {
	return TwitchRaidsPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1458 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0xdd, 0x6e, 0xdb, 0xc6,
	0x12, 0x3e, 0x94, 0x6c, 0xcb, 0x1a, 0x9d, 0xd8, 0xf4, 0xda, 0xf1, 0x0f, 0x9d, 0x73, 0x92, 0xc3,
	0x13, 0x34, 0x81, 0x93, 0xca, 0x89, 0x53, 0x27, 0x2d, 0xd0, 0x3f, 0x4a, 0x62, 0x0c, 0xb6, 0x0a,
	0xe9, 0x50, 0xb4, 0x0d, 0xb7, 0x40, 0x59, 0x9a, 0xdc, 0xd8, 0x0c, 0x64, 0x52, 0x25, 0x57, 0x4e,
	0xdc, 0x16, 0x05, 0x0a, 0x14, 0x28, 0xfa, 0x08, 0x45, 0x2f, 0x7a, 0x93, 0xc7, 0xe8, 0x43, 0xf4,
	0x89, 0x8a, 0x62, 0x97, 0x2b, 0x8b, 0xd6, 0x0f, 0x25, 0x3b, 0x06, 0x7a, 0x63, 0x98, 0x3b, 0x3b,
	0xdf, 0xcc, 0xce, 0xcc, 0x7e, 0x3b, 0x23, 0x78, 0xe0, 0x86, 0x1e, 0x2e, 0xbf, 0x6c, 0xc7, 0xc4,
	0x0f, 0xca, 0xe4, 0x64, 0xdd, 0x39, 0xfe, 0x36, 0x58, 0xb7, 0x5e, 0xf9, 0xc4, 0x3d, 0x32, 0x1d,
	0xdf, 0x8b, 0xad, 0x57, 0x7e, 0xd4, 0x5a, 0x27, 0xf4, 0x6f, 0xb9, 0x15, 0x85, 0x24, 0x44, 0x2b,
	0x84, 0x49, 0xcb, 0x2f, 0xda, 0x4d, 0x12, 0x06, 0xe5, 0xe4, 0x2b, 0xa2, 0x7b, 0xa5, 0x9b, 0x87,
	0x61, 0x78, 0xd8, 0xc4, 0xeb, 0x6c, 0xe3, 0x41, 0xfb, 0xc5, 0x3a, 0xf1, 0x8f, 0x71, 0x4c, 0x9c,
	0x63, 0xae, 0x2b, 0xef, 0xc1, 0x6a, 0xd5, 0x09, 0x5c, 0xdc, 0xa4, 0xd8, 0x95, 0xd3, 0x46, 0xd8,
	0x8e, 0x5c, 0xac, 0xd5, 0x4c, 0xfc, 0x4d, 0x1b, 0xc7, 0x04, 0xad, 0x42, 0xd1, 0x75, 0x9a, 0x4d,
	0x1c, 0xd9, 0xbe, 0xb7, 0x2c, 0xdc, 0x12, 0xee, 0x16, 0xcd, 0xe9, 0x64, 0x41, 0xf3, 0xa8, 0x30,
	0x66, 0xfb, 0xa9, 0x30, 0x97, 0x08, 0x93, 0x05, 0xcd, 0x93, 0x7f, 0xc9, 0xc1, 0x8d, 0xc1, 0xc8,
	0x71, 0x2b, 0x0c, 0x62, 0x8c, 0xbe, 0x06, 0xc0, 0x51, 0x14, 0x46, 0x36, 0x3d, 0x2f, 0xc3, 0x9e,
	0xd9, 0x50, 0xca, 0x43, 0x8f, 0x52, 0xce, 0x02, 0x2b, 0xab, 0x14, 0xa9, 0x1a, 0x7a, 0xd8, 0x2c,
	0xe2, 0xce, 0xbf, 0xe8, 0x11, 0x4c, 0x50, 0x55, 0xe6, 0x5a, 0x69, 0xe3, 0x66, 0x06, 0x36, 0x45,
	0x35, 0xd9, 0x66, 0xd9, 0x84, 0xe2, 0x19, 0x18, 0x5a, 0x00, 0x51, 0x35, 0x4d, 0xc3, 0xb4, 0xab,
	0x46, 0x4d, 0xb5, 0x77, 0xf4, 0x86, 0x6a, 0x89, 0xff, 0x42, 0xf3, 0x30, 0xab, 0x1b, 0xf6, 0xb6,
	0xaa, 0xd7, 0x34, 0x7d, 0xcb, 0x36, 0x15, 0xad, 0x26, 0x0a, 0x48, 0x82, 0x45, 0x63, 0x5b, 0x35,
	0x15, 0x4b, 0x33, 0x74, 0xdb, 0x54, 0x2c, 0xd5, 0xae, 0x6b, 0xcf, 0x34, 0x4b, 0xad, 0x89, 0x39,
	0xf9, 0x25, 0xcc, 0x55, 0x23, 0xec, 0x10, 0xcc, 0xec, 0xbc, 0x6d, 0x68, 0xa9, 0x90, 0x38, 0xd1,
	0x21, 0x26, 0x54, 0x98, 0x4f, 0x84, 0xc9, 0x82, 0xe6, 0xc9, 0x7f, 0xe4, 0x01, 0xa5, 0x8d, 0xf1,
	0x68, 0xef, 0x0e, 0x88, 0xf6, 0x93, 0xac, 0x68, 0xf7, 0x41, 0x5c, 0x5d, 0x8c, 0xd1, 0x53, 0x28,
	0x04, 0x21, 0xf1, 0x5d, 0x1c, 0x33, 0xf7, 0x4b, 0x1b, 0xf7, 0xc7, 0xf2, 0x44, 0x4f, 0x74, 0xcc,
	0x8e, 0xb2, 0xfc, 0xa7, 0x30, 0x3a, 0x59, 0xcb, 0xb0, 0x50, 0x55, 0x74, 0xdd, 0xb0, 0x58, 0xa2,
	0xec, 0x7d, 0x63, 0xc7, 0x6c, 0xa8, 0xf5, 0xa7, 0xa2, 0x80, 0x16, 0x01, 0xa5, 0x25, 0x96, 0x62,
	0x6e, 0xa9, 0x96, 0x98, 0xa3, 0xe9, 0x55, 0xea, 0xa6, 0xaa, 0xd4, 0xf6, 0x99, 0x40, 0xd3, 0xb7,
	0xc4, 0x3c, 0x05, 0xb7, 0x0c, 0xc3, 0x7e, 0xa6, 0xe8, 0xfb, 0xf6, 0xae, 0xa6, 0xee, 0xa9, 0x66,
	0x43, 0x9c, 0xc8, 0x48, 0xfa, 0x24, 0x5a, 0x81, 0xeb, 0x09, 0xa4, 0x6d, 0xec, 0x58, 0xb6, 0xf1,
	0xd4, 0xd6, 0x55, 0x6b, 0xcf, 0x30, 0x3f, 0x17, 0xa7, 0x52, 0xa2, 0x9a, 0xd6, 0x50, 0x2a, 0x75,
	0xb5, 0xc6, 0x2c, 0x35, 0xc4, 0x82, 0x6c, 0xa5, 0x4b, 0x85, 0x1f, 0x18, 0x2d, 0xc2, 0xd4, 0xb1,
	0x43, 0xda, 0x51, 0x92, 0xb8, 0x69, 0x93, 0x7f, 0xa1, 0x3b, 0x30, 0x1b, 0xe1, 0x98, 0x44, 0xbe,
	0x4b, 0xb0, 0x67, 0xbb, 0x47, 0x0e, 0x61, 0x79, 0x98, 0x36, 0x67, 0xba, 0xcb, 0xd5, 0x23, 0x87,
	0xc8, 0x27, 0xf0, 0xbf, 0x9a, 0xef, 0xed, 0xc4, 0x38, 0x32, 0xb1, 0x8b, 0x03, 0xd2, 0x3c, 0xa5,
	0xf0, 0xd5, 0x23, 0x27, 0x08, 0x70, 0xb3, 0x53, 0x90, 0x4b, 0x50, 0x68, 0xc7, 0xe9, 0x72, 0x9c,
	0xa2, 0x9f, 0x49, 0xbd, 0x79, 0xf8, 0xc4, 0x3f, 0x57, 0x8c, 0xc9, 0xc2, 0xa8, 0x62, 0x3c, 0x02,
	0x39, 0xcb, 0x2e, 0xaf, 0xcd, 0x0a, 0xfc, 0xd7, 0xf3, 0x3d, 0x9b, 0x19, 0x8f, 0xf8, 0x3e, 0x9b,
	0x26, 0x9f, 0x1e, 0x89, 0xee, 0xe4, 0xc7, 0x96, 0xbc, 0xa1, 0x58, 0xf2, 0x73, 0xb8, 0xbe, 0x85,
	0x49, 0x22, 0x61, 0x34, 0x39, 0xee, 0x35, 0xeb, 0x3a, 0x9f, 0xeb, 0x71, 0xde, 0x80, 0xc5, 0x5e,
	0x48, 0xee, 0xf0, 0x26, 0x4c, 0xb2, 0xda, 0x5c, 0x16, 0x6e, 0xe5, 0xc7, 0xa9, 0xfa, 0x64, 0xb7,
	0xbc, 0x0f, 0x48, 0x8b, 0xe9, 0xc2, 0xae, 0xd3, 0xec, 0xf2, 0xc0, 0x12, 0x14, 0xd8, 0x59, 0xbb,
	0x61, 0xa7, 0x9f, 0x9a, 0x87, 0xd6, 0x60, 0x8e, 0x3b, 0xc7, 0xc3, 0xd0, 0x75, 0x72, 0x36, 0x11,
	0xf0, 0xc3, 0x6b, 0x9e, 0x7c, 0x0f, 0xe6, 0xcf, 0x41, 0x73, 0x47, 0x17, 0x60, 0xf2, 0x84, 0x2e,
	0xf0, 0x00, 0x26, 0x1f, 0xf2, 0x2e, 0x48, 0x0d, 0xe2, 0x44, 0xe4, 0xaa, 0x29, 0xff, 0x4d, 0x0e,
	0x56, 0x07, 0x02, 0x73, 0x6f, 0xec, 0x01, 0x1c, 0xf4, 0x69, 0x46, 0xec, 0x32, 0xb0, 0xae, 0x90,
	0xf0, 0xc3, 0x4b, 0x12, 0xfe, 0x2a, 0x2c, 0x31, 0xde, 0x60, 0x04, 0xc2, 0xd8, 0xc2, 0x32, 0xec,
	0x86, 0xa5, 0x98, 0x94, 0x43, 0x86, 0x13, 0x43, 0x5e, 0xde, 0x04, 0x89, 0xd6, 0x95, 0xe3, 0x7b,
	0xdb, 0x4e, 0x44, 0x7c, 0xd7, 0x6f, 0x39, 0x01, 0x89, 0x47, 0x95, 0x83, 0xfc, 0x3e, 0xac, 0x0e,
	0x54, 0xe3, 0xc1, 0x5d, 0x81, 0x69, 0x7e, 0x7b, 0x93, 0xb2, 0x2c, 0x9a, 0x85, 0xe4, 0xfa, 0xc6,
	0xb2, 0x9e, 0x14, 0xb2, 0xe3, 0x7b, 0x0d, 0x4c, 0x88, 0x1f, 0x1c, 0x8e, 0x77, 0x39, 0x52, 0x7c,
	0x90, 0x4b, 0xf3, 0x81, 0xfc, 0x15, 0x2c, 0xf5, 0xe1, 0x71, 0x2f, 0xaa, 0x30, 0x1d, 0xf3, 0x35,
	0x86, 0x57, 0xda, 0xb8, 0x33, 0x22, 0x0b, 0x67, 0x10, 0x67, 0x8a, 0xf2, 0x97, 0xf0, 0x7f, 0x8e,
	0x6f, 0xb1, 0x32, 0x37, 0xb1, 0x1b, 0x1e, 0x1f, 0xe3, 0xc0, 0x73, 0x88, 0x1f, 0x06, 0x6f, 0xe9,
	0xbc, 0x0a, 0xb7, 0xb3, 0xc1, 0xf9, 0x49, 0xfe, 0x03, 0x70, 0x46, 0x0d, 0x9d, 0x88, 0x16, 0x3b,
	0xdc, 0x10, 0xcb, 0xdf, 0xc1, 0xec, 0x67, 0xa1, 0x1f, 0xa4, 0x1f, 0xf4, 0xa1, 0x17, 0x79, 0x98,
	0x2f, 0xe7, 0x89, 0x35, 0xdf, 0x43, 0xac, 0x2b, 0x30, 0x1d, 0x84, 0x76, 0x2b, 0x0a, 0x5f, 0x9f,
	0x2e, 0x4f, 0xb0, 0xeb, 0x5b, 0x08, 0xc2, 0x6d, 0xfa, 0x29, 0x23, 0x10, 0xbb, 0xc6, 0x13, 0x7f,
	0xe5, 0xef, 0x41, 0xac, 0x63, 0xe7, 0x04, 0xff, 0x33, 0x1e, 0xcd, 0xc3, 0x5c, 0xca, 0x3a, 0x77,
	0xe9, 0x8d, 0x00, 0x2b, 0x3b, 0x2d, 0x8f, 0x3f, 0x66, 0x57, 0x52, 0x7b, 0xe8, 0x39, 0x88, 0xae,
	0x13, 0xd8, 0x07, 0x98, 0x3d, 0x10, 0xd8, 0xb3, 0x0f, 0x4e, 0x99, 0x9f, 0x33, 0x1b, 0x77, 0xb3,
	0x7b, 0xc7, 0x0a, 0x73, 0x02, 0x7b, 0x95, 0x53, 0xf3, 0x9a, 0x9b, 0xfe, 0x94, 0x1d, 0x90, 0x06,
	0x79, 0x79, 0x95, 0x15, 0xfd, 0x5b, 0x0e, 0x26, 0xa8, 0x68, 0x78, 0x46, 0x2e, 0xdd, 0xf0, 0xd1,
	0x42, 0x75, 0x69, 0xc7, 0x10, 0xb2, 0x68, 0x4d, 0x30, 0x69, 0x91, 0xaf, 0x68, 0x1e, 0xfa, 0x80,
	0x8b, 0xb1, 0x67, 0x3b, 0x64, 0x79, 0x92, 0x9d, 0x40, 0x2a, 0x27, 0x63, 0x41, 0xb9, 0x33, 0x16,
	0x94, 0xad, 0xce, 0x58, 0xc0, 0x55, 0xb1, 0xa7, 0x10, 0xaa, 0x1a, 0x53, 0x0a, 0x4e, 0x54, 0xa7,
	0x46, 0xab, 0xf2, 0xdd, 0x0a, 0x41, 0xf7, 0x60, 0xae, 0xd5, 0x65, 0x29, 0xdb, 0x0d, 0xdb, 0x01,
	0x59, 0x2e, 0xdc, 0x12, 0xee, 0x4e, 0x9a, 0x62, 0x4a, 0x50, 0xa5, 0xeb, 0xb2, 0x03, 0xff, 0x4e,
	0xc7, 0x6d, 0x60, 0x8e, 0x85, 0xb7, 0xca, 0xf1, 0xda, 0x1e, 0x00, 0x33, 0x41, 0x1c, 0xd2, 0x8e,
	0xd1, 0x75, 0x98, 0x63, 0xd4, 0xdd, 0xb0, 0x14, 0x6b, 0xa7, 0x71, 0x46, 0xf3, 0x25, 0x28, 0x70,
	0x8e, 0x17, 0x05, 0x54, 0x84, 0x49, 0xc6, 0xea, 0x62, 0x0e, 0xcd, 0x42, 0x49, 0xd3, 0xed, 0x6d,
	0xd3, 0xd8, 0x32, 0xd5, 0x46, 0x43, 0xcc, 0x53, 0x99, 0xaa, 0xd7, 0xd4, 0x9a, 0x38, 0xb1, 0xf6,
	0x03, 0x5c, 0x3b, 0x67, 0x98, 0x32, 0x7f, 0x55, 0xd1, 0xed, 0x8a, 0xca, 0xde, 0x09, 0xb5, 0x66,
	0x57, 0xf6, 0x7b, 0x7a, 0xd1, 0xf3, 0x32, 0xa5, 0x5e, 0x17, 0x05, 0x74, 0x03, 0x96, 0xfb, 0x24,
	0x9d, 0x7e, 0x31, 0x47, 0xfb, 0xc5, 0x7e, 0xa9, 0xa1, 0xab, 0x62, 0x7e, 0xe3, 0xaf, 0x12, 0x94,
	0x52, 0xc3, 0x21, 0xfa, 0x59, 0x80, 0x85, 0x41, 0x93, 0x12, 0x7a, 0x7c, 0xe1, 0xd1, 0x8a, 0x5d,
	0x53, 0xe9, 0xc9, 0x25, 0x47, 0x32, 0xe4, 0x03, 0x74, 0x3b, 0x59, 0x74, 0x7f, 0xcc, 0x59, 0x23,
	0x31, 0xfa, 0xee, 0x85, 0x26, 0x13, 0xf4, 0xab, 0x00, 0xd2, 0xf0, 0x3e, 0x13, 0x7d, 0x98, 0x81,
	0x36, 0xb2, 0x2d, 0x96, 0x3e, 0xba, 0xa4, 0x36, 0xf7, 0xed, 0x27, 0x01, 0xe6, 0x07, 0xbc, 0xdb,
	0x68, 0x33, 0x03, 0x76, 0x78, 0x7b, 0x20, 0x3d, 0xbe, 0xa8, 0x1a, 0x77, 0xe3, 0x35, 0xcc, 0xf6,
	0xbc, 0xd9, 0xe8, 0xe1, 0x68, 0xa8, 0x1e, 0xce, 0x96, 0x36, 0x2e, 0xa2, 0xc2, 0x2d, 0xff, 0x2e,
	0xc0, 0x8d, 0xac, 0x17, 0x17, 0x7d, 0x3c, 0x1a, 0x34, 0xab, 0x0f, 0x90, 0x3e, 0xb9, 0xb4, 0x3e,
	0xf7, 0xb0, 0x0d, 0x33, 0xe7, 0x1b, 0x7d, 0xf4, 0x60, 0x04, 0x64, 0xdf, 0x98, 0x21, 0x3d, 0xbc,
	0x80, 0x06, 0x37, 0xdb, 0x84, 0x52, 0xaa, 0x67, 0x47, 0x59, 0x35, 0xdf, 0x3f, 0x36, 0x48, 0xe5,
	0x71, 0xb7, 0xa7, 0xea, 0x70, 0x40, 0x43, 0x9d, 0x59, 0x87, 0xc3, 0xa7, 0x84, 0xcc, 0x3a, 0xcc,
	0x9a, 0x01, 0x5c, 0x98, 0xee, 0xb4, 0x2e, 0x68, 0x2d, 0x03, 0xa3, 0xa7, 0xb9, 0x92, 0xee, 0x8d,
	0xb5, 0x97, 0x1b, 0x79, 0x01, 0xc5, 0xb3, 0x6e, 0x04, 0x65, 0x69, 0xf6, 0x76, 0x4c, 0xd2, 0xfd,
	0xf1, 0x36, 0x73, 0x3b, 0x3f, 0x0a, 0x80, 0xfa, 0x5b, 0x07, 0xf4, 0x5e, 0x06, 0xc8, 0xd0, 0x7e,
	0x48, 0xda, 0xbc, 0xa0, 0x56, 0xe2, 0x43, 0xe5, 0x9d, 0x2f, 0x6e, 0x8f, 0xf3, 0x83, 0xe1, 0xc1,
	0x14, 0x7b, 0xb0, 0x1f, 0xfd, 0x1d, 0x00, 0x00, 0xff, 0xff, 0x7b, 0xa3, 0xc4, 0x9d, 0x5f, 0x14,
	0x00, 0x00,
}
