// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchRecsTwirp/twirp.proto

/*
Package TwitchRecsTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchRecsTwirp/twirp.proto
*/
package TwitchRecsTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ====================
// TwitchRecs Interface
// ====================

// TwitchRecs service exposing endpoints for personalized streams and categories.
type TwitchRecs interface {
	// GetRecommendedStreams returns a list of currently live streams ranked in order of their
	// relevance to a target user.
	GetRecommendedStreams(context.Context, *RecommendedStreamsRequest) (*RecommendedStreamsResponse, error)

	// GetRecommendedCategories returns a list of categories ranked in order of their
	// relevance to a target user.
	GetRecommendedCategories(context.Context, *RecommendedCategoriesRequest) (*RecommendedCategoriesResponse, error)

	// GetSimilarStreams returns a list of currently live streams ranked in order of their
	// relevance to a target channel.
	GetSimilarStreams(context.Context, *SimilarStreamsRequest) (*SimilarStreamsResponse, error)
}

// ==========================
// TwitchRecs Protobuf Client
// ==========================

type twitchRecsProtobufClient struct {
	client HTTPClient
	urls   [3]string
	opts   twirp.ClientOptions
}

// NewTwitchRecsProtobufClient creates a Protobuf client that implements the TwitchRecs interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchRecsProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchRecs {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchRecsPathPrefix
	urls := [3]string{
		prefix + "GetRecommendedStreams",
		prefix + "GetRecommendedCategories",
		prefix + "GetSimilarStreams",
	}

	return &twitchRecsProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchRecsProtobufClient) GetRecommendedStreams(ctx context.Context, in *RecommendedStreamsRequest) (*RecommendedStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedStreams")
	out := new(RecommendedStreamsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRecsProtobufClient) GetRecommendedCategories(ctx context.Context, in *RecommendedCategoriesRequest) (*RecommendedCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedCategories")
	out := new(RecommendedCategoriesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRecsProtobufClient) GetSimilarStreams(ctx context.Context, in *SimilarStreamsRequest) (*SimilarStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithMethodName(ctx, "GetSimilarStreams")
	out := new(SimilarStreamsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// TwitchRecs JSON Client
// ======================

type twitchRecsJSONClient struct {
	client HTTPClient
	urls   [3]string
	opts   twirp.ClientOptions
}

// NewTwitchRecsJSONClient creates a JSON client that implements the TwitchRecs interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchRecsJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchRecs {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchRecsPathPrefix
	urls := [3]string{
		prefix + "GetRecommendedStreams",
		prefix + "GetRecommendedCategories",
		prefix + "GetSimilarStreams",
	}

	return &twitchRecsJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchRecsJSONClient) GetRecommendedStreams(ctx context.Context, in *RecommendedStreamsRequest) (*RecommendedStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedStreams")
	out := new(RecommendedStreamsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRecsJSONClient) GetRecommendedCategories(ctx context.Context, in *RecommendedCategoriesRequest) (*RecommendedCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedCategories")
	out := new(RecommendedCategoriesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchRecsJSONClient) GetSimilarStreams(ctx context.Context, in *SimilarStreamsRequest) (*SimilarStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithMethodName(ctx, "GetSimilarStreams")
	out := new(SimilarStreamsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// TwitchRecs Server Handler
// =========================

type twitchRecsServer struct {
	TwitchRecs
	hooks *twirp.ServerHooks
}

func NewTwitchRecsServer(svc TwitchRecs, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchRecsServer{
		TwitchRecs: svc,
		hooks:      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchRecsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchRecsPathPrefix is used for all URL paths on a twirp TwitchRecs server.
// Requests are always: POST TwitchRecsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchRecsPathPrefix = "/twirp/twitch.recs.twitchrecs.TwitchRecs/"

func (s *twitchRecsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.recs.twitchrecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchRecs")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.recs.twitchrecs.TwitchRecs/GetRecommendedStreams":
		s.serveGetRecommendedStreams(ctx, resp, req)
		return
	case "/twirp/twitch.recs.twitchrecs.TwitchRecs/GetRecommendedCategories":
		s.serveGetRecommendedCategories(ctx, resp, req)
		return
	case "/twirp/twitch.recs.twitchrecs.TwitchRecs/GetSimilarStreams":
		s.serveGetSimilarStreams(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchRecsServer) serveGetRecommendedStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecommendedStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecommendedStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRecsServer) serveGetRecommendedStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RecommendedStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecommendedStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRecs.GetRecommendedStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecommendedStreamsResponse and nil error while calling GetRecommendedStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRecsServer) serveGetRecommendedStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RecommendedStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecommendedStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRecs.GetRecommendedStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecommendedStreamsResponse and nil error while calling GetRecommendedStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRecsServer) serveGetRecommendedCategories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecommendedCategoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecommendedCategoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRecsServer) serveGetRecommendedCategoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RecommendedCategoriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecommendedCategoriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRecs.GetRecommendedCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecommendedCategoriesResponse and nil error while calling GetRecommendedCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRecsServer) serveGetRecommendedCategoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RecommendedCategoriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecommendedCategoriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRecs.GetRecommendedCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecommendedCategoriesResponse and nil error while calling GetRecommendedCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRecsServer) serveGetSimilarStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSimilarStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSimilarStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchRecsServer) serveGetSimilarStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSimilarStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SimilarStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SimilarStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRecs.GetSimilarStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SimilarStreamsResponse and nil error while calling GetSimilarStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRecsServer) serveGetSimilarStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSimilarStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SimilarStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SimilarStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchRecs.GetSimilarStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SimilarStreamsResponse and nil error while calling GetSimilarStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchRecsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchRecsServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchRecsServer) PathPrefix() string {
	return TwitchRecsPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1044 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0x8f, 0xed, 0x7c, 0xf9, 0x6d, 0x6a, 0x3b, 0xa3, 0x26, 0x75, 0x4d, 0x4a, 0xc1, 0x25, 0x50,
	0x90, 0x58, 0x17, 0x03, 0x02, 0x84, 0x38, 0x90, 0xaf, 0x76, 0x45, 0xea, 0xa4, 0x93, 0xa4, 0xa9,
	0x40, 0xc2, 0xda, 0xec, 0x4e, 0x9c, 0xa1, 0xfb, 0x61, 0x66, 0x66, 0x93, 0x9a, 0x03, 0x57, 0x24,
	0x4e, 0x88, 0x0b, 0x67, 0x6e, 0xdc, 0xb8, 0x72, 0xe2, 0xc6, 0xff, 0x85, 0x76, 0x66, 0x67, 0xbd,
	0x9b, 0x7a, 0xc1, 0x51, 0x7b, 0x42, 0x5c, 0xac, 0x79, 0x6f, 0xde, 0xfb, 0xcd, 0x7b, 0xef, 0xf7,
	0xe6, 0xcd, 0x1a, 0x3a, 0x4e, 0xe8, 0x12, 0xf3, 0x9b, 0x88, 0x0b, 0x1a, 0x98, 0xe2, 0xbc, 0x63,
	0xfb, 0xdf, 0x05, 0x9d, 0xc3, 0x0b, 0x2a, 0x9c, 0x33, 0x4c, 0x1c, 0x7e, 0x78, 0x41, 0xd9, 0xb0,
	0x23, 0xe2, 0x5f, 0x73, 0xc8, 0x42, 0x11, 0xa2, 0x55, 0x21, 0x37, 0x4d, 0x46, 0x1c, 0x6e, 0xaa,
	0x75, 0xbc, 0x6c, 0xbd, 0x3a, 0x08, 0xc3, 0x81, 0x47, 0x3a, 0xd2, 0xea, 0x24, 0x3a, 0xed, 0x5c,
	0x30, 0x7b, 0x38, 0x24, 0x8c, 0x2b, 0xbf, 0xd6, 0x56, 0xf1, 0x41, 0x3b, 0xc4, 0x16, 0x11, 0x23,
	0x9b, 0x61, 0x20, 0xc8, 0x33, 0xd1, 0xe1, 0xce, 0x19, 0xf1, 0xed, 0xce, 0xa9, 0xd2, 0x3a, 0x4a,
	0xab, 0x50, 0xda, 0x3f, 0x55, 0xe0, 0x26, 0x26, 0x4e, 0xe8, 0xfb, 0x24, 0x70, 0x89, 0x7b, 0x20,
	0x18, 0xb1, 0x7d, 0x8e, 0xc9, 0xb7, 0x11, 0xe1, 0x02, 0xed, 0x41, 0x9d, 0xa9, 0x65, 0x3f, 0x71,
	0x6b, 0x96, 0x5e, 0x2b, 0xdd, 0x35, 0xba, 0x6f, 0x9a, 0x93, 0xa3, 0x36, 0x13, 0xcf, 0xe4, 0x68,
	0x5c, 0x63, 0x39, 0x19, 0xed, 0xc0, 0x52, 0xc4, 0x09, 0x4b, 0xd1, 0xca, 0x12, 0xed, 0x4e, 0x11,
	0xda, 0x11, 0x27, 0x4c, 0x43, 0x19, 0xd1, 0x58, 0x40, 0x9f, 0xc0, 0xc2, 0x29, 0xf5, 0x04, 0x61,
	0xbc, 0x59, 0x91, 0x10, 0xb7, 0x8b, 0x20, 0x76, 0x94, 0x19, 0xd6, 0xf6, 0x68, 0x17, 0x6a, 0x5c,
	0x66, 0xd9, 0xd7, 0x08, 0xb3, 0x12, 0x61, 0xbd, 0x08, 0x41, 0xd5, 0x44, 0xe3, 0x5c, 0xe3, 0x59,
	0x11, 0x3d, 0x82, 0x7a, 0x52, 0xd7, 0x34, 0xa7, 0x39, 0x09, 0x77, 0x57, 0xc3, 0x9d, 0x3f, 0x33,
	0x2f, 0x55, 0x3e, 0x4f, 0x0f, 0xae, 0x9d, 0xe6, 0xe4, 0xf6, 0x5f, 0x65, 0x58, 0xcb, 0x50, 0xb2,
	0x69, 0x0b, 0x32, 0x08, 0x19, 0x25, 0xff, 0x69, 0x56, 0x26, 0xd4, 0x71, 0xf6, 0x05, 0xeb, 0xf8,
	0x47, 0x05, 0x56, 0x0e, 0xa8, 0x4f, 0x3d, 0x9b, 0xfd, 0xdf, 0xd6, 0x57, 0x6c, 0xeb, 0x77, 0x60,
	0x59, 0xd8, 0x6c, 0x40, 0x44, 0xdf, 0x39, 0xb3, 0x83, 0x80, 0x78, 0x7d, 0xea, 0xca, 0xc6, 0xae,
	0xe2, 0xba, 0xda, 0xd8, 0x54, 0x7a, 0xcb, 0x9d, 0x44, 0xdd, 0xfc, 0x0b, 0x52, 0xf7, 0x5b, 0x09,
	0x6a, 0xf9, 0x92, 0xa3, 0x4f, 0x01, 0x34, 0x67, 0xd4, 0x4d, 0xe8, 0x5a, 0x33, 0xd5, 0x8c, 0x34,
	0xf5, 0x8c, 0x8c, 0x93, 0xa2, 0xc1, 0xe0, 0xb1, 0xed, 0x45, 0x04, 0x57, 0x13, 0x7b, 0xcb, 0x45,
	0xb7, 0x00, 0x86, 0x2c, 0x74, 0x23, 0x47, 0x3a, 0x97, 0x65, 0x1e, 0xd5, 0x44, 0x63, 0xb9, 0xe8,
	0x3a, 0xcc, 0x79, 0xd4, 0xa7, 0x42, 0x16, 0xbd, 0x82, 0x95, 0x80, 0xde, 0x80, 0x1a, 0x8f, 0x4e,
	0xfa, 0x19, 0xc7, 0x59, 0xe9, 0xb8, 0xc4, 0xa3, 0x93, 0x7d, 0xed, 0xdb, 0xfe, 0xa5, 0x04, 0x46,
	0x86, 0x4f, 0xf4, 0x0a, 0x54, 0x5d, 0x72, 0x4e, 0x1d, 0xa2, 0xc3, 0xac, 0xe2, 0x45, 0xa5, 0xb0,
	0x5c, 0x74, 0x03, 0x16, 0x64, 0x9f, 0xa4, 0x41, 0xcc, 0xc7, 0xa2, 0xe5, 0xa2, 0x35, 0xa8, 0x7a,
	0x76, 0x30, 0x88, 0xec, 0x01, 0x89, 0xa9, 0xaf, 0xc4, 0xf1, 0xa5, 0x0a, 0xd4, 0x84, 0x05, 0x27,
	0x8c, 0x02, 0xc1, 0x46, 0x49, 0x08, 0x5a, 0x44, 0x2d, 0x58, 0x1c, 0x7a, 0xb6, 0x38, 0x0d, 0x99,
	0x2f, 0x8b, 0x5e, 0xc5, 0xa9, 0xdc, 0x3e, 0x86, 0x05, 0x4d, 0xe7, 0xdb, 0xd0, 0x60, 0x84, 0x0b,
	0x46, 0x1d, 0x41, 0xc3, 0xa0, 0xef, 0x51, 0x1e, 0x77, 0x7c, 0x7c, 0x4a, 0x3d, 0xa3, 0xdf, 0xa5,
	0x5c, 0xa0, 0xd7, 0x61, 0xe9, 0xc4, 0x0b, 0x9d, 0xa7, 0xc4, 0x55, 0x66, 0x65, 0x69, 0x66, 0x24,
	0xba, 0xd8, 0xa4, 0xfd, 0x7b, 0x19, 0xae, 0xe5, 0xba, 0x07, 0x3d, 0x81, 0x1b, 0x59, 0x7c, 0x47,
	0x8d, 0xac, 0xd1, 0x94, 0x4c, 0x6d, 0x94, 0x9b, 0x25, 0xbc, 0x92, 0x01, 0x48, 0x46, 0xde, 0xc8,
	0x72, 0xd1, 0x13, 0xb8, 0x99, 0x43, 0x0e, 0x3d, 0x8f, 0xa8, 0x65, 0x52, 0xc3, 0x7f, 0xeb, 0x82,
	0x6c, 0x60, 0x9b, 0xa9, 0xb7, 0xe5, 0xa2, 0x7b, 0x70, 0x5d, 0x27, 0x9a, 0x89, 0x57, 0x57, 0x1f,
	0x25, 0x7b, 0xe3, 0x50, 0x38, 0xfa, 0x18, 0x9a, 0x05, 0x59, 0xc6, 0x97, 0x2d, 0xf6, 0x5a, 0x9d,
	0x98, 0x04, 0x6f, 0x7f, 0x05, 0xad, 0x49, 0x8f, 0x2c, 0x1f, 0x86, 0x01, 0x27, 0xe8, 0x33, 0x98,
	0xa3, 0x82, 0xf8, 0x5c, 0x52, 0x62, 0x74, 0xdf, 0x2a, 0x1e, 0x42, 0x29, 0x84, 0x25, 0x88, 0x8f,
	0x95, 0x57, 0xfb, 0x6b, 0xb8, 0x55, 0xf0, 0x5c, 0xbc, 0x1c, 0xfc, 0x63, 0x58, 0xbd, 0x3c, 0x46,
	0x5f, 0x0e, 0xf0, 0x32, 0xd4, 0x75, 0x91, 0xf4, 0xc5, 0xff, 0xb9, 0xa4, 0x5b, 0x4b, 0xdf, 0xa7,
	0x47, 0x60, 0x24, 0x73, 0x4d, 0x8c, 0x86, 0x44, 0xb6, 0x53, 0xad, 0x7b, 0xef, 0x9f, 0x87, 0x5a,
	0xe2, 0x9b, 0x48, 0x87, 0xa3, 0x21, 0xc1, 0xc0, 0xd3, 0x75, 0xdb, 0x04, 0x18, 0xef, 0x20, 0x03,
	0x16, 0x8e, 0x7a, 0x5f, 0xf4, 0xf6, 0x8e, 0x7b, 0x8d, 0x19, 0xb4, 0x08, 0xb3, 0xbb, 0xd6, 0xe3,
	0xed, 0x46, 0x09, 0x55, 0x61, 0x0e, 0x6f, 0xe3, 0xa3, 0x5e, 0xa3, 0xdc, 0xfe, 0xb3, 0x04, 0x46,
	0x1c, 0xb7, 0x0e, 0xe9, 0x10, 0x1a, 0x29, 0xf7, 0xf9, 0xf7, 0xa3, 0xb0, 0x02, 0x97, 0xf2, 0x7c,
	0x30, 0x83, 0xeb, 0x4e, 0x5e, 0x85, 0x7a, 0xe9, 0x00, 0xcf, 0xbf, 0x22, 0xeb, 0x53, 0xe5, 0xfa,
	0x60, 0x46, 0x8f, 0xf0, 0x44, 0xb1, 0x51, 0x8d, 0x87, 0x86, 0xaa, 0xea, 0xaf, 0x65, 0xa8, 0x5f,
	0xe2, 0x20, 0x1e, 0x45, 0x31, 0x0b, 0xe3, 0x29, 0x35, 0x1f, 0x8b, 0x96, 0x8b, 0x6e, 0x83, 0x21,
	0x98, 0xed, 0x3c, 0xa5, 0xc1, 0x60, 0x3c, 0xa7, 0x40, 0xab, 0x2c, 0x17, 0x1d, 0x80, 0xc1, 0xc3,
	0x88, 0x39, 0x44, 0x31, 0x52, 0x91, 0x8c, 0x74, 0xa7, 0xe4, 0xde, 0x3c, 0x90, 0xae, 0x09, 0x27,
	0xe9, 0x3a, 0x7e, 0x41, 0x65, 0x38, 0xf9, 0xc7, 0xbf, 0xf0, 0x05, 0xcd, 0xd0, 0x81, 0x0d, 0x3a,
	0x16, 0xda, 0x1f, 0x01, 0x8c, 0x4f, 0xc8, 0x73, 0x5b, 0x07, 0x03, 0x6f, 0x6f, 0xee, 0x3d, 0x7c,
	0xb8, 0xdd, 0xdb, 0xda, 0xde, 0x6a, 0x94, 0xe2, 0xdd, 0xfd, 0xbd, 0xfd, 0xa3, 0xdd, 0xcf, 0x71,
	0xa3, 0xdc, 0xfd, 0xb1, 0x02, 0x30, 0xfe, 0x4c, 0x47, 0xdf, 0xc3, 0xca, 0x7d, 0x22, 0x9e, 0xbf,
	0xb4, 0xe8, 0xbd, 0x29, 0x12, 0xcd, 0x7f, 0x6e, 0xb4, 0xba, 0x57, 0x71, 0x49, 0xae, 0xd6, 0x0f,
	0x25, 0x68, 0xe6, 0x03, 0x18, 0x5f, 0x6c, 0xf4, 0xc1, 0x14, 0x80, 0xcf, 0x7d, 0x36, 0xb6, 0x3e,
	0xbc, 0xa2, 0x57, 0x12, 0x09, 0x83, 0xe5, 0xfb, 0x44, 0xe4, 0x27, 0x00, 0x7a, 0xb7, 0xb0, 0x29,
	0x27, 0x7d, 0x70, 0xb5, 0xcc, 0x69, 0xcd, 0xd5, 0x99, 0x1b, 0xeb, 0x5f, 0xde, 0x99, 0xe2, 0x6f,
	0xd4, 0xc9, 0xbc, 0x9c, 0xf8, 0xef, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xa1, 0x04, 0x4b, 0xeb,
	0x74, 0x0d, 0x00, 0x00,
}
