// Code generated by ./internal/GenerateConfig. DO NOT EDIT.
//+build !generate

package c7s

// Merge another configuration into this one.
func (cfg *Config) Merge(other *Config) *Config{

	if other.ClientServiceName != "" {
		cfg.ClientServiceName = other.ClientServiceName
	}

	if other.ServiceOrigins != "" {
		cfg.ServiceOrigins = other.ServiceOrigins
	}

	if other.AuthorizedDistributedIdentitiesServices != "" {
		cfg.AuthorizedDistributedIdentitiesServices = other.AuthorizedDistributedIdentitiesServices
	}

	if other.AccessTokenCacheSize != 0 {
		cfg.AccessTokenCacheSize = other.AccessTokenCacheSize
	}

	if other.ClientServiceURI != "" {
		cfg.ClientServiceURI = other.ClientServiceURI
	}

	if other.EnableAccessLogging != false {
		cfg.EnableAccessLogging = other.EnableAccessLogging
	}

	if other.LogAnonymousRequestRateLimit != 0 {
		cfg.LogAnonymousRequestRateLimit = other.LogAnonymousRequestRateLimit
	}

	if other.AWSRegion != "" {
		cfg.AWSRegion = other.AWSRegion
	}

	if other.ServiceURIByNameBase != "" {
		cfg.ServiceURIByNameBase = other.ServiceURIByNameBase
	}

	if other.ServiceByIDAuthorityURI != "" {
		cfg.ServiceByIDAuthorityURI = other.ServiceByIDAuthorityURI
	}

	if other.CalleeRealm != "" {
		cfg.CalleeRealm = other.CalleeRealm
	}

	if other.DiscoveryEndpoint != "" {
		cfg.DiscoveryEndpoint = other.DiscoveryEndpoint
	}

	if other.Issuer != "" {
		cfg.Issuer = other.Issuer
	}

	if other.TokenScope != "" {
		cfg.TokenScope = other.TokenScope
	}

	if other.IdentityOrigin != "" {
		cfg.IdentityOrigin = other.IdentityOrigin
	}

	if other.ServiceDomain != "" {
		cfg.ServiceDomain = other.ServiceDomain
	}

	return cfg
}

// Validate returns an error if attributes are missing
func (cfg *Config) Validate() error {
	missing := []string{}

	if cfg.AccessTokenCacheSize == 0 {
		missing = append(missing, "AccessTokenCacheSize")
	}

	if cfg.AWSRegion == "" {
		missing = append(missing, "AWSRegion")
	}

	if cfg.ServiceURIByNameBase == "" {
		missing = append(missing, "ServiceURIByNameBase")
	}

	if cfg.ServiceByIDAuthorityURI == "" {
		missing = append(missing, "ServiceByIDAuthorityURI")
	}

	if cfg.CalleeRealm == "" {
		missing = append(missing, "CalleeRealm")
	}

	if cfg.DiscoveryEndpoint == "" {
		missing = append(missing, "DiscoveryEndpoint")
	}

	if cfg.Issuer == "" {
		missing = append(missing, "Issuer")
	}

	if cfg.TokenScope == "" {
		missing = append(missing, "TokenScope")
	}

	if cfg.IdentityOrigin == "" {
		missing = append(missing, "IdentityOrigin")
	}

	if cfg.ServiceDomain == "" {
		missing = append(missing, "ServiceDomain")
	}

  if err := cfg.validateSpecialCases(); err != nil {
    if mergable, ok := err.(errMissingConfigurationMergable); ok {
      mergable.addAttributes(missing)
    }
    return err
  }

	if len(missing) > 0 {
		return newErrMissingConfiguration(missing...)
	}
	return nil
}
