// Code generated by ./internal/GenerateConfig. DO NOT EDIT.
//+build !generate

package c7s

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
)

func TestConfigMerge(t *testing.T) {

	t.Run("ClientServiceName", func(t *testing.T) {
		original := Config{
			ClientServiceName: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.ClientServiceName)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				ClientServiceName: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.ClientServiceName)
		})
	})

	t.Run("ServiceOrigins", func(t *testing.T) {
		original := Config{
			ServiceOrigins: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.ServiceOrigins)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				ServiceOrigins: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.ServiceOrigins)
		})
	})

	t.Run("AuthorizedDistributedIdentitiesServices", func(t *testing.T) {
		original := Config{
			AuthorizedDistributedIdentitiesServices: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.AuthorizedDistributedIdentitiesServices)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				AuthorizedDistributedIdentitiesServices: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.AuthorizedDistributedIdentitiesServices)
		})
	})

	t.Run("AccessTokenCacheSize", func(t *testing.T) {
		original := Config{
			AccessTokenCacheSize: int64(420),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, int64(420), cfg.AccessTokenCacheSize)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				AccessTokenCacheSize: int64(620),
			})
			assert.Equal(t, int64(620), cfg.AccessTokenCacheSize)
		})
	})

	t.Run("ClientServiceURI", func(t *testing.T) {
		original := Config{
			ClientServiceURI: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.ClientServiceURI)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				ClientServiceURI: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.ClientServiceURI)
		})
	})

	t.Run("EnableAccessLogging", func(t *testing.T) {
		original := Config{
			EnableAccessLogging: bool(true),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, bool(true), cfg.EnableAccessLogging)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				EnableAccessLogging: bool(true),
			})
			assert.Equal(t, bool(true), cfg.EnableAccessLogging)
		})
	})

	t.Run("LogAnonymousRequestRateLimit", func(t *testing.T) {
		original := Config{
			LogAnonymousRequestRateLimit: time.Duration(420),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, time.Duration(420), cfg.LogAnonymousRequestRateLimit)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				LogAnonymousRequestRateLimit: time.Duration(620),
			})
			assert.Equal(t, time.Duration(620), cfg.LogAnonymousRequestRateLimit)
		})
	})

	t.Run("AWSRegion", func(t *testing.T) {
		original := Config{
			AWSRegion: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.AWSRegion)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				AWSRegion: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.AWSRegion)
		})
	})

	t.Run("ServiceURIByNameBase", func(t *testing.T) {
		original := Config{
			ServiceURIByNameBase: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.ServiceURIByNameBase)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				ServiceURIByNameBase: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.ServiceURIByNameBase)
		})
	})

	t.Run("ServiceByIDAuthorityURI", func(t *testing.T) {
		original := Config{
			ServiceByIDAuthorityURI: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.ServiceByIDAuthorityURI)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				ServiceByIDAuthorityURI: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.ServiceByIDAuthorityURI)
		})
	})

	t.Run("CalleeRealm", func(t *testing.T) {
		original := Config{
			CalleeRealm: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.CalleeRealm)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				CalleeRealm: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.CalleeRealm)
		})
	})

	t.Run("DiscoveryEndpoint", func(t *testing.T) {
		original := Config{
			DiscoveryEndpoint: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.DiscoveryEndpoint)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				DiscoveryEndpoint: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.DiscoveryEndpoint)
		})
	})

	t.Run("Issuer", func(t *testing.T) {
		original := Config{
			Issuer: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.Issuer)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				Issuer: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.Issuer)
		})
	})

	t.Run("TokenScope", func(t *testing.T) {
		original := Config{
			TokenScope: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.TokenScope)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				TokenScope: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.TokenScope)
		})
	})

	t.Run("IdentityOrigin", func(t *testing.T) {
		original := Config{
			IdentityOrigin: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.IdentityOrigin)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				IdentityOrigin: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.IdentityOrigin)
		})
	})

	t.Run("ServiceDomain", func(t *testing.T) {
		original := Config{
			ServiceDomain: string("nonzero"),
		}

		t.Run("skip", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{})
			assert.Equal(t, string("nonzero"), cfg.ServiceDomain)
		})

		t.Run("overridden", func(t *testing.T) {
			cfg := new(Config)
			*cfg = original
			cfg = cfg.Merge(&Config{
				ServiceDomain: string("overidden"),
			})
			assert.Equal(t, string("overidden"), cfg.ServiceDomain)
		})
	})

}

func filledConfiguration() Config{
	return Config{

		ClientServiceName: string("nonzero"),

		ServiceOrigins: string("nonzero"),

		AuthorizedDistributedIdentitiesServices: string("nonzero"),

		AccessTokenCacheSize: int64(420),

		ClientServiceURI: string("nonzero"),

		EnableAccessLogging: bool(true),

		LogAnonymousRequestRateLimit: time.Duration(420),

		AWSRegion: string("nonzero"),

		ServiceURIByNameBase: string("nonzero"),

		ServiceByIDAuthorityURI: string("nonzero"),

		CalleeRealm: string("nonzero"),

		DiscoveryEndpoint: string("nonzero"),

		Issuer: string("nonzero"),

		TokenScope: string("nonzero"),

		IdentityOrigin: string("nonzero"),

		ServiceDomain: string("nonzero"),

	}
}

func TestConfigValidate(t *testing.T) {
	filled := filledConfiguration()

	t.Run("AccessTokenCacheSize missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.AccessTokenCacheSize = 0
		assert.Equal(t, newErrMissingConfiguration("AccessTokenCacheSize"), cfg.Validate())
	})

	t.Run("AWSRegion missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.AWSRegion = ""
		assert.Equal(t, newErrMissingConfiguration("AWSRegion"), cfg.Validate())
	})

	t.Run("ServiceURIByNameBase missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.ServiceURIByNameBase = ""
		assert.Equal(t, newErrMissingConfiguration("ServiceURIByNameBase"), cfg.Validate())
	})

	t.Run("ServiceByIDAuthorityURI missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.ServiceByIDAuthorityURI = ""
		assert.Equal(t, newErrMissingConfiguration("ServiceByIDAuthorityURI"), cfg.Validate())
	})

	t.Run("CalleeRealm missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.CalleeRealm = ""
		assert.Equal(t, newErrMissingConfiguration("CalleeRealm"), cfg.Validate())
	})

	t.Run("DiscoveryEndpoint missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.DiscoveryEndpoint = ""
		assert.Equal(t, newErrMissingConfiguration("DiscoveryEndpoint"), cfg.Validate())
	})

	t.Run("Issuer missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.Issuer = ""
		assert.Equal(t, newErrMissingConfiguration("Issuer"), cfg.Validate())
	})

	t.Run("TokenScope missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.TokenScope = ""
		assert.Equal(t, newErrMissingConfiguration("TokenScope"), cfg.Validate())
	})

	t.Run("IdentityOrigin missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.IdentityOrigin = ""
		assert.Equal(t, newErrMissingConfiguration("IdentityOrigin"), cfg.Validate())
	})

	t.Run("ServiceDomain missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filled
		cfg.ServiceDomain = ""
		assert.Equal(t, newErrMissingConfiguration("ServiceDomain"), cfg.Validate())
	})

}
