package c7s

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestValidateSpecialCases(t *testing.T) {
	t.Run("Client info  missing", func(t *testing.T) {
		cfg := new(Config)
		*cfg = filledConfiguration()
		cfg.ClientServiceName = ""
		cfg.ClientServiceURI = ""
		assert.Equal(t, newErrMissingConfiguration("ClientServiceName"), cfg.Validate())
	})
}

func TestErrMissingConfiguration(t *testing.T) {
	t.Run("Error", func(t *testing.T) {
		assert.Equal(t, newErrMissingConfiguration("myattr").Error(), "configuration required: myattr. Please check for solutions at: https://wiki.xarth.tv/display/SSE/S2S2+Errors#S2S2Errors-ConfigurationRequired")
	})
}
