//nolint:bodyclose
package httpwrap

import (
	"net/http"
	"testing"

	"code.justin.tv/amzn/TwitchS2S2/internal/httpwrap/mocks"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestHTTPClientFromRoundTripper(t *testing.T) {
	t.Run("RoundTrip", func(t *testing.T) {
		inner := new(mocks.RoundTripper)
		defer inner.AssertExpectations(t)

		httpClient := HTTPClientFromRoundTripper(inner)

		req := &http.Request{}
		res := &http.Response{}

		inner.On("RoundTrip", req).Return(res, nil).Once()

		outerRes, err := httpClient.Do(req)
		require.NoError(t, err)
		assert.Equal(t, res, outerRes)
	})
}
