//nolint:bodyclose
package httpwrap

import (
	"net/http"
	"testing"

	"code.justin.tv/amzn/TwitchS2S2/internal/httpwrap/mocks"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestRoundTripperFromHTTPClient(t *testing.T) {
	t.Run("RoundTrip", func(t *testing.T) {
		inner := new(mocks.HTTPClient)
		defer inner.AssertExpectations(t)

		rt := RoundTripperFromHTTPClient(inner)

		req := &http.Request{}
		res := &http.Response{}

		inner.On("Do", req).Return(res, nil).Once()

		outerRes, err := rt.RoundTrip(req)
		require.NoError(t, err)
		assert.Equal(t, res, outerRes)
	})
}
