package logutil

import (
	"testing"

	"code.justin.tv/amzn/TwitchS2S2/internal/logutil/mocks"
	"github.com/golang/mock/gomock"
)

func TestLoggerLogAnonymousRequest(t *testing.T) {
	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	const clientIP = "clientIP"
	const forwardedForIP = "forwardedForIP"
	const forwardedForProto = "forwardedForProto"
	const forwardedForPort = "forwardedForPort"

	test := newLoggerTest(ctrl)
	test.MockLogger.EXPECT().Log(
		"AnonymousRequestReceived",
		"client_ip", clientIP,
		"x_forwarded_for", forwardedForIP,
		"x_forwarded_proto", forwardedForProto,
		"x_forwarded_port", forwardedForPort,
	)
	test.Logger.LogAnonymousRequest(clientIP, forwardedForIP, forwardedForProto, forwardedForPort)
}

func newLoggerTest(ctrl *gomock.Controller) *loggerTest {
	mockLogger := mocks.NewMockLogger(ctrl)
	return &loggerTest{
		Logger: &Logger{
			Logger: mockLogger,
		},
		MockLogger: mockLogger,
	}
}

type loggerTest struct {
	Logger     *Logger
	MockLogger *mocks.MockLogger
}
