package logutil

import (
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchS2S2/internal/logutil/mocks"
	"github.com/golang/mock/gomock"
)

func TestRateLimitedLoggerLogAnonymousRequest(t *testing.T) {
	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	const clientIP = "clientIP"
	const forwardedForIP = "forwardedForIP"
	const forwardedForProto = "forwardedForProto"
	const forwardedForPort = "forwardedForPort"

	test := newRateLimitedLoggerTest(ctrl)
	test.MockLogger.EXPECT().Log(
		"AnonymousRequestReceived",
		"client_ip", clientIP,
		"x_forwarded_for", forwardedForIP,
		"x_forwarded_proto", forwardedForProto,
		"x_forwarded_port", forwardedForPort,
	).
		Times(1)
	test.LogAnonymousRequestRateLimit <- time.Now()

	test.RateLimitedLogger.LogAnonymousRequest(clientIP, forwardedForIP, forwardedForProto, forwardedForPort)
	for n := 0; n < 10; n++ {
		// repeats should not log
		test.RateLimitedLogger.LogAnonymousRequest(clientIP, forwardedForIP, forwardedForProto, forwardedForPort)
	}
}

func newRateLimitedLoggerTest(ctrl *gomock.Controller) *rateLimitedLoggerTest {
	mockLogger := mocks.NewMockLogger(ctrl)
	logAnonymousRequestRateLimit := make(chan time.Time, 1)
	return &rateLimitedLoggerTest{
		RateLimitedLogger: &RateLimitedLogger{
			Logger: Logger{
				Logger: mockLogger,
			},
			LogAnonymousRequestRateLimit: logAnonymousRequestRateLimit,
		},
		MockLogger:                   mockLogger,
		LogAnonymousRequestRateLimit: logAnonymousRequestRateLimit,
	}
}

type rateLimitedLoggerTest struct {
	RateLimitedLogger *RateLimitedLogger
	MockLogger        *mocks.MockLogger

	LogAnonymousRequestRateLimit chan<- time.Time
}
