package oidc

import (
	"net/http"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestParseCacheControlMaxAge(t *testing.T) {
	tcs := []struct {
		Name          string
		HeaderValue   string
		ExpectedValue time.Duration
		ExpectedError error
	}{
		{
			Name:          "correct format",
			HeaderValue:   "max-age=60",
			ExpectedValue: time.Minute,
		},
		{
			Name:          "incorrect format not number",
			HeaderValue:   "max-age=forever",
			ExpectedError: errInvalidCacheControlHeader,
		},
		{
			Name:          "incorrect format only numbers",
			HeaderValue:   "60",
			ExpectedError: errInvalidCacheControlHeader,
		},
	}

	for _, tc := range tcs {
		t.Run(tc.Name, func(t *testing.T) {
			res, err := parseCacheControlMaxAge(&http.Response{
				Header: http.Header{
					"Cache-Control": []string{tc.HeaderValue},
				},
			})
			require.Equal(t, tc.ExpectedError, err)
			assert.Equal(t, tc.ExpectedValue, res)
		})
	}
}
