package opwrap

import (
	"context"
	"errors"
	"strconv"
	"testing"

	"code.justin.tv/video/metrics-middleware/v2/operation"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

type errorWithStatusCode struct{}

func (errorWithStatusCode) Error() string     { return "" }
func (errorWithStatusCode) StatusCode() int32 { return 14 }

type testOpMonitor struct {
	Reports []*operation.Report
}

func (tom *testOpMonitor) MonitorOp(parent context.Context, name operation.Name) (context.Context, *operation.MonitorPoints) {
	return parent, &operation.MonitorPoints{
		End: func(report *operation.Report) {
			tom.Reports = append(tom.Reports, report)
		},
	}
}

func TestEndWithError(t *testing.T) {
	tcs := []struct {
		Error          error
		ExpectedStatus int32
	}{
		{Error: nil},
		{Error: errors.New("generic error"), ExpectedStatus: StatusUnknown},
		{Error: errorWithStatusCode{}, ExpectedStatus: 14},
	}

	for nTc, tc := range tcs {
		t.Run(strconv.Itoa(nTc), func(t *testing.T) {
			var om testOpMonitor

			operationStarter := &operation.Starter{
				OpMonitors: []operation.OpMonitor{
					&om,
				},
			}

			_, op := operationStarter.StartOp(context.TODO(), operation.Name{})
			EndWithError(op, tc.Error)

			require.Len(t, om.Reports, 1)
			assert.Equal(t, tc.ExpectedStatus, om.Reports[0].Status.Code)
		})
	}
}
