package s2stoken

import (
	"bytes"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParseAuthServerError(t *testing.T) {
	tcs := []struct {
		Body     string
		Expected string
	}{
		{
			Body:     `{"message": "my message"}`,
			Expected: "my message",
		},
		{
			Body:     "}{notjson",
			Expected: "}{notjson",
		},
	}

	for _, tc := range tcs {
		t.Run(tc.Expected, func(t *testing.T) {
			assert.Equal(t, tc.Expected, parseAuthServerError(bytes.NewBufferString(tc.Body)))
		})
	}
}
