package token

import (
	"encoding/json"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestToken(t *testing.T) {
	t.Run("json marshal", func(t *testing.T) {
		val := Token{
			AccessToken: "my-access-token",
			Scope:       Scope{"scope1": nil, "scope2": nil},
			ExpiresIn:   time.Hour,
		}

		marshaled, err := json.Marshal(val)
		require.NoError(t, err)

		t.Logf("marshaled: %s", marshaled)

		var unmarshaled Token
		require.NoError(t, json.Unmarshal(marshaled, &unmarshaled))
		assert.Equal(t, val, unmarshaled)
	})
}
