package token

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestOptions(t *testing.T) {
	t.Run("WithScope", func(t *testing.T) {
		s := NewScope("scope1", "scope2")
		assert.Equal(t, s, NewOptions().WithScope(s).Scope())
	})

	t.Run("Host", func(t *testing.T) {
		assert.Equal(t, "my-host", NewOptions().WithHost("my-host").Host())
	})
}
