package s2s2

import (
	"net/http"
	"testing"

	"code.justin.tv/amzn/TwitchS2S2/c7s"
	"code.justin.tv/amzn/TwitchS2S2/internal/s2s2err"
	"github.com/stretchr/testify/assert"
)

func TestAuthorizationError(t *testing.T) {
	t.Run("parseAuthorizationError", func(t *testing.T) {
		baseAuthorizationError := &baseAuthorizationError{
			Config: &c7s.Config{
				CalleeRealm: "s2scalleerealm",
				Issuer:      "s2sissuer",
			},
			RequiredScopes: []string{"scope1", "scope2"},
		}

		tcs := []struct {
			Name               string
			AuthorizationError authorizationError
		}{
			{
				Name: "no error",
			},
			{
				Name: "invalid_token",
				AuthorizationError: &invalidTokenError{
					baseAuthorizationError: baseAuthorizationError,
					Reason:                 "my reason",
				},
			},
			{
				Name: "insufficient_scope",
				AuthorizationError: &insufficientScopeError{
					baseAuthorizationError: baseAuthorizationError,
				},
			},
		}
		for _, tc := range tcs {
			t.Run(tc.Name, func(t *testing.T) {
				res := &http.Response{Header: make(http.Header)}

				if tc.AuthorizationError != nil {
					res.Header.Set("WWW-Authenticate", tc.AuthorizationError.AuthenticateChallenge().HeaderValue())
					res.StatusCode = tc.AuthorizationError.Status()
					if tc.AuthorizationError.Error() == "Authorization Error: Please check for solutions at: "+s2s2err.S2S2ErrorURL+"Authorization caused by: my reason" {
						tc.AuthorizationError = &invalidTokenError{
							baseAuthorizationError: baseAuthorizationError,
							Reason:                 "Authorization Error: Please check for solutions at: " + s2s2err.S2S2ErrorURL + "Authorization caused by: my reason",
						}
					}
				}

				authErr := parseAuthorizationError(res)

				assert.Equal(t, tc.AuthorizationError, authErr)
			})
		}
	})
}
