package s2s2

import (
	"net/http"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParseAuthorizationHeader(t *testing.T) {
	tcs := []struct {
		Name        string
		Header      http.Header
		Expected    *rawAuthorization
		ExpectedErr error
	}{
		{
			Name: "success",
			Header: http.Header{
				"Authorization": []string{"Bearer abc"},
			},
			Expected:    &rawAuthorization{TokenType: "Bearer", Token: "abc"},
			ExpectedErr: nil,
		},
		{
			Name:        "no header",
			Header:      http.Header{},
			Expected:    nil,
			ExpectedErr: errMissingAuthorizationHeader,
		},
		{
			Name: "wrong number of parts",
			Header: http.Header{
				"Authorization": []string{"Bearer"},
			},
			Expected:    nil,
			ExpectedErr: errInvalidAuthorizationHeader,
		},
	}

	for _, tc := range tcs {
		t.Run(tc.Name, func(t *testing.T) {
			res, err := parseAuthorizationHeader(&http.Request{
				Header: tc.Header,
			})
			assert.Equal(t, tc.ExpectedErr, err)
			assert.Equal(t, tc.Expected, res)
		})
	}
}
