package s2s2

import (
	"context"
	"net/http"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestCurrentRequest(t *testing.T) {

	expected := httpRequest{
		AmazonTraceID:  "amazontraceid",
		RemoteAddress:  "remoteaddress",
		ForwardedFor:   "forwardedfor",
		ForwardedPort:  "forwardedport",
		ForwardedProto: "forwardedproto",
		Host:           "host",
	}

	ctx := context.Background()
	r, err := http.NewRequest("POST", "https://"+expected.Host, nil)
	require.NoError(t, err)
	r.Header.Set("X-Amzn-Trace-Id", expected.AmazonTraceID)
	r.Header.Set("X-Forwarded-For", expected.ForwardedFor)
	r.Header.Set("X-Forwarded-Port", expected.ForwardedPort)
	r.Header.Set("X-Forwarded-Proto", expected.ForwardedProto)
	r.RemoteAddr = expected.RemoteAddress

	currentRequest, ok := currentRequest(setCurrentRequest(ctx, r))
	require.True(t, ok)

	assert.Equal(t, &expected, currentRequest)
}
