package s2s2

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestDistributedIdentities(t *testing.T) {
	tcs := []struct {
		Expected string
		Values   []DistributedIdentity
	}{
		{
			Expected: "sa/ea",
			Values: []DistributedIdentity{
				{Service: "sa", Stage: "ea"},
			},
		},
		{
			Expected: "sa/ea,sb/eb",
			Values: []DistributedIdentity{
				{Service: "sa", Stage: "ea"},
				{Service: "sb", Stage: "eb"},
			},
		},
	}

	for nTc, tc := range tcs {
		t.Run(strconv.Itoa(nTc), func(t *testing.T) {
			assert.Equal(t, tc.Expected, DistributedIdentities(tc.Values...))
		})
	}
}
