// Code generated by Wire. DO NOT EDIT.


package s2s2

// Injectors from wire.go:

func New(options *Options) (*S2S2, error) {
	roundTripper := newRoundTripperFromOptions(options)
	httpClient := newHTTPClient(roundTripper)
	config, err := newConfigFromOptions(options)
	if err != nil {
		return nil, err
	}
	credentials := newCredentialsFromOptions(options)
	sigv4RoundTripper := newSigV4RoundTripper(roundTripper, config, credentials)
	starter := newOperationStarterFromOptions(options)
	oidc, err := newOIDC(sigv4RoundTripper, config, starter)
	if err != nil {
		return nil, err
	}
	cache, err := newOIDCCache(oidc)
	if err != nil {
		return nil, err
	}
	s2s2SigV4HTTPClient := newSigV4HTTPClient(sigv4RoundTripper)
	s2s2ProvidedClientServiceURI, err := newProvidedClientServiceURI(config)
	if err != nil {
		return nil, err
	}
	s2s2Assertions := newAssertions(config, cache, s2s2SigV4HTTPClient, starter, s2s2ProvidedClientServiceURI)
	s2s2ClientCredentials := newClientCredentials(s2s2Assertions, httpClient, config, cache, starter)
	s2s2AccessTokens := newAccessTokens(httpClient, s2s2ClientCredentials, cache, starter)
	logger := newLoggerFromOptions(options)
	s2s2OnTokenAuthenticatedHook := newOnTokenAuthenticatedHook(logger)
	s2s2OnTokenRejectedHook := newOnTokenRejectedHook(logger)
	authorizations := newAuthorizations(cache, logger, starter, s2s2OnTokenAuthenticatedHook, s2s2OnTokenRejectedHook)
	cachedAuthorizations := newCachedAuthorizations(authorizations, config)
	s2s2ClientServiceURI, err := newClientServiceURI(s2s2AccessTokens, authorizations)
	if err != nil {
		return nil, err
	}
	s2s2ServiceOrigins := newServiceOrigins(config)
	s2s2AuthorizedServices, err := newAuthorizedServices(options)
	if err != nil {
		return nil, err
	}
	s2s2CertificateStoreOrigin, err := newCertificateStoreOrigin(config)
	if err != nil {
		return nil, err
	}
	s2s2dicalleeOptions := newOptions(s2s2ServiceOrigins, s2s2AuthorizedServices, s2s2CertificateStoreOrigin, logger, starter)
	calleeAPI, err := newCallee(s2s2dicalleeOptions, logger)
	if err != nil {
		return nil, err
	}
	loggerAPI, err := newS2S2Logger(logger, config)
	if err != nil {
		return nil, err
	}
	s2S2 := newS2S2(s2s2AccessTokens, cachedAuthorizations, config, starter, s2s2ClientServiceURI, logger, s2s2ServiceOrigins, calleeAPI, loggerAPI)
	return s2S2, nil
}
