package cachedvalidation

import (
	"context"
	"strconv"
	"sync"
	"sync/atomic"
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/internal/validation"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

type returnOnceValidations struct {
	Validation *validation.Validation
	sync.Once
}

func (m *returnOnceValidations) Validate(context.Context, []byte) (*validation.Validation, error) {
	return m.Validation, nil
}

func BenchmarkCachedValidation(b *testing.B) {
	ctx := context.Background()

	b.Run("success same hit", func(b *testing.B) {
		val := &validation.Validation{Expiration: time.Now().Add(time.Hour), NotBefore: time.Now().Add(-time.Hour)}
		v := New(&returnOnceValidations{Validation: val}, 1)

		b.RunParallel(func(pb *testing.PB) {
			for pb.Next() {
				res, err := v.Validate(ctx, []byte("derp.herp.berp"))
				require.NoError(b, err)
				assert.Equal(b, val, res)
			}
		})
	})

	b.Run("always new", func(b *testing.B) {
		val := &validation.Validation{Expiration: time.Now().Add(time.Hour), NotBefore: time.Now().Add(-time.Hour)}
		v := New(&returnOnceValidations{Validation: val}, 1)

		thread := new(int32)
		b.RunParallel(func(pb *testing.PB) {
			nThread := atomic.AddInt32(thread, 1)
			for pb.Next() {
				res, err := v.Validate(ctx, []byte("derp.herp.berp"+strconv.Itoa(int(nThread))))
				require.NoError(b, err)
				assert.Equal(b, val, res)
			}
		})
	})
}
