package cert

import (
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/internal/logutil"
)

func BenchmarkLog(b *testing.B) {
	c := &unknownCallerLogger{
		logger:                         logutil.NoopLogger,
		unknownCallersMap:              make(map[string]bool),
		UnknownCallerLoggerRateLimiter: time.NewTicker(time.Millisecond).C,
	}

	b.RunParallel(func(pb *testing.PB) {
		for pb.Next() {
			c.LogUnknownCaller("test")
		}
	})

}
