package cert

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/internal/cert/mocks"
	"github.com/golang/mock/gomock"
)

//go:generate mockgen -package mocks -destination ./mocks/logger.go code.justin.tv/amzn/TwitchLogging Logger

func TestLog(t *testing.T) {
	t.Run("success", func(t *testing.T) {
		ctrl := gomock.NewController(t)
		defer ctrl.Finish()
		mockLogger := mocks.NewMockLogger(ctrl)

		c := &unknownCallerLogger{
			logger:                         mockLogger,
			unknownCallersMap:              make(map[string]bool),
			UnknownCallerLoggerRateLimiter: time.NewTicker(time.Millisecond).C,
		}
		firstTest := "test1"
		secondTest := "test2"
		testSlice := []string{firstTest, secondTest}

		gomock.InOrder(
			mockLogger.EXPECT().Log("UnknownCallersReceived", "x5us", []string{firstTest}),
			mockLogger.EXPECT().
				Log("UnknownCallersReceived", "x5us", gomock.Any()).
				Do(func(arg1 string, keyvals ...interface{}) {
					arg3 := keyvals[1].([]string)
					assert.ElementsMatch(t, testSlice, arg3)
				}),
		)

		c.LogUnknownCaller(firstTest)
		// Sleep to ensure the ticker has advanced
		time.Sleep(2 * time.Millisecond)
		c.LogUnknownCaller(secondTest)

		assert.Len(t, c.unknownCallersMap, 0)
	})
}
