package logutil

import (
	"errors"
	"net/http"
	"testing"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/internal/logutil/mocks"
	"github.com/golang/mock/gomock"
)

func TestLogger(t *testing.T) {
	t.Run("LogAnonymousRequest", func(t *testing.T) {
		ctrl := gomock.NewController(t)
		defer ctrl.Finish()
		logger := mocks.NewMockLogger(ctrl)

		logger.EXPECT().Log(
			"AnonymousRequestReceived",
			"client_ip", "remoteAddr",
			"x_forwarded_for", "forwardedFor",
			"x_forwarded_proto", "formardedProto",
			"x_forwarded_port", "formardedPort",
		)

		(&Logger{Logger: logger}).LogAnonymousRequest(&http.Request{
			RemoteAddr: "remoteAddr",
			Header: http.Header{
				"X-Forwarded-For":   []string{"forwardedFor"},
				"X-Forwarded-Proto": []string{"formardedProto"},
				"X-Forwarded-Port":  []string{"formardedPort"},
			},
		})
	})

	t.Run("LogUnknownError", func(t *testing.T) {
		ctrl := gomock.NewController(t)
		defer ctrl.Finish()
		logger := mocks.NewMockLogger(ctrl)

		myErr := errors.New("myErr")

		logger.EXPECT().Log("UnknownError", "err", myErr.Error())

		(&Logger{Logger: logger}).LogUnknownError(myErr)
	})

	t.Run("LogUncachedX5U", func(t *testing.T) {
		ctrl := gomock.NewController(t)
		defer ctrl.Finish()
		logger := mocks.NewMockLogger(ctrl)

		logger.EXPECT().Log("LogUncachedX5U", "x5u", "myx5u")

		(&Logger{Logger: logger}).LogUncachedX5U("myx5u")
	})
}
