package validation

import (
	"encoding/json"
	"strconv"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestUnixTime(t *testing.T) {
	t.Run("success", func(t *testing.T) {
		now := time.Now().UTC().Truncate(time.Second)

		var unmarshaled unixTime
		require.NoError(t, json.Unmarshal([]byte(strconv.FormatInt(now.Unix(), 10)), &unmarshaled))
		assert.Equal(t, now, time.Time(unmarshaled))
	})

	t.Run("wrong type", func(t *testing.T) {
		assert.Contains(t, json.Unmarshal([]byte("\"derp\""), new(unixTime)).Error(), "cannot unmarshal")
	})
}
