package s2s2dicallee

import (
	"testing"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/internal/service"
	"github.com/stretchr/testify/assert"
)

func TestAuthenticatedSubject(t *testing.T) {
	const serviceDomain = "twitch"
	const serviceName = "serviceName"
	const serviceStage = "serviceStage"

	s := authenticatedSubject{
		service: service.Service{
			Domain: serviceDomain,
			Name:   serviceName,
			Stage:  serviceStage,
		},
	}

	assert.Equal(t, serviceDomain, s.Domain())
	assert.Equal(t, serviceName, s.Service())
	assert.Equal(t, serviceStage, s.Stage())
	assert.True(t, s.IsTwitchService(serviceName, serviceStage))
	assert.False(t, s.IsTwitchService(serviceName, "soemtihng else"))
	assert.False(t, s.IsTwitchService("something else", serviceStage))
}
