package s2s2dicallee

import (
	"context"
	"testing"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/internal/service"
	"github.com/stretchr/testify/assert"
)

func TestRequestSubject(t *testing.T) {
	ctx := context.Background()
	t.Run("not set", func(t *testing.T) {
		_, ok := RequestSubject(ctx)
		assert.False(t, ok)
	})

	t.Run("set", func(t *testing.T) {
		s := authenticatedSubject{service: service.Service{Domain: "myDomain"}}
		val, ok := RequestSubject(SetRequestSubject(ctx, s))
		assert.True(t, ok)
		assert.Equal(t, s, val)
	})
}
