package s2s2dicallee

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestErrorCodeString(t *testing.T) {
	tcs := []struct {
		Code     int
		Expected string
	}{
		{Code: 400, Expected: "out_of_range"},
		{Code: 401, Expected: "unauthenticated"},
		{Code: 403, Expected: "permission_denied"},
		{Code: 404, Expected: "not_found"},
		{Code: 408, Expected: "canceled"},
		{Code: 409, Expected: "already_exists"},
		{Code: 412, Expected: "failed_precondition"},
		{Code: 500, Expected: "internal"},
		{Code: 503, Expected: "unavailable"},
		{Code: 420, Expected: ""},
	}

	for _, tc := range tcs {
		assert.Equal(t, tc.Expected, errorCodeString(tc.Code))
	}
}
