package s2s2dicallee_test

import (
	"net/http"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCallee/s2s2dicallee"
)

func ExampleCallee() {
	callee, err := s2s2dicallee.New(&s2s2dicallee.Options{
		WebOrigins: []string{
			"https://my.service.url",
		},
		AuthorizedServices: []s2s2dicallee.Service{
			{Name: "example-service-name", Stage: "example service stage"},
		},
		// these should be non nil. These are the Twitch-wide telemetry and logging
		// standards
		OperationStarter: nil,
		Logger:           nil,
	})

	if err != nil {
		// handle error
	}

	// now that you have a callee, you can wrap http.Handler objects. this will
	// return 401 for unauthorized callers
	http.ListenAndServe(":8080", callee.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		// information about the caller can be retrieved with this
		requestSubject, ok := s2s2dicallee.RequestSubject(r.Context())
		if !ok {
			// should not get here if we're not in RecordMetricsOnly
		}

		if requestSubject.IsTwitchService("graphql", "prod") {
			// you can make authorization decisions based on this as well
		} else {
			// reject request
		}
	})))

	http.ListenAndServe(":8080",
		callee.Handler(http.HandlerFunc(func(http.ResponseWriter, *http.Request) {
		})).RecordMetricsOnly(), // if you want to record metrics for onboarding
	)
}
