package cacheitem

import "time"

type CacheItem struct {
	Token             []byte
	CreationTime      time.Time
	StaleTimeout      time.Duration
	ExpirationTimeout time.Duration
}

func (cv CacheItem) IsStale() bool {
	return time.Now().After(cv.CreationTime.Add(cv.StaleTimeout))
}

func (cv CacheItem) IsExpired() bool {
	return time.Now().After(cv.CreationTime.Add(cv.ExpirationTimeout))
}
