package cacheitem

import (
	"testing"
	"time"

	"github.com/stretchr/testify/require"
)

func TestCacheItem(t *testing.T) {
	var item = CacheItem{
		Token:             []byte("token"),
		CreationTime:      time.Now(),
		StaleTimeout:      time.Hour,
		ExpirationTimeout: time.Hour * 12,
	}

	t.Run("Succeess on IsStale", func(t *testing.T) {
		ret := item.IsStale()
		require.Equal(t, false, ret)
	})

	t.Run("Failure on IsStale", func(t *testing.T) {
		item.CreationTime = time.Now().Add(-time.Hour * 20)
		ret := item.IsStale()
		require.Equal(t, true, ret)
	})

	t.Run("Success on IsExpire", func(t *testing.T) {
		item.CreationTime = time.Now().Add(-time.Hour * 20)
		ret := item.IsExpired()
		require.Equal(t, true, ret)
	})

	t.Run("Failure on IsExpire", func(t *testing.T) {
		item.CreationTime = time.Now().Add(-time.Hour * 2)
		ret := item.IsExpired()
		require.Equal(t, false, ret)
	})
}
