package opwrap

import "code.justin.tv/video/metrics-middleware/v2/operation"

const twitchS2S2DICallerOperationGroupName = "twitchs2s2"
const (
	statusUnknown int32 = 2
)

// GetAuthToken is when KMS keys are used to generate the authentication
// token.
var GetAuthToken = operation.Name{
	Kind:   operation.KindClient,
	Group:  twitchS2S2DICallerOperationGroupName,
	Method: "GetAuthToken",
}

// GetAuthTokenInBackground is when GetAuthToken is called during a background
// cache refresh.
var GetAuthTokenInBackground = operation.Name{
	Kind:   operation.KindClient,
	Group:  twitchS2S2DICallerOperationGroupName,
	Method: "GetAuthTokenInBackground",
}

// EndWithError wraps an operation End with setting error status
func EndWithError(op *operation.Op, err error) {
	if err != nil {
		status := statusUnknown
		if err, ok := err.(interface {
			StatusCode() int32
		}); ok {
			status = err.StatusCode()
		}
		op.SetStatus(operation.Status{Code: status})
	}
	op.End()
}
