package s2s2err

import logging "code.justin.tv/amzn/TwitchLogging"

const s2s2DistributedIdentitiesErrorType = "S2S2DistributedIdentitiesError"

// Logger logs errors that happen outside of the direct request path
type Logger struct {
	Logger logging.Logger
}

// LogError logs an error that happens outside of the direct request path
func (l Logger) LogError(err error) {
	if l.Logger != nil {
		l.Logger.Log(err.Error(), "error", s2s2DistributedIdentitiesErrorType)
	}
}
