package s2s2err

import (
	"errors"
	"testing"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCaller/internal/mocks"
	"github.com/golang/mock/gomock"
)

func TestLoggerLogError(t *testing.T) {
	new(Logger).LogError(errors.New("placeholder"))

	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	mockLogger := mocks.NewMockLogger(ctrl)
	loggerConfigured := &Logger{Logger: mockLogger}

	mockLogger.EXPECT().Log("placeholder", "error", s2s2DistributedIdentitiesErrorType)

	loggerConfigured.LogError(errors.New("placeholder"))
}
