package s2s2dicaller

import (
	"context"
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCaller/internal/mocks"
	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCaller/internal/mocks/cachedauthenticationmock"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestCallerHTTPClient(t *testing.T) {
	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	authentications := cachedauthenticationmock.NewMockCachedAuthenticationsAPI(ctrl)
	inner := mocks.NewMockHTTPClient(ctrl)
	caller := &Caller{authentications: authentications}

	assert.Equal(t, &authenticatingHTTPClient{
		Authentications: authentications,
		Inner:           inner,
	}, caller.HTTPClient(inner))
}

func TestCallerPrewarmForHost(t *testing.T) {
	const audience = "https://my.host"
	ctx := context.Background()

	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	authentications := cachedauthenticationmock.NewMockCachedAuthenticationsAPI(ctrl)
	caller := &Caller{authentications: authentications}

	authentications.EXPECT().Authenticate(ctx, audience)

	require.NoError(t, caller.PrewarmForHost(ctx, audience))
}

func TestCallerHardRefreshCache(t *testing.T) {
	ctx := context.Background()

	t.Run("success", func(t *testing.T) {
		ctrl := gomock.NewController(t)
		defer ctrl.Finish()

		authentications := cachedauthenticationmock.NewMockCachedAuthenticationsAPI(ctrl)
		caller := &Caller{authentications: authentications, hardRefreshCacheTicker: time.NewTicker(time.Millisecond)}

		authentications.EXPECT().HardRefreshCache(ctx)

		assert.NoError(t, caller.HardRefreshCache(ctx))
	})

	t.Run("context cancelled", func(t *testing.T) {
		ctx, cancel := context.WithCancel(ctx)
		cancel()

		caller := &Caller{hardRefreshCacheTicker: time.NewTicker(time.Millisecond)}
		assert.Error(t, caller.HardRefreshCache(ctx))
	})
}
