package s2s2dicaller

import (
	"fmt"
	"net/url"
)

// ErrRefusingToSendToNonHTTPS is returned when a client attempts to send a
// token to a non-tls endpoint.
type ErrRefusingToSendToNonHTTPS struct {
	URL url.URL
}

func (err ErrRefusingToSendToNonHTTPS) Error() string {
	return fmt.Sprintf("refusing to send access token to non https endpoint: %s", err.URL.String())
}
