package s2s2dicaller

import (
	"context"
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchS2S2DistributedIdentitiesCaller/internal/cachedauthentication"
	"code.justin.tv/video/metrics-middleware/v2/operation"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestNewCaller(t *testing.T) {
	cachedAuthentications := &cachedauthentication.CachedAuthentications{}
	hardRefreshCacheTicker := time.NewTicker(time.Minute)
	defer hardRefreshCacheTicker.Stop()
	assert.Equal(t,
		&Caller{
			authentications:        cachedAuthentications,
			dangerouslyAllowNonTLS: true,
			hardRefreshCacheTicker: hardRefreshCacheTicker,
		},
		newCaller(
			&Options{
				DangerouslyAllowNonTLS: true,
			},
			cachedAuthentications,
			hardRefreshCacheTicker,
		),
	)
}

type dummyOpMonitor struct{}

func (dummyOpMonitor) MonitorOp(ctx context.Context, _ operation.Name) (context.Context, *operation.MonitorPoints) {
	return ctx, nil
}

func TestNewOperationStarter(t *testing.T) {
	assert.Equal(t, &operation.Starter{}, newOperationStarter(&Options{}))

	assert.Equal(t,
		&operation.Starter{
			OpMonitors: []operation.OpMonitor{dummyOpMonitor{}},
		},
		newOperationStarter(&Options{
			OperationStarter: &operation.Starter{
				OpMonitors: []operation.OpMonitor{dummyOpMonitor{}},
			},
		}),
	)
}

func TestNewServiceDomain(t *testing.T) {
	assert.Equal(t, defaultServiceDomain, newServiceDomain(&Options{}))

	const customServiceDomain = "derp"
	assert.Equal(t,
		serviceDomain(customServiceDomain),
		newServiceDomain(&Options{ServiceDomain: customServiceDomain}),
	)
}

func TestNewIdentityOrigin(t *testing.T) {
	assert.Equal(t, defaultIdentityOrigin, newIdentityOrigin(&Options{}))

	const customIdentityOrigin = "derp"
	assert.Equal(t,
		identityOrigin(customIdentityOrigin),
		newIdentityOrigin(&Options{IdentityOrigin: customIdentityOrigin}),
	)
}

func TestNewServiceName(t *testing.T) {
	const customServiceName = "derp"
	res, err := newServiceName(&Options{ServiceName: customServiceName})
	require.NoError(t, err)
	assert.Equal(t, serviceName(customServiceName), res)

	_, err = newServiceName(&Options{})
	assert.Equal(t, errServiceNameMissing, err)
}

func TestNewStage(t *testing.T) {
	const customStage = "derp"
	res, err := newStage(&Options{Stage: customStage})
	require.NoError(t, err)
	assert.Equal(t, stage(customStage), res)

	_, err = newStage(&Options{})
	assert.Equal(t, errStageMissing, err)
}

func TestNewHardRefreshCacheTicker(t *testing.T) {
	assert.NotEmpty(t, newHardRefreshCacheTicker())
}
