package es256

import (
	"encoding/json"
	"math/big"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestBigInt(t *testing.T) {
	t.Run("Marshals/Unmarshals base64 encoded string", func(t *testing.T) {
		myInt := &bigInt{
			Int: big.NewInt(99),
		}

		marshaledInt, err := json.Marshal(myInt)
		require.NoError(t, err)

		unmarshaled := &bigInt{}
		err = json.Unmarshal(marshaledInt, unmarshaled)
		require.NoError(t, err)

		assert.Equal(t, myInt, unmarshaled)
	})
}
