package es256

import (
	"crypto/ecdsa"
	"crypto/elliptic"
	"encoding/json"
	"math/big"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestPublicKey(t *testing.T) {
	testEcdsaPubKey := &PublicKey{
		PublicKey: &ecdsa.PublicKey{
			Curve: elliptic.P256(),
			X:     big.NewInt(11),
			Y:     big.NewInt(13),
		},
		KeyID: "my key id",
	}

	t.Run("Marshals and unmarshals into ecdsa pub key as json", func(t *testing.T) {
		marshalled, err := json.Marshal(testEcdsaPubKey)
		require.NoError(t, err)

		var unmarshaledPubKey PublicKey

		err = json.Unmarshal(marshalled, &unmarshaledPubKey)
		require.NoError(t, err)

		assert.Equal(t, *testEcdsaPubKey, unmarshaledPubKey)
	})
}
