package es256

import (
	"math/big"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestEcdsaSignature(t *testing.T) {
	testCases := []*signature{
		{
			R: big.NewInt(100),
			S: big.NewInt(2 ^ (32 * 8)),
		},
		{
			R: big.NewInt(2 ^ (32 * 8)),
			S: big.NewInt(100),
		},
	}

	t.Run("Encode and Decode succeeds", func(t *testing.T) {
		for _, testCase := range testCases {
			encodedSig, err := testCase.Encode()
			require.NoError(t, err)

			resultEcdsa := &signature{}
			err = resultEcdsa.Decode(encodedSig)
			require.NoError(t, err)

			assert.Equal(t, *testCase, *resultEcdsa)
		}
	})

	t.Run("Decode fails with large input", func(t *testing.T) {
		testEcdsa := &signature{}
		err := testEcdsa.Decode(make([]byte, 100))
		require.Error(t, err)
	})
}
