package es256

import (
	"encoding/json"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestStringSet(t *testing.T) {
	t.Run("marshalling", func(t *testing.T) {
		value := newStringSet()
		value.Add("a")
		value.Add("b")

		t.Run("json", func(t *testing.T) {
			marshalled, err := json.Marshal(value)
			require.NoError(t, err)

			var unmarshalled stringSet
			require.NoError(t, json.Unmarshal(marshalled, &unmarshalled))
			assert.Equal(t, value, &unmarshalled)
		})
	})

	t.Run("Add", func(t *testing.T) {
		ss := newStringSet()
		ss.Add("abc")
		assert.Equal(t, &stringSet{keys: map[string]interface{}{"abc": nil}}, ss)
	})

	t.Run("Delete", func(t *testing.T) {
		t.Run("hit", func(t *testing.T) {
			ss := newStringSet()
			ss.Add("abc")
			ss.Delete("abc")
			assert.Equal(t, &stringSet{keys: map[string]interface{}{}}, ss)
		})

		t.Run("miss", func(t *testing.T) {
			ss := newStringSet()
			ss.Add("abc")
			ss.Delete("miss")
			assert.Equal(t, &stringSet{keys: map[string]interface{}{"abc": nil}}, ss)
		})
	})

	t.Run("Has", func(t *testing.T) {
		ss := newStringSet()
		ss.Add("abc")
		assert.True(t, ss.Has("abc"))
		assert.False(t, ss.Has("def"))
	})

	t.Run("IsSubset", func(t *testing.T) {
		s1 := newStringSet()
		s1.Add("1")
		s1.Add("2")
		s1.Add("3")

		s2 := newStringSet()
		s2.Add("2")
		s2.Add("3")

		assert.True(t, s2.IsSubset(s1))
		assert.False(t, s1.IsSubset(s2))
	})
}
