# TwitchS2SLegacyMigrationMiddleware

This package provides middleware designed to help service owners transition from
using [S2Sv0] to using [S2S2].

See [example usage] for code examples on how to use this package.

## What this Does

This package checks for both S2Sv0 and S2S2 authentication when at runtime. If
neither are presented, the request is rejected. If either are presented, the
subject is provided to your service in the request context in a version agnostic
form.

## How do I understand my migration progress?

The following logs are published into your CloudWatch logs when a S2Sv0 caller
is authenticated. These logs are sampled at a default rate of 1 message per
second.

```
{
  "msg": "LegacyS2Sv0CallerDetected",
  "ServiceName": "my-s2sv0-service"
}
```

[S2Sv0]: https://wiki.twitch.com/display/SSE/%28S2Sv0+Auth%29+Service+to+Service+Authentication+and+Authorization
[S2S2]: https://wiki.twitch.com/display/SSE/S2S2%3A+Service+to+Service+Auth+at+Twitch
[example usage]: https://code.amazon.com/packages/TwitchS2SLegacyMigrationMiddleware/trees/mainline/--/twitchs2smigration/example_middleware_test.go
