package twitchs2smigration_test

import (
	"fmt"
	"net/http"

	logging "code.justin.tv/amzn/TwitchLogging"
	"code.justin.tv/amzn/TwitchS2S2/s2s2"
	"code.justin.tv/amzn/TwitchS2SLegacyMigrationMiddleware/twitchs2smigration"
	"code.justin.tv/sse/malachai/pkg/s2s/callee"
)

// Creating a new Middleware and using with an existing application handler
func ExampleMiddleware() {
	// see this package on how to create a s2sv0 client
	// code.justin.tv/sse/malachai
	var s2sv0Client *callee.Client
	// see this package on how to create a s2s2 client
	// code.justin.tv/amzn/TwitchS2S2
	var s2s2Client *s2s2.S2S2
	// logger to post information on migration state from. see this package
	// http://code.amazon.com/packages/TwitchLogging
	var logger logging.Logger

	// create a migration middleware
	migration, err := twitchs2smigration.New(
		s2sv0Client,
		s2s2Client,
		logger,
	)
	if err != nil {
		// handle err
	}

	// this is what will happen in your application handler
	handlerFunc := http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		subject := twitchs2smigration.RequestSubject(r.Context())
		// here, subject is guaranteed to be one of my-s2sv0-service or
		// my-s2s2-service
		w.Write([]byte(fmt.Sprintf("hello %v", subject)))
	})

	http.ListenAndServe(":8080",
		// this is how you require authentication from a set of callers
		migration.RequireAuthentication(
			handlerFunc,
			&twitchs2smigration.RequireAuthenticationOptions{
				AuthorizedCallers: []twitchs2smigration.Service{
					twitchs2smigration.MustService(migration.Service("my-s2sv0-service")),
					twitchs2smigration.MustService(migration.Service("my-s2s2-service")),
				},
			},
		))
}
