package twitchs2smigration

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestServiceGet(t *testing.T) {
	_, ok := newServiceSet().Get("abc")
	assert.False(t, ok, "empty set should returns false on check")
	svc, ok := newServiceSet(service{ID: "abc", Name: "name"}).Get("abc")
	assert.True(t, ok, "set contains service")
	assert.Equal(t, service{ID: "abc", Name: "name"}, svc)
	_, ok = newServiceSet(service{ID: "def"}).Get("abc")
	assert.False(t, ok, "set does not contain service")
}
