package twitchs2smigration

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestMustService(t *testing.T) {
	assert.Panics(t, func() {
		MustService(nil, errors.New("myerr"))
	})
	MustService(nil, nil)
}

func TestService(t *testing.T) {
	assert.Equal(t, "id", (service{ID: "id"}).id())
	assert.Equal(t, "name", (service{Name: "name"}).name())
}

func TestDistributedIdentityService(t *testing.T) {
	assert.Equal(t, "id", (distributedIdentityService{ID: "id"}).id())
}
