// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchSafetyChannelBanTwirp/twirp.proto

/*
Package TwitchSafetyChannelBanTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchSafetyChannelBanTwirp/twirp.proto
*/
package TwitchSafetyChannelBanTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ================================
// TwitchSafetyChannelBan Interface
// ================================

type TwitchSafetyChannelBan interface {
	// BanUserInChannel applies a ban action (Permanent/temporary ban) on a user for a certain channel.
	BanUserInChannel(context.Context, *BanUserInChannelRequest) (*BanUserInChannelResponse, error)

	// UnbanUserInChannel deletes banned action (Permanent/Temporary ban) on a user in a certain channel.
	UnbanUserInChannel(context.Context, *UnbanUserInChannelRequest) (*UnbanUserInChannelResponse, error)

	// IsUserAliasBannedInChannel checks whether a user's alias (email or phone number) is blocked in a given channel.
	IsUserAliasBannedInChannel(context.Context, *IsUserAliasBannedInChannelRequest) (*IsUserAliasBannedInChannelResponse, error)
}

// ======================================
// TwitchSafetyChannelBan Protobuf Client
// ======================================

type twitchSafetyChannelBanProtobufClient struct {
	client HTTPClient
	urls   [3]string
	opts   twirp.ClientOptions
}

// NewTwitchSafetyChannelBanProtobufClient creates a Protobuf client that implements the TwitchSafetyChannelBan interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchSafetyChannelBanProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchSafetyChannelBan {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchSafetyChannelBanPathPrefix
	urls := [3]string{
		prefix + "BanUserInChannel",
		prefix + "UnbanUserInChannel",
		prefix + "IsUserAliasBannedInChannel",
	}

	return &twitchSafetyChannelBanProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchSafetyChannelBanProtobufClient) BanUserInChannel(ctx context.Context, in *BanUserInChannelRequest) (*BanUserInChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithMethodName(ctx, "BanUserInChannel")
	out := new(BanUserInChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSafetyChannelBanProtobufClient) UnbanUserInChannel(ctx context.Context, in *UnbanUserInChannelRequest) (*UnbanUserInChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithMethodName(ctx, "UnbanUserInChannel")
	out := new(UnbanUserInChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSafetyChannelBanProtobufClient) IsUserAliasBannedInChannel(ctx context.Context, in *IsUserAliasBannedInChannelRequest) (*IsUserAliasBannedInChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAliasBannedInChannel")
	out := new(IsUserAliasBannedInChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================================
// TwitchSafetyChannelBan JSON Client
// ==================================

type twitchSafetyChannelBanJSONClient struct {
	client HTTPClient
	urls   [3]string
	opts   twirp.ClientOptions
}

// NewTwitchSafetyChannelBanJSONClient creates a JSON client that implements the TwitchSafetyChannelBan interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchSafetyChannelBanJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchSafetyChannelBan {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchSafetyChannelBanPathPrefix
	urls := [3]string{
		prefix + "BanUserInChannel",
		prefix + "UnbanUserInChannel",
		prefix + "IsUserAliasBannedInChannel",
	}

	return &twitchSafetyChannelBanJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchSafetyChannelBanJSONClient) BanUserInChannel(ctx context.Context, in *BanUserInChannelRequest) (*BanUserInChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithMethodName(ctx, "BanUserInChannel")
	out := new(BanUserInChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSafetyChannelBanJSONClient) UnbanUserInChannel(ctx context.Context, in *UnbanUserInChannelRequest) (*UnbanUserInChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithMethodName(ctx, "UnbanUserInChannel")
	out := new(UnbanUserInChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSafetyChannelBanJSONClient) IsUserAliasBannedInChannel(ctx context.Context, in *IsUserAliasBannedInChannelRequest) (*IsUserAliasBannedInChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAliasBannedInChannel")
	out := new(IsUserAliasBannedInChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================================
// TwitchSafetyChannelBan Server Handler
// =====================================

type twitchSafetyChannelBanServer struct {
	TwitchSafetyChannelBan
	hooks *twirp.ServerHooks
}

func NewTwitchSafetyChannelBanServer(svc TwitchSafetyChannelBan, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchSafetyChannelBanServer{
		TwitchSafetyChannelBan: svc,
		hooks:                  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchSafetyChannelBanServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchSafetyChannelBanPathPrefix is used for all URL paths on a twirp TwitchSafetyChannelBan server.
// Requests are always: POST TwitchSafetyChannelBanPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchSafetyChannelBanPathPrefix = "/twirp/twitch.channelmoderation.twitchsafetychannelban.TwitchSafetyChannelBan/"

func (s *twitchSafetyChannelBanServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.channelmoderation.twitchsafetychannelban")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSafetyChannelBan")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.channelmoderation.twitchsafetychannelban.TwitchSafetyChannelBan/BanUserInChannel":
		s.serveBanUserInChannel(ctx, resp, req)
		return
	case "/twirp/twitch.channelmoderation.twitchsafetychannelban.TwitchSafetyChannelBan/UnbanUserInChannel":
		s.serveUnbanUserInChannel(ctx, resp, req)
		return
	case "/twirp/twitch.channelmoderation.twitchsafetychannelban.TwitchSafetyChannelBan/IsUserAliasBannedInChannel":
		s.serveIsUserAliasBannedInChannel(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchSafetyChannelBanServer) serveBanUserInChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBanUserInChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBanUserInChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSafetyChannelBanServer) serveBanUserInChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BanUserInChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BanUserInChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BanUserInChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSafetyChannelBan.BanUserInChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BanUserInChannelResponse and nil error while calling BanUserInChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSafetyChannelBanServer) serveBanUserInChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BanUserInChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BanUserInChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BanUserInChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSafetyChannelBan.BanUserInChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BanUserInChannelResponse and nil error while calling BanUserInChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSafetyChannelBanServer) serveUnbanUserInChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUnbanUserInChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUnbanUserInChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSafetyChannelBanServer) serveUnbanUserInChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UnbanUserInChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UnbanUserInChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UnbanUserInChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSafetyChannelBan.UnbanUserInChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UnbanUserInChannelResponse and nil error while calling UnbanUserInChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSafetyChannelBanServer) serveUnbanUserInChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UnbanUserInChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UnbanUserInChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UnbanUserInChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSafetyChannelBan.UnbanUserInChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UnbanUserInChannelResponse and nil error while calling UnbanUserInChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSafetyChannelBanServer) serveIsUserAliasBannedInChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsUserAliasBannedInChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsUserAliasBannedInChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSafetyChannelBanServer) serveIsUserAliasBannedInChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAliasBannedInChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsUserAliasBannedInChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsUserAliasBannedInChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSafetyChannelBan.IsUserAliasBannedInChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsUserAliasBannedInChannelResponse and nil error while calling IsUserAliasBannedInChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSafetyChannelBanServer) serveIsUserAliasBannedInChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAliasBannedInChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IsUserAliasBannedInChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsUserAliasBannedInChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSafetyChannelBan.IsUserAliasBannedInChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsUserAliasBannedInChannelResponse and nil error while calling IsUserAliasBannedInChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSafetyChannelBanServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchSafetyChannelBanServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchSafetyChannelBanServer) PathPrefix() string {
	return TwitchSafetyChannelBanPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 834 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xc6, 0x69, 0x9b, 0x9f, 0x93, 0xdd, 0xd6, 0xcc, 0x96, 0x36, 0x04, 0x01, 0xd9, 0x5c, 0x45,
	0xbd, 0x70, 0x44, 0x10, 0x12, 0x3f, 0x12, 0xd2, 0xb8, 0x71, 0xb5, 0x86, 0xc4, 0xae, 0xc6, 0x0e,
	0xd2, 0xb2, 0x42, 0xd6, 0x24, 0x9e, 0xdd, 0x1a, 0xb5, 0x76, 0xf0, 0x4c, 0x5a, 0xca, 0xa3, 0xf0,
	0x02, 0x5c, 0x71, 0x8f, 0xb8, 0xe7, 0x81, 0x78, 0x00, 0x24, 0x34, 0xe3, 0x71, 0x94, 0x6e, 0xb3,
	0x54, 0x41, 0xed, 0xde, 0x44, 0x9e, 0xf3, 0xf3, 0x7d, 0xe7, 0x7c, 0x39, 0x73, 0x6c, 0xf8, 0x6a,
	0x96, 0xc5, 0xcc, 0xfa, 0x71, 0xc1, 0x45, 0x92, 0x5a, 0xe2, 0xb2, 0x4f, 0x2f, 0x7e, 0x49, 0xfb,
	0xe1, 0x55, 0x22, 0x66, 0x67, 0x01, 0x7d, 0xc9, 0xc4, 0xf5, 0xf1, 0x19, 0x4d, 0x53, 0x76, 0x6e,
	0xd3, 0x34, 0xbc, 0x4a, 0xf2, 0x79, 0x5f, 0xc8, 0x5f, 0x6b, 0x9e, 0x67, 0x22, 0x43, 0xf2, 0x20,
	0x66, 0x67, 0xd6, 0xac, 0x88, 0xb9, 0xc8, 0x62, 0x96, 0x53, 0x91, 0x64, 0xa9, 0x55, 0x38, 0xb8,
	0x42, 0xd0, 0xde, 0x29, 0x4d, 0xdb, 0x1f, 0xbf, 0xca, 0xb2, 0x57, 0xe7, 0xac, 0xaf, 0xd2, 0xa7,
	0x8b, 0x97, 0x7d, 0x91, 0x5c, 0x30, 0x2e, 0xe8, 0x85, 0x46, 0xec, 0xfe, 0x5d, 0x81, 0x7d, 0xcd,
	0x38, 0xe1, 0x2c, 0xb7, 0x69, 0x1a, 0x08, 0x2a, 0x16, 0x1c, 0x7d, 0x08, 0xa0, 0x71, 0xa2, 0x24,
	0x6e, 0x19, 0x1d, 0xa3, 0xd7, 0x20, 0x0d, 0x6d, 0x71, 0x63, 0x74, 0x08, 0xb5, 0x05, 0x67, 0xb9,
	0xf4, 0x55, 0x94, 0xaf, 0x2a, 0x8f, 0x6e, 0x8c, 0x9e, 0xc2, 0xa3, 0x9c, 0xfd, 0xb4, 0x60, 0x5c,
	0x14, 0xde, 0x2d, 0xe5, 0x6d, 0x2e, 0x6d, 0x6e, 0x8c, 0xbe, 0x00, 0x98, 0xe5, 0x8c, 0x0a, 0x16,
	0x47, 0x54, 0xb4, 0xb6, 0x3b, 0x46, 0xaf, 0x39, 0x68, 0x5b, 0x45, 0xa5, 0x56, 0x59, 0xa9, 0x15,
	0x96, 0x95, 0x92, 0x86, 0x8e, 0xc6, 0x42, 0xa6, 0xb2, 0x9f, 0xe7, 0x49, 0xce, 0xb8, 0x4c, 0xdd,
	0xb9, 0x3b, 0x55, 0x47, 0x63, 0x81, 0x02, 0xa8, 0x4f, 0x69, 0x1a, 0x89, 0xeb, 0x39, 0x6b, 0x55,
	0x3b, 0x46, 0x6f, 0x77, 0xf0, 0xb9, 0xb5, 0xa1, 0x9c, 0x96, 0xfc, 0x53, 0xae, 0xe7, 0x8c, 0xd4,
	0xa6, 0xc5, 0x03, 0x3a, 0x80, 0x6a, 0xce, 0x28, 0xcf, 0xd2, 0x56, 0xad, 0x50, 0xa1, 0x38, 0xa1,
	0x0f, 0xa0, 0x91, 0xf0, 0x68, 0x2a, 0x13, 0xe3, 0x56, 0xbd, 0x63, 0xf4, 0xea, 0xa4, 0x9e, 0x70,
	0x5b, 0x9d, 0xbb, 0xff, 0x18, 0x70, 0x68, 0xd3, 0x54, 0xea, 0xed, 0xa6, 0x5a, 0x7c, 0x52, 0xe8,
	0xf3, 0x90, 0xb2, 0xb7, 0xa1, 0x1e, 0x2f, 0x8a, 0xfe, 0x94, 0xe8, 0x3b, 0x64, 0x79, 0x5e, 0xe9,
	0x63, 0xe7, 0x46, 0x1f, 0x0f, 0x21, 0x5a, 0xf7, 0x1a, 0x5a, 0xb7, 0xdb, 0xe7, 0xf3, 0x2c, 0xe5,
	0x0c, 0xfd, 0x00, 0x55, 0xae, 0x06, 0x50, 0xf5, 0xde, 0x1c, 0x38, 0x1b, 0xd3, 0xad, 0x9b, 0x66,
	0xa2, 0x41, 0xbb, 0x97, 0xf0, 0xfe, 0x24, 0x9d, 0xbe, 0x75, 0xed, 0xbb, 0x57, 0xd0, 0x5e, 0xc7,
	0xab, 0x9b, 0x7e, 0x40, 0xe2, 0x17, 0xf0, 0xd4, 0xe5, 0x92, 0x15, 0x9f, 0x27, 0x54, 0x0f, 0xe0,
	0xad, 0xc6, 0x57, 0x08, 0x8c, 0x1b, 0x04, 0x37, 0x0b, 0xab, 0xbc, 0x56, 0x58, 0xf7, 0x0f, 0x03,
	0xba, 0xff, 0x85, 0xae, 0xdb, 0xfb, 0x0c, 0x0e, 0xa9, 0xf4, 0xeb, 0xfb, 0x10, 0x25, 0x69, 0xa4,
	0x31, 0x14, 0x5d, 0x9d, 0xec, 0xd3, 0x35, 0xe9, 0xe8, 0x05, 0x34, 0x8b, 0x34, 0x39, 0x7d, 0xbc,
	0x55, 0xe9, 0x6c, 0xf5, 0x76, 0x07, 0x5f, 0x6e, 0x3c, 0x0f, 0xaa, 0x34, 0x35, 0x80, 0x40, 0xcb,
	0x47, 0x7e, 0xf4, 0x35, 0xd4, 0xf4, 0x5c, 0xa2, 0x7d, 0x30, 0x5d, 0xef, 0x3b, 0x3c, 0x72, 0x87,
	0x91, 0x8d, 0xbd, 0x28, 0x7c, 0x7e, 0xea, 0x98, 0xef, 0xa0, 0xc7, 0xd0, 0x38, 0x75, 0xc8, 0x18,
	0x7b, 0x8e, 0x17, 0x9a, 0x06, 0xda, 0x05, 0x08, 0x1d, 0x32, 0x3e, 0xf5, 0x09, 0x26, 0xcf, 0xcd,
	0xca, 0xd1, 0xaf, 0x15, 0x78, 0x4f, 0x8e, 0x17, 0xcb, 0x2f, 0x93, 0x19, 0x73, 0xf2, 0x3c, 0xcb,
	0x49, 0x71, 0x65, 0x0e, 0x00, 0x95, 0x70, 0x0e, 0x21, 0x3e, 0x89, 0x8e, 0xfd, 0xa1, 0x04, 0xec,
	0xc2, 0x47, 0xa1, 0xa3, 0x01, 0x14, 0x51, 0x19, 0x35, 0x9c, 0x10, 0x1c, 0xba, 0xbe, 0x67, 0x1a,
	0xe8, 0x10, 0x9e, 0x4c, 0x02, 0x87, 0x44, 0x78, 0x44, 0x1c, 0x3c, 0x54, 0x61, 0x9e, 0x33, 0x34,
	0x2b, 0xe8, 0x09, 0xec, 0x29, 0x87, 0xe7, 0x87, 0xa5, 0x71, 0x0b, 0xbd, 0x0b, 0x8f, 0x6d, 0x5c,
	0x14, 0x8d, 0x87, 0x63, 0xd7, 0x33, 0xb7, 0x57, 0x4d, 0x41, 0x88, 0x4f, 0x4e, 0xcc, 0x1d, 0x64,
	0xc2, 0xa3, 0xa5, 0xc9, 0x19, 0x9d, 0x98, 0x55, 0xb4, 0x07, 0xcd, 0xd2, 0x32, 0xf6, 0x87, 0x66,
	0x4d, 0xd2, 0x96, 0x06, 0x9b, 0xf8, 0x78, 0x78, 0x8c, 0x83, 0xd0, 0x21, 0x66, 0x5d, 0xc2, 0x79,
	0x7e, 0x24, 0x75, 0x70, 0x83, 0x40, 0x96, 0xd8, 0x90, 0x6d, 0x2c, 0x75, 0x59, 0xdf, 0x06, 0x1c,
	0x8d, 0xa0, 0xb1, 0x54, 0x7d, 0x55, 0x0f, 0x3c, 0x72, 0x71, 0x50, 0x0a, 0xbc, 0x07, 0x4d, 0x67,
	0x8c, 0xdd, 0x51, 0x61, 0x35, 0x0d, 0x19, 0x78, 0xfa, 0xcc, 0xf7, 0x9c, 0xc8, 0x9b, 0x8c, 0x6d,
	0x25, 0x82, 0xb4, 0x57, 0x06, 0x7f, 0x6e, 0xc3, 0xc1, 0xfa, 0x17, 0x24, 0xfa, 0xcd, 0x00, 0xf3,
	0xf5, 0x55, 0x82, 0x9e, 0xfd, 0x9f, 0x0d, 0xb5, 0x6e, 0x21, 0xb4, 0xdd, 0x7b, 0x40, 0xd2, 0x77,
	0xe0, 0x77, 0x03, 0xd0, 0xed, 0x0d, 0x80, 0xbe, 0xd9, 0x98, 0xe1, 0x8d, 0xeb, 0xab, 0xfd, 0xed,
	0xbd, 0x60, 0xe9, 0x7a, 0xff, 0x32, 0xa0, 0xfd, 0xe6, 0xab, 0x8d, 0xc8, 0xc6, 0x5c, 0x77, 0x6e,
	0xa1, 0x76, 0x70, 0xaf, 0x98, 0x45, 0x1f, 0xf6, 0x27, 0xdf, 0xf7, 0x37, 0xfc, 0xe0, 0x9a, 0x56,
	0xd5, 0x77, 0xc4, 0xa7, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x38, 0x2f, 0xc6, 0x7f, 0xaa, 0x09,
	0x00, 0x00,
}
